<?php
/**
 * Template Name: Team Page
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Business_One_Page_Pro
 */

get_header(); ?>

<div class="team-section">
	<div class="container">
		
        
        <?php 
        while ( have_posts() ) : the_post();
            the_content(); 
        endwhile; // End of the loop.
        ?>
        
        
        <div class="row js-masonry">
		    <?php 
                $arg = array(
                    'post_type'     => 'team',
                    'post_status'   => 'publish',
                    'posts_per_page'=> -1
                );
                
                $team_query = new WP_Query( $arg );
                if( $team_query->have_posts() ){
                    while( $team_query->have_posts() ){
                        $team_query->the_post();
                        $designation = get_post_meta( get_the_ID(), '_business_one_page_pro_team_designation', true );
                        $facebook    = get_post_meta( get_the_ID(), '_business_one_page_pro_team_facebook', true );
                        $twitter     = get_post_meta( get_the_ID(), '_business_one_page_pro_team_twitter', true );
                        $dribble     = get_post_meta( get_the_ID(), '_business_one_page_pro_team_dribble', true );
                        $linkedin    = get_post_meta( get_the_ID(), '_business_one_page_pro_team_linkedin', true );
                        $pinterest   = get_post_meta( get_the_ID(), '_business_one_page_pro_team_pinterest', true );
                        ?>
                        <div class="col">
            				<div class="box">
            					<?php if( has_post_thumbnail() ){?>
                                    <div class="img-holder"><?php the_post_thumbnail( 'business-one-page-pro-team' ); ?></div>
                                <?php } ?>
                                
            					<div class="text-holder">
            						<h3 class="name"><?php the_title(); ?></h3>
            						<?php if( $designation ){ ?>
                                    <span class="designation"><?php echo esc_html( $designation ); ?></span>
                                    <?php } ?>
            						<?php the_content(); ?>
            					</div>
            					
                                <?php if( $facebook || $twitter || $dribble || $linkedin || $pinterest ){ ?>
                                <ul class="social-networks">
            						<?php if( $facebook ){?>
                                    <li><a href="<?php echo esc_url( $facebook ); ?>" class="fa fa-facebook" target="_blank"></a></li>
                                    <?php } if( $twitter ){ ?>
            						<li><a href="<?php echo esc_url( $twitter ); ?>" class="fa fa-twitter" target="_blank"></a></li>
                                    <?php } if( $dribble ){ ?>
            						<li><a href="<?php echo esc_url( $dribble );?>" class="fa fa-dribbble" target="_blank"></a></li>
                                    <?php } if( $linkedin ){ ?>
            						<li><a href="<?php echo esc_url( $linkedin ); ?>" class="fa fa-linkedin" target="_blank"></a></li>
                                    <?php } if( $pinterest ){ ?>
            						<li><a href="<?php echo esc_url( $pinterest ); ?>" class="fa fa-pinterest-p" target="_blank"></a></li>
                                    <?php } ?>
            					</ul>
                                <?php } ?>
            				</div>
            			</div>	
                        <?php
                    }
                }
            ?>            
		</div><!-- .row -->
        
	</div><!-- .container -->
</div><!-- .team-section -->
            
<?php
get_footer();