<?php
/**
 * Template Name: Portfolio Page
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Business_One_Page_Pro
 */

get_header(); ?>

<div class="portfolio-section">
    <div class="container">
            
        <?php 
            $args = array(
                'taxonomy'      => 'portfolio-category',
                'orderby'       => 'name', 
                'order'         => 'ASC',
            );                
            $terms = get_terms( $args );
            if( $terms ){
            ?>
            <div class="button-group filter-button-group">        
                <button data-filter="*" class="is-active"><?php echo esc_html_e( 'All', 'business-one-page-pro' ); ?></button>
                <?php
                    foreach( $terms as $t ){
                        echo '<button data-filter=".' . esc_attr( $t->slug ) .  '">' . esc_html( $t->name ) . '</button>';
                } 
                ?>
            </div>            
            <?php
            }
        ?>

        <?php
            $portfolio_qry = new WP_Query( array( 'post_type' => 'portfolio', 'post_status' => 'publish', 'posts_per_page' => -1 ) );
            if( $portfolio_qry->have_posts() ){
        ?>
        <div class="portfolio-grid">
            <?php
                while( $portfolio_qry->have_posts() ){
                    $portfolio_qry->the_post();
                    $terms = get_the_terms( get_the_ID(), 'portfolio-category' );
                    $s = '';
                    $i = 0;
                    if( $terms ){
                        foreach( $terms as $t ){
                            $i++;
                            $s .= $t->slug;
                            if( count( $terms ) > $i ){
                                $s .= ' ';
                            }
                        }
                    }                    
                    if( has_post_thumbnail() ){
                    ?>
                    <div class="portfolio-element <?php echo esc_attr( $s );?>">
                        <div class="portfolio-image">
                            <?php the_post_thumbnail( 'medium' ); ?>     
                            <div class="portfolio-hover">
                                <div class="table">
                                    <div class="table-row">
                                        <div class="table-cell">
                                            <a href="<?php the_permalink(); ?>"><span class="fa fa-search"></span></a>
                                            <h2><?php the_title(); ?></h2>
                                            <?php business_one_page_pro_portfolio_categories(); ?>
                                        </div>
                                    </div>
                                </div>                                
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                }
            ?>        
        </div>
        <?php  } ?>
    </div>
</div>
            
<?php
get_footer();