<?php
/**
 * Template part for displaying Feature Section in Service Page
 *
 * @package Business_One_Page_Pro
 */

$title   = get_theme_mod( 'business_one_page_pro_feature_title' );
$content = get_theme_mod( 'business_one_page_pro_feature_content' );

if( $title || $content || is_active_sidebar( 'service-second' ) ){
?>

<div class="our-features">
	<div class="container">
		
        <?php 
            
            if( $title ) echo '<h2 class="title">' . esc_html( $title ) . '</h2>';
		
            if( $content ) echo wpautop( wp_kses_post( $content ) );
            	
            if( is_active_sidebar( 'service-second' ) ){ ?>
                <div class="row">
                    <?php dynamic_sidebar( 'service-second' ); ?>
                </div>
        <?php 
            } 
        ?>
        
	</div>
</div>
<?php
}