<?php
/**
 * Template part for displaying Team Section
 *
 * @package Business_One_Page_Pro
 */

$team_page = get_theme_mod( 'business_one_page_pro_team_section_page' );

if( $team_page ){
?>
<section id="team" class="our-team">
    <div class="container">
    <?php        
        $team_qry = new WP_Query( array( 'page_id' => $team_page ) );
    
        if( $team_qry->have_posts() ){
            while( $team_qry->have_posts() ){
                $team_qry->the_post();
            ?>
                <header class="heading">
                	<?php 
                        the_title( '<h1>', '</h1>' ); 
                        if( has_excerpt() ){ 
                            the_excerpt();
                        }else{
                            echo wpautop( business_one_page_pro_excerpt( get_the_content(), 100, '...' ) );
                        } 
                    ?>
                </header>
            <?php            
            }
        }
        wp_reset_postdata();
    
        $team_query = new WP_Query( array( 'post_type' => 'team', 'posts_per_page' => -1, 'post_status' => 'publish' ) );
        if( $team_query->have_posts() ){ ?>
        
            <div class="team-holder">
                <ul id="lightSlider">
                <?php 
                    while( $team_query->have_posts() ){
                        $team_query->the_post();
                        $designation = get_post_meta( get_the_ID(), '_business_one_page_pro_team_designation', true );
                        if( has_post_thumbnail() ){
                        ?>
                        <li>
    						<div class="box">
    							<div class="img-holder"><?php the_post_thumbnail( 'business-one-page-pro-team' ); ?></div>
    							<strong class="name"><?php the_title(); ?></strong>
    							<em class="designation"><?php echo esc_html( $designation ); ?></em>
    							<div class="hover-state">
    								<div class="table">
    									<div class="tabel-row">
    										<div class="tabel-cell">
                                                <div class="team-content">
                                                    <strong class="name"><?php the_title(); ?></strong>
        											<em class="designation"><?php echo esc_html( $designation ); ?></em>
        											<?php the_content(); ?>
                                                </div>
    										</div>
    									</div>
    								</div>
    							</div>
    						</div>
                        </li>
                        <?php
                        }
                    }
                    wp_reset_postdata();
                ?>
                </ul>
            </div>
        <?php    
        }
    ?>
    </div>
</section>
<?php
}