<?php
/**
 * Template part for displaying Contact Section
 *
 * @package Business_One_Page_Pro
 */

$contact_page = get_theme_mod( 'business_one_page_pro_contact_section_page' );
$contact_form = get_theme_mod( 'business_one_page_pro_contact_section_form' );
$cform_title  = get_theme_mod( 'business_one_page_pro_contact_section_form_title', __( 'Leave a message', 'business-one-page-pro' ) );

?>

<section id="contact">
    <div class="container">
    
        <?php                
        if( $contact_page ){
            
            $contact_qry = new WP_Query( array( 'page_id' => $contact_page ) );
        
            if( $contact_qry->have_posts() ){
                while( $contact_qry->have_posts() ){
                    $contact_qry->the_post();
                ?>
                    <header class="heading">
                   	<?php 
                        the_title( '<h1>', '</h1>' ); 
                        if( has_excerpt() ){ 
                            the_excerpt();
                        }else{
                            echo wpautop( business_one_page_pro_excerpt( get_the_content(), 100, '...' ) );
                        } 
                    ?>
                    </header>
                <?php            
                }
            }
            wp_reset_postdata();
        }
        ?>
        
    	<div class="row">
    		<?php if( is_cf7_activated() && $contact_form ){ ?>
            
                <div class="columns-6">
        			<h2><?php echo esc_html( $cform_title );?></h2>
        			<?php echo do_shortcode( $contact_form );?>
        		</div>
                
    		<?php } ?>
            
            <div class="columns-6">
                <?php 
                    /**
                     * Contact Details
                     * @hooked business_one_page_pro_contact_details_cb
                    */
                    do_action( 'business_one_page_pro_contact_details', true );                 
                ?>
    		</div>
            
    	</div>
    
    </div>
</section>