/*! .isOnScreen() returns bool */
jQuery.fn.isOnScreen = function(){
	
	var win = jQuery(window);
	
	var viewport = {
		top : win.scrollTop(),
		left : win.scrollLeft()
	};
	viewport.right = viewport.left + win.width();
	viewport.bottom = viewport.top + win.height();
	
	var bounds = this.offset();
    bounds.right = bounds.left + this.outerWidth();
    bounds.bottom = bounds.top + this.outerHeight();
	
    return (!(viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom));
	
};

jQuery(document).ready(function($) {
    
    /** Variables from Customizer for Slider settings */
    if( business_one_page_pro_data.auto == '1' ){
        var slider_auto = true;
    }else{
        slider_auto = false;
    }
    
    if( business_one_page_pro_data.loop == '1' ){
        var slider_loop = true;
    }else{
        var slider_loop = false;
    }
    
    if( business_one_page_pro_data.pager == '1' ){
        var slider_control = true;
    }else{
        slider_control = false;
    }
    
    if( business_one_page_pro_data.rtl == '1' ){
        var rtl = true;
    }else{
        var rtl = false;
    }
    
    /** Home Page Slider */
    $('#banner-slider').lightSlider({
        item        : 1,
        slideMargin : 0,
        mode        : business_one_page_pro_data.mode,
        speed       : business_one_page_pro_data.speed, //ms'
        auto        : slider_auto,
        loop        : slider_loop,
        pause       : business_one_page_pro_data.pause,
        controls    : false,
        pager       : slider_control,
        enableDrag  : false,
        rtl         : rtl,
    });
    
    $("#testimonialSlider").lightSlider({
        enableDrag     : false,
        item           : 1,
        slideMargin    : 0,
        adaptiveHeight : true,
        auto           : false,
        rtl            : rtl,
    });
    
    $("#lightSlider").lightSlider({
        slideMargin : 30,
        pager       : false,      
        enableDrag  : false,
        rtl         : rtl,
        responsive  : [
        	{
                breakpoint:768,
                settings: {
                    item:1,
                    slideMove:1,
                    slideMargin:0,
                  }
            }
        ],
    });
    
    /** Lightbox */
    if( business_one_page_pro_data.lightbox == '1' ){
        
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-1').find('.gallery-icon > a').attr( 'rel', 'group1' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-2').find('.gallery-icon > a').attr( 'rel', 'group2' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-3').find('.gallery-icon > a').attr( 'rel', 'group3' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-4').find('.gallery-icon > a').attr( 'rel', 'group4' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-5').find('.gallery-icon > a').attr( 'rel', 'group5' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-6').find('.gallery-icon > a').attr( 'rel', 'group6' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-7').find('.gallery-icon > a').attr( 'rel', 'group7' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-8').find('.gallery-icon > a').attr( 'rel', 'group8' );
        $('.page-template-template-gallery').find('.entry-content').find('.gallery-columns-9').find('.gallery-icon > a').attr( 'rel', 'group9' );
        
        $("a[href$='.jpg'],a[href$='.jpeg'],a[href$='.png'],a[href$='.gif']").fancybox();
        
    }
    
    // Script for back to top
    $(window).scroll(function(){
        if($(this).scrollTop() > 300){
          $('#rara-top').fadeIn();
        }else{
          $('#rara-top').fadeOut();
        }
    });
    
    $("#rara-top").click(function(){
        $('html,body').animate({scrollTop:0},600);
    });
    
    /* Sticky Header */
    // grab an element
	var myElement = document.querySelector("header");
	// construct an instance of Headroom, passing the element
	var headroom  = new Headroom(myElement);
	// initialise
	headroom.init();
    
	$('#site-navigation').onePageNav({
        currentClass: 'current-menu-item',
        changeHash: false,
        scrollSpeed: 1500,
        scrollThreshold: 0.5,
        filter: '',
        easing: 'swing',        
    });
    
     //responsive menu
     $("#nav-anchor").click(function(){
		$("#site-navigation").slideToggle("slow");
	});
    
    /** Home Page Portfolio Section Masonry */
    if( $('.page-template-template-home').length > 0 ){        
        $('.js-masonry').imagesLoaded(function(){ 
            $('.js-masonry').masonry({
                itemSelector: '.portfolio-col'
            }); 
        });
    }
    
    /** Testimonial Page Template Masonry */
    if( $('.page-template-template-testimonial').length > 0 ){        
        $('.js-masonry').imagesLoaded(function(){ 
            $('.js-masonry').masonry({
                itemSelector: '.testimonial-wrap'
            }); 
        });
    }
    
    /** Team Page Template Masonry */
    if( $('.page-template-template-team').length > 0 ){        
        $('.js-masonry').imagesLoaded(function(){ 
            $('.js-masonry').masonry({
                itemSelector: '.col'
            }); 
        });
    }
    
    /* Portfolio Isotope Filter */
    if( $('.page-template-template-portfolio').length > 0 ){
        // init Isotope
        var $grid = $('.portfolio-grid').imagesLoaded( function(){  
        
            $grid.isotope({
              // options
            });
            
            // filter items on button click
            $('.filter-button-group').on( 'click', 'button', function() {
              $('.filter-button-group button').removeClass('is-active');
              $(this).addClass('is-active');
              var filterValue = $(this).attr('data-filter');
              $grid.isotope({ filter: filterValue });
            });
        
        });
    }
    
    /** Client Slider*/
    $("#client-slider").lightSlider({
        item        : 5,
        slideMargin : 0,
        pager       : false,
        enableDrag  : false,
        rtl         : rtl,
        responsive  : [
            {
                breakpoint:992,
                settings: {
                    item:4,
                  }
            },
            {
                breakpoint:768,
                settings: {
                    item:1,
                  }
            }
        ]
    });
    
    /** Video Iframe Used in Service Page Template */
    // Find all YouTube videos
    var $allVideos = $("iframe[src^='//player.vimeo.com'], iframe[src^='//www.youtube.com']"), //$("iframe[src^='//www.youtube.com']"),

    // The element that is fluid width
    $fluidEl = $("body");

    // Figure out and save aspect ratio for each video
    $allVideos.each(function() {

      $(this).data('aspectRatio', this.height / this.width)

        // and remove the hard coded width/height
        .removeAttr('height')
        .removeAttr('width');

      });

    // When the window is resized
    $(window).resize(function() {

        var newWidth = $fluidEl.width();

        // Resize all videos according to their own aspect ratio
        $allVideos.each(function() {        
            var $el = $(this);
            $el
            .width(newWidth)
            .height(newWidth * $el.data('aspectRatio'));        
        });

    // Kick off one resize to fix all videos on page load
    }).resize();
    
    /* Counter for Stat Counter Widget */
    if( $('.widget_business_one_page_pro_stat_counter_widget').length > 0 ){
        $('.number').counterUp({
            delay: 10,
            time: 1000
        });
    }
    
    /* Fits embed video according to container */
    $("#content").fitVids();
    
    /****SHORTCODE***/
    $('.shortcode-slider .slides').lightSlider({
        mode        : "slide",
        item        : 1,
        slideMargin : 0,
        pager       : false,
        enableDrag  :false,
        rtl         : rtl,
    });    
    
    $('.rara_accordian .rara_accordian_content').hide(); /**Need to be CSS*/
    $('.rara_accordian:first').children('.rara_accordian_content').show();
    $('.rara_accordian:first').children('.rara_accordian_title').addClass('active');
    $('.rara_accordian_title').click(function(){
    if($(this).hasClass('active')){
    }
    else{
      $(this).parent('.rara_accordian').siblings().find('.rara_accordian_content').slideUp();
      $(this).next('.rara_accordian_content').slideToggle();
      $(this).parent('.rara_accordian').siblings().find('.rara_accordian_title').removeClass('active')
      $(this).toggleClass('active')
    }
    });
    
    $('.rara_toggle.close .rara_toggle_content').hide(); /**Need to be CSS*/
    $('.rara_toggle.open .rara_toggle_title').addClass('active');
    $('.rara_toggle_title').click(function(){
      $(this).next('.rara_toggle_content').slideToggle();
      $(this).toggleClass('active')
    });
    
    $('.rara_tab').hide();/**Need to be CSS*/
    $('.rara_tab_wrap').prepend('<div class="rara_tab_group clearfix"></div>');

    $('.rara_tab_wrap').each(function(){
        $(this).children('.rara_tab').find('.tab-title').prependTo($(this).find('.rara_tab_group'));
        $(this).children('.rara_tab').wrapAll( "<div class='rara_tab_content clearfix' />");
    });

    $('#page').each(function(){
        $(this).find('.rara_tab:first-child').show();
        $(this).find('.tab-title:first-child').addClass('active')
    });
 
    $('.rara_tab_group .tab-title').click(function(){
        $(this).siblings().removeClass('active');
        $(this).addClass('active');
        $(this).parent('.rara_tab_group ').next('.rara_tab_content').find('.rara_tab').hide();
        var ap_id = $(this).attr('id');
        $(this).parent('.rara_tab_group ').next('.rara_tab_content').find('.'+ap_id).show();
    });    
    /****SHORTCODE***/ 
    
     
    
    /** Dynamic header height calculation for responsive devices */
    var header_height = $('#masthead').height();
    $('.banner').css( 'margin-top', header_height );
    $('.inner-page').css( 'margin-top', header_height );

    /* Equal Height */
     $('.widget_business_one_page_pro_icon_text_widget').matchHeight({
        byRow: true,
        property: 'height',
        target: null,
        remove: false
    });   
    
    /* Custom Scroll Bar */
    $(".our-team .team-holder .box .hover-state .tabel-cell .team-content").mCustomScrollbar({
     theme:"minimal"
    });
    
    /** Responsive Menu */
    
     $('#responsive-menu-button').sidr({
        name: 'sidr-main',
        source: '#topmenu',
        side: 'right'
    }); 
    
    $('#responsive-menu-button-primary').sidr({
        name: 'sidr-main-primary',
        source: '#site-navigation',
        side: 'right'
    });
    
    $('.sidr-inner').prepend('<a class="btn-closed fa fa-times"></a>');
    
    $('body').on( 'click', '.btn-closed', function(){
        $.sidr('close', 'sidr-main-primary');
        $.sidr('close', 'sidr-main');
    });
    
    $('#sidr-main-primary li').click(function(){        
        $.sidr('close', 'sidr-main-primary');
        $.sidr('close', 'sidr-main');
    });
    /*
    $('#sidr-main-primary').onePageNav({        
        scrollSpeed: 1500,
        scrollThreshold: 0.5,
        easing: 'swing',        
    });*/
});