<?php
/**
 * Business One Page Pro widgets.
 *
 * @package Business_One_Page
 */

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function business_one_page_pro_widgets_init() {
	
    $sidebars = array(
        'sidebar'   => array(
            'name'        => esc_html__( 'Sidebar', 'business-one-page-pro' ),
            'id'          => 'sidebar', 
            'description' => esc_html__( 'Default Sidebar', 'business-one-page-pro' ),
        ),
        'about-section'=> array(
            'name'        => esc_html__( 'About Section Widget', 'business-one-page-pro' ),
            'id'          => 'about-section', 
            'description' => esc_html__( 'Add home page about section widgets.', 'business-one-page-pro' ),
        ),
        'service-section'=> array(
            'name'        => esc_html__( 'Service Section Widget', 'business-one-page-pro' ),
            'id'          => 'service-section', 
            'description' => esc_html__( 'Add home page service section widgets.', 'business-one-page-pro' ),
        ),
        'cta-one'=> array(
            'name'        => esc_html__( 'Call To Action One', 'business-one-page-pro' ),
            'id'          => 'cta-one', 
            'description' => esc_html__( 'Add home page call to action widgets.', 'business-one-page-pro' ),
        ),
        'cta-two'=> array(
            'name'        => esc_html__( 'Call To Action Two', 'business-one-page-pro' ),
            'id'          => 'cta-two', 
            'description' => esc_html__( 'Add home page call to action widgets.', 'business-one-page-pro' ),
        ),
        'about-counter'=> array(
            'name'        => esc_html__( 'About Page Counter Widget', 'business-one-page-pro' ),
            'id'          => 'about-counter', 
            'description' => esc_html__( 'Add about page counter widgets.', 'business-one-page-pro' ),
        ),
        'about-second'=> array(
            'name'        => esc_html__( 'About Page Second Widget', 'business-one-page-pro' ),
            'id'          => 'about-second', 
            'description' => esc_html__( 'Add about page second widgets.', 'business-one-page-pro' ),
        ),  
        'service-first'=> array(
            'name'        => esc_html__( 'Service Page First Widget', 'business-one-page-pro' ),
            'id'          => 'service-first', 
            'description' => esc_html__( 'Add service page first widgets.', 'business-one-page-pro' ),
        ), 
        'service-second'=> array(
            'name'        => esc_html__( 'Service Page Second Widget', 'business-one-page-pro' ),
            'id'          => 'service-second', 
            'description' => esc_html__( 'Add service page second widgets.', 'business-one-page-pro' ),
        ), 
        'service-third'=> array(
            'name'        => esc_html__( 'Service Page Third Widget', 'business-one-page-pro' ),
            'id'          => 'service-third', 
            'description' => esc_html__( 'Add service page third widgets.', 'business-one-page-pro' ),
        ),      
        'footer-one'=> array(
            'name'        => esc_html__( 'Footer One', 'business-one-page-pro' ),
            'id'          => 'footer-one', 
            'description' => esc_html__( 'Add footer one widgets.', 'business-one-page-pro' ),
        ),
        'footer-two'=> array(
            'name'        => esc_html__( 'Footer Two', 'business-one-page-pro' ),
            'id'          => 'footer-two', 
            'description' => esc_html__( 'Add footer two widgets.', 'business-one-page-pro' ),
        ),
        'footer-three'=> array(
            'name'        => esc_html__( 'Footer Three', 'business-one-page-pro' ),
            'id'          => 'footer-three', 
            'description' => esc_html__( 'Add footer three widgets.', 'business-one-page-pro' ),
        )
    );
    
    foreach( $sidebars as $sidebar ){
        register_sidebar( array(
    		'name'          => $sidebar['name'],
    		'id'            => $sidebar['id'],
    		'description'   => $sidebar['description'],
    		'before_widget' => '<section id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</section>',
    		'before_title'  => '<h2 class="widget-title">',
    		'after_title'   => '</h2>',
    	) );
    }
    
    /** Dynamic sidebars */
    $dynamic_sidebars = business_one_page_pro_get_dynamnic_sidebar();
    
    foreach( $dynamic_sidebars as $k => $v ){
        register_sidebar( array(
    		'name'          => esc_html( $v ),
    		'id'            => esc_attr( $k ),
    		'description'   => '',
    		'before_widget' => '<section id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</section>',
    		'before_title'  => '<h2 class="widget-title">',
    		'after_title'   => '</h2>',
    	) );
    }
    
}
add_action( 'widgets_init', 'business_one_page_pro_widgets_init' );

/**
 * Widget Icon Text
 */
require get_template_directory() . '/inc/widgets/widget-icon-text.php';

/**
 * Widget Stat Counter
 */
require get_template_directory() . '/inc/widgets/widget-stat-counter.php';

/**
 * Widget Call To Action
 */
require get_template_directory() . '/inc/widgets/widget-cta.php';

/**
 * Widget Recent Post
 */
require get_template_directory() . '/inc/widgets/widget-recent-post.php';

/**
 * Widget Popular Post
 */
require get_template_directory() . '/inc/widgets/widget-popular-post.php';

/**
 * Widget Social Links
 */
require get_template_directory() . '/inc/widgets/widget-social-links.php';

/**
 * Widget Author Posts
 */
require get_template_directory() . '/inc/widgets/widget-author-post.php';

/**
 * Widget Category Recent Posts
 */
require get_template_directory() . '/inc/widgets/widget-cat-post.php';

/**
 * Widget Featured Posts
 */
require get_template_directory() . '/inc/widgets/widget-featured-post.php';

/**
 * Widget Facebook Page
 */
require get_template_directory() . '/inc/widgets/widget-facebook-page.php';

/**
 * Widget Flickr Feed
 */
require get_template_directory() . '/inc/widgets/widget-flickr.php';

/**
 * Widget Instagram
 */
require get_template_directory() . '/inc/widgets/widget-instagram.php';

/**
 * Widget Twitter Feeds
 */
require get_template_directory() . '/inc/widgets/widget-twitter-feeds.php';