<?php
/**
 * Call To Action Widget
 *
 * @package Business_One_Page_Pro
 */

// register Business_One_Page_Pro_Cta_Widget widget
function business_one_page_pro_register_cta_widget(){
    register_widget( 'Business_One_Page_Pro_Cta_Widget' );
}
add_action('widgets_init', 'business_one_page_pro_register_cta_widget');
 
 /**
 * Adds Business_One_Page_Pro_Cta_Widget widget.
 */
class Business_One_Page_Pro_Cta_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
			'business_one_page_pro_cta_widget', // Base ID
			__( 'RARA: Call To Action Widget', 'business-one-page-pro' ), // Name
			array( 'description' => __( 'A Call To Action Text Widget.', 'business-one-page-pro' ), ) // Args
		);
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        
        $title       = ! empty( $instance['title'] ) ? $instance['title'] : '' ;		
        $content     = ! empty( $instance['content'] ) ? $instance['content'] : '';
        $bg_image    = ! empty( $instance['bg_image'] ) ? esc_url_raw( $instance['bg_image'] ) : '';
        $bg_color    = ! empty( $instance['bg_color'] ) ? $instance['bg_color'] : '#32c4d1';
        $style       = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';
        $button_text = ! empty( $instance['button_text'] ) ? $instance['button_text'] : '' ;
		$button_url  = ! empty( $instance['button_url'] ) ? esc_url_raw( $instance['button_url'] ) : '' ;
        
        
        
        if( $bg_image ){
            /** Added to work for demo content compatible */
            $path = parse_url( $bg_image, PHP_URL_PATH );
            $segments = explode('/', rtrim($path, '/'));
            
            if( $segments[1] === 'preview' && $segments[2] === 'business-one-page-pro' ){
                $fimg_url = $bg_image; /** If the img url has our demo url then simply return the url.*/
            }else{
                $attachment_id = business_one_page_pro_get_image_id( $bg_image );
                $image_array   = wp_get_attachment_image_src( $attachment_id, 'full');
                $bg_image      = preg_match('/(^.*\.jpg|jpeg|png|gif|ico*)/i', $bg_image);
                $fimg_url      = $image_array[0]; 
            }            
            $bg = 'style="background:url(' . esc_url( $fimg_url ) . ') no-repeat"';
        }else{
            $bg = 'style="background:' . $bg_color . '"'; /** NEED TO FILTER BG COLOR WHILE INTEGRATING TYPOGRAPHY COLOR */
        }
        
        echo $args['before_widget']; ?>
        
        <div class="text <?php echo esc_attr( $style ); ?>" <?php echo $bg; ?>>
			<div class="container">
        <?php    
            
            if( $title ) {
                echo $args['before_title'] . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $args['after_title'];
            }
            
            if( $content ) echo wpautop( esc_html( $content ) ); 
            
            if( $button_text && $button_url ) echo '<a href="' . esc_url( $button_url ) . '" class="btn-start">' . esc_html( $button_text ) . '</a>';
        ?>
            </div>
        </div>
        <?php 
        echo $args['after_widget'];
    }

    /**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        
        $title       = ! empty( $instance['title'] ) ? $instance['title'] : '' ;		
        $content     = ! empty( $instance['content'] ) ? $instance['content'] : '';
        $bg_image    = ! empty( $instance['bg_image'] ) ? esc_url_raw( $instance['bg_image'] ) : '';
        $style       = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';
        $bg_color    = ! empty( $instance['bg_color'] ) ? $instance['bg_color'] : '#32c4d1';
        $button_text = ! empty( $instance['button_text'] ) ? $instance['button_text'] : '' ;
		$button_url  = ! empty( $instance['button_url'] ) ? esc_url_raw( $instance['button_url'] ) : '' ;
        
        ?>
		
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title', 'business-one-page-pro' ); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />            
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php esc_html_e( 'Content', 'business-one-page-pro' ); ?></label>
            <textarea name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php print $content; ?></textarea>
        </p>
        
        <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>"><?php esc_html_e( 'Button Text', 'business-one-page-pro' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'button_text' ) ); ?>" type="text" value="<?php echo esc_attr( $button_text ); ?>" />
		</p>
		
        <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'button_url' ) ); ?>"><?php esc_html_e( 'Button Link', 'business-one-page-pro' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'button_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'button_url' ) ); ?>" type="text" value="<?php echo esc_url( $button_url ); ?>" />
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php esc_html_e( 'Select Style', 'business-one-page-pro' ); ?></label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" class="widefat">
				<option value="style1" <?php selected( 'style1', $style ) ?>><?php esc_html_e( 'Style 1', 'business-one-page-pro' ); ?></option>
				<option value="style2" <?php selected( 'style2', $style ) ?>><?php esc_html_e( 'Style 2', 'business-one-page-pro' ); ?></option>
			</select>
		</p>
        
        <p>
			<label for="<?php echo $this->get_field_id( 'bg_color' ); ?>"><?php esc_html_e( 'Background Color', 'business-one-page-pro' ); ?></label><br />
			<input class="rara-color-picker" type="text" data-default-color="#32c4d1" id="<?php echo $this->get_field_id( 'bg_color' ); ?>" name="<?php echo $this->get_field_name( 'bg_color' ); ?>" value="<?php echo esc_attr( $bg_color ); ?>" />
		</p>
        
        <?php business_one_page_pro_get_image_field( $this->get_field_id( 'bg_image' ), $this->get_field_name( 'bg_image' ), $bg_image, __( 'Background Image', 'business-one-page-pro' ) ); ?>
                        
        <?php
	}
    
    /**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		
        $instance['title']       = ! empty( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '' ;
        $instance['content']     = ! empty( $new_instance['content'] ) ? $new_instance['content'] : '';
        $instance['style']       = ! empty( $new_instance['style'] ) ? $new_instance['style'] : 'style1';        
        $instance['bg_image']    = ! empty( $new_instance['bg_image'] ) ? esc_url_raw( $new_instance['bg_image'] ) : '';
        $instance['bg_color']    = ! empty( $new_instance['bg_color'] ) ? $new_instance['bg_color'] : '#32c4d1';
        $instance['button_url']  = ! empty( $new_instance['button_url'] ) ? esc_url_raw( $new_instance['button_url'] ) : '';
        $instance['button_text'] = ! empty( $new_instance['button_text'] ) ? $new_instance['button_text'] : '';
        
        return $instance;
	}
    
}  // class Business_One_Page_Pro_Cta_Widget 