<?php
/**
 * Customizer Styling Section 
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_styling( $wp_customize ) {
     
    Kirki::add_section( 'business_one_page_pro_styling_settings', array(
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'title'      => __( 'Styling Settings', 'business-one-page-pro' ),
    ) );
    
    /** Layout Style */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Layout Style', 'business-one-page-pro' ),
        'help'      => __( 'Choose the default sidebar position for your site. The position of the sidebar for individual posts can be set in the post editor.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_layout_style',
        'type'      => 'radio-image',
        'default'   => 'right-sidebar',
        'choices'   => array(
            'left-sidebar' => get_template_directory_uri() . '/images/left-sidebar.png',
            'right-sidebar' => get_template_directory_uri() . '/images/right-sidebar.png',
        )
    ) );
    
    /** Color Scheme */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Color Scheme', 'business-one-page-pro' ),
        'help'      => __( 'The theme comes with unlimited color schemes for your theme styling.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_color_scheme',
        'type'      => 'color',
        'default'   => '#f4b400',
    ) );
    
    /** Secondary Color Scheme */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Secondary Color Scheme', 'business-one-page-pro' ),
        'help'      => __( 'Secondary color scheme for your theme styling. Please choose dark based color.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_secondary_color_scheme',
        'type'      => 'color',
        'default'   => '#0B578E',
    ) );
    
    /** Footer Color Scheme */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Footer Color Scheme', 'business-one-page-pro' ),
        'help'      => __( 'Footer color scheme for your theme styling.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_footer_color_scheme',
        'type'      => 'color',
        'default'   => '#05263E',
    ) );
    
    /** Background Color */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Background Color', 'business-one-page-pro' ),
        'help'      => __( 'Pick a color for site background.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_bg_color',
        'type'      => 'color',
        'default'   => '#FFFFFF',
    ) );
    
    /** Body Background */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Body Background', 'business-one-page-pro' ),
        'help'      => __( 'Choose body background as image or pattern.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_body_bg',
        'type'      => 'radio-buttonset',
        'default'   => 'image',
        'choices'     => array(
            'image'   => __( 'Image', 'business-one-page-pro' ),
            'pattern' => __( 'Pattern', 'business-one-page-pro' ),
        ),
    ) );
    
    /** Background Image */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Background Image', 'business-one-page-pro' ),
        'help'      => __( 'Upload your own custom background image or pattern.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_bg_image',
        'type'      => 'image',
        'default'   => '',
        'active_callback'  => array(
            array(
                'setting'  => 'business_one_page_pro_body_bg',
                'operator' => '==',
                'value'    => 'image',
            )
        )
    ) );
    
    /** Background Pattern */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Background Pattern', 'business-one-page-pro' ),
        'help'      => __( 'Choose from any of 63 awesome background patterns for your site background.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_styling_settings',
        'settings'  => 'business_one_page_pro_bg_pattern',
        'type'      => 'radio-image',
        'default'   => 'nobg',
        'choices'   => business_one_page_pro_get_patterns(),
        'active_callback'  => array(
            array(
                'setting'  => 'business_one_page_pro_body_bg',
                'operator' => '==',
                'value'    => 'pattern',
            )
        )
    ) );
    
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_styling' );