<?php
/**
 * Customizer Blog Section 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_blog( $wp_customize ) {
    
    /* Option list of all categories */
    $args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $option_categories = array();
    $category_lists = get_categories( $args );
    foreach( $category_lists as $category ){
        $option_categories[$category->term_id] = $category->name;
    }
    
    Kirki::add_section( 'business_one_page_pro_blog_page_settings', array(
        'priority'   => 27,
        'capability' => 'edit_theme_options',
        'title'      => __( 'Blog Page Settings', 'business-one-page-pro' ),
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_blog_layout',
        'label'    => __( 'Blog Page Layout', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_blog_page_settings',
        'type'     => 'radio',
        'default'  => 'default',
        'choices'  => array(
            'default'   => __( 'Default', 'business-one-page-pro' ),
            'full'      => __( 'Full Image', 'business-one-page-pro' ),
            'square'    => __( 'Square Image', 'business-one-page-pro' ),
            'circular'  => __( 'Circular Image', 'business-one-page-pro' ),
        )
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'settings'    => 'business_one_page_pro_exclude_categories',
        'label'       => __( 'Exclude Categories', 'business-one-page-pro' ),
        'description' => __( 'Check multiple categories to exclude from blog and archive page.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_blog_page_settings',
        'type'        => 'multicheck',
        'choices'     => $option_categories
    ) ); 
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_blog' );