<?php
/**
 * Customizer Typography Panel 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_typography( $wp_customize ) {
    
    Kirki::add_panel( 'business_one_page_pro_typography_section', array(
        'title'          => __( 'Typography Settings', 'business-one-page-pro' ),
        'priority'       => 31,
        'capability'     => 'edit_theme_options',
    ) );
    
    /** Body Settings */
    Kirki::add_section( 'business_one_page_pro_typography_body_section', array(
        'title'      => __( 'Body Settings', 'business-one-page-pro' ),
        'priority'   => 10,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Body Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_body_font',
    	'label'       => __( 'Body Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_typography_body_section',
    	'default'     => array(
    		'font-family' => 'Source Sans Pro',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Body Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_body_font_size',
        'label'    => __( 'Body Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_typography_body_section',
        'default'  => '17',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 14,
                        'max'  => 35,
                        'step' => 1,
                    )
    ) );
    
    /** Body Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_body_line_height',
        'label'    => __( 'Body Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_typography_body_section',
        'default'  => '26',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 17,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Body Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_body_color',
        'label'    => __( 'Body Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_typography_body_section',
        'type'     => 'color',
        'default'  => '#59595b',
    ) );
    
    /** Home Page Section Title Settings */
    Kirki::add_section( 'business_one_page_pro_hps_title_section', array(
        'title'      => __( 'Home Page Section Title Settings', 'business-one-page-pro' ),
        'priority'   => 11,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Home Page Section Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_hps_title_font',
    	'label'       => __( 'Home Page Section Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for the Section Title of Home Page Section', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_hps_title_section',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Home Page Section Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_title_font_size',
        'label'    => __( 'Home Page Section Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_hps_title_section',
        'default'  => '42',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Home Page Section Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_title_line_height',
        'label'    => __( 'Home Page Section Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_hps_title_section',
        'default'  => '46',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 25,
                        'max'  => 65,
                        'step' => 1,
                    )
    ) );
    
    /** Home Page Section Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_title_color',
        'label'    => __( 'Home Page Section Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_hps_title_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Portfolio Section Title Settings */
    Kirki::add_section( 'business_one_page_pro_ps_section', array(
        'title'       => __( 'Portfolio Section Title Settings', 'business-one-page-pro' ),        
        'priority'    => 12,
        'capability'  => 'edit_theme_options',
        'panel'       => 'business_one_page_pro_typography_section'
    ) );
    
    /** Portfolio Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_hps_portfolio_title_font',
    	'label'       => __( 'Portfolio Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Portfolio Title of Portfolio Section of Home Page', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_ps_section',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Portfolio Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_portfolio_title_font_size',
        'label'    => __( 'Portfolio Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_ps_section',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Portfolio Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_portfolio_title_line_height',
        'label'    => __( 'Portfolio Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_ps_section',
        'default'  => '36',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 25,
                        'max'  => 65,
                        'step' => 1,
                    )
    ) );
    
    /** Team Section Title Settings */
    Kirki::add_section( 'business_one_page_pro_ts_title_section', array(
        'title'      => __( 'Team Section Title Settings', 'business-one-page-pro' ),
        'priority'   => 13,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Team Section Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_hps_team_title_font',
    	'label'       => __( 'Team Section Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Team Title of Team Section of Home Page', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_ts_title_section',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => '700',
    	),
    ) );
    
    /** Team Section Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_team_title_font_size',
        'label'    => __( 'Team Section Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_ts_title_section',
        'default'  => '21',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Team Section Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_team_title_line_height',
        'label'    => __( 'Team Section Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_ts_title_section',
        'default'  => '26',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 60,
                        'step' => 1,
                    )
    ) );
    
    /** Team Section Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_hps_team_title_color',
        'label'    => __( 'Team Section Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_ts_title_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Blog Section Title Settings */
    Kirki::add_section( 'business_one_page_pro_bs_title_section', array(
        'title'      => __( 'Blog Section Title Settings', 'business-one-page-pro' ),
        'priority'   => 14,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Blog Section Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_blog_title_font',
    	'label'       => __( 'Blog Section Title Font', 'business-one-page-pro' ),
    	'tooltip'     => __( 'Setting for Blog Title of Blog Section of Home Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_bs_title_section',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => '700',
    	),
    ) );
    
    /** Blog Section Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_blog_title_font_size',
        'label'    => __( 'Blog Section Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_bs_title_section',
        'default'  => '25',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Blog Section Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_blog_title_line_height',
        'label'    => __( 'Blog Section Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_bs_title_section',
        'default'  => '30',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 65,
                        'step' => 1,
                    )
    ) );
    
    /** Blog Section Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_blog_title_color',
        'label'    => __( 'Blog Section Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_bs_title_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Page Title Settings */
    Kirki::add_section( 'business_one_page_pro_page_title_setting', array(
        'title'      => __( 'Page Title Settings', 'business-one-page-pro' ),
        'priority'   => 15,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Page Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_page_title_font',
    	'label'       => __( 'Page Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Page title above breadcrumb', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_page_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => '700',
    	),
    ) );
    
    /** Page Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_page_title_font_size',
        'label'    => __( 'Page Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_page_title_setting',
        'default'  => '28',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Page Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_page_title_line_height',
        'label'    => __( 'Page Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_page_title_setting',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 65,
                        'step' => 1,
                    )
    ) );
    
    /** Page Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_page_title_color',
        'label'    => __( 'Page Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_page_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Post Title Settings */
    Kirki::add_section( 'business_one_page_pro_post_title_setting', array(
        'title'      => __( 'Post Title Settings', 'business-one-page-pro' ),
        'priority'   => 16,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Post Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_post_title_font',
    	'label'       => __( 'Post Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Post Title in Blog/Archive Page.', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_post_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Post Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_post_title_font_size',
        'label'    => __( 'Post Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_post_title_setting',
        'default'  => '25',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Post Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_post_title_line_height',
        'label'    => __( 'Post Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_post_title_setting',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 65,
                        'step' => 1,
                    )
    ) );
    
    /** Post Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_post_title_color',
        'label'    => __( 'Post Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_post_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Contact Section Title Settings */
    Kirki::add_section( 'business_one_page_pro_cs_title_setting', array(
        'title'      => __( 'Contact Section Title Settings', 'business-one-page-pro' ),
        'priority'   => 17,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Contact Section Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_contact_title_font',
    	'label'       => __( 'Contact Section Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Contact Title of Contact Section and Contact Page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_cs_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => '700',
    	),
    ) );
    
    /** Contact Section Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_contact_title_font_size',
        'label'    => __( 'Contact Section Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_cs_title_setting',
        'default'  => '21',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Contact Section Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_contact_title_line_height',
        'label'    => __( 'Contact Section Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_cs_title_setting',
        'default'  => '26',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Contact Section Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_contact_title_color',
        'label'    => __( 'Contact Section Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_cs_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Testimonial Title Settings */
    Kirki::add_section( 'business_one_page_pro_testimonial_title_setting', array(
        'title'      => __( 'Testimonial Title Settings', 'business-one-page-pro' ),
        'priority'   => 18,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Testimonial Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_testimonial_title_font',
    	'label'       => __( 'Testimonial Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Testimonial Title of Testimonial Page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_testimonial_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => '700',
    	),
    ) );
    
    /** Testimonial Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_testimonial_title_font_size',
        'label'    => __( 'Testimonial Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_testimonial_title_setting',
        'default'  => '17',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Testimonial Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_testimonial_title_line_height',
        'label'    => __( 'Testimonial Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_testimonial_title_setting',
        'default'  => '21',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Testimonial Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_testimonial_title_color',
        'label'    => __( 'Testimonial Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_testimonial_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Team Title Settings */
    Kirki::add_section( 'business_one_page_pro_team_title_setting', array(
        'title'      => __( 'Team Title Settings', 'business-one-page-pro' ),
        'priority'   => 19,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Team Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_team_title_font',
    	'label'       => __( 'Team Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Team Title of Team Page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_team_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => '700',
    	),
    ) );
    
    /** Team Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_team_title_font_size',
        'label'    => __( 'Team Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_team_title_setting',
        'default'  => '21',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Team Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_team_title_font_line_height',
        'label'    => __( 'Team Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_team_title_setting',
        'default'  => '24',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Team Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_team_title_font_color',
        'label'    => __( 'Team Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_team_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Portfolio Title Settings */
    Kirki::add_section( 'business_one_page_pro_portfolio_title_setting', array(
        'title'      => __( 'Portfolio Title Settings', 'business-one-page-pro' ),
        'priority'   => 20,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Portfolio Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_portfolio_title_font',
    	'label'       => __( 'Portfolio Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Portfolio Title of Portfolio Page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_portfolio_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Portfolio Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_portfolio_title_font_size',
        'label'    => __( 'Portfolio Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_portfolio_title_setting',
        'default'  => '25',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Portfolio Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_portfolio_title_line_height',
        'label'    => __( 'Portfolio Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_portfolio_title_setting',
        'default'  => '30',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Mission & Core Value Title Settings */
    Kirki::add_section( 'business_one_page_pro_mcv_title_setting', array(
        'title'      => __( 'Mission & Core Value Title Settings', 'business-one-page-pro' ),
        'priority'   => 21,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Mission & Core Value Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_mcv_title_font',
    	'label'       => __( 'Mission & Core Value Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Our Mission Title & Our Core Value Title of About Page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_mcv_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Mission & Core Value Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_mcv_title_font_size',
        'label'    => __( 'Mission & Core Value Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_mcv_title_setting',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    ),
    ) );
    
    /** Mission & Core Value Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_mcv_title_line_height',
        'label'    => __( 'Mission & Core Value Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_mcv_title_setting',
        'default'  => '36',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    ),
    ) );
    
    /** Mission & Core Value Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_mcv_title_color',
        'label'    => __( 'Mission & Core Value Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_mcv_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Our Client Title Settings */
    Kirki::add_section( 'business_one_page_pro_client_title_setting', array(
        'title'      => __( 'Our Client Title Settings', 'business-one-page-pro' ),
        'priority'   => 22,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Our Client Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_client_title_font',
    	'label'       => __( 'Our Client Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Our Client Title of Home page & About page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_client_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Our Client Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_client_title_font_size',
        'label'    => __( 'Our Client Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_client_title_setting',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Our Client Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_client_title_font_line_height',
        'label'    => __( 'Our Client Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_client_title_setting',
        'default'  => '36',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Our Client Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_client_title_font_color',
        'label'    => __( 'Our Client Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_client_title_setting',
        'type'     => 'color',
        'default'  => '#ffffff',
    ) );
    
    /** Service Page Section Title Settings */
    Kirki::add_section( 'business_one_page_pro_service_title_setting', array(
        'title'      => __( 'Service Page Section Title Settings', 'business-one-page-pro' ),
        'priority'   => 22,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Service Page Section Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_s_section_title_font',
    	'label'       => __( 'Service Page Section Title Font', 'business-one-page-pro' ),
        'tooltip'     => __( 'Setting for Section Title of Service page Template', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_service_title_setting',
    	'default'     => array(
    		'font-family' => 'Oxygen',
    		'variant'     => 'regular',
    	),
    ) );
    
    /** Service Page Section Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_s_section_title_font_size',
        'label'    => __( 'Service Page Section Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_service_title_setting',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** Service Page Section Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_s_section_title_font_line_height',
        'label'    => __( 'Service Page Section Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_service_title_setting',
        'default'  => '36',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** Service Page Section Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_s_section_title_font_color',
        'label'    => __( 'Service Page Section Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_service_title_setting',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** H1 Typography Settings */
    Kirki::add_section( 'business_one_page_pro_h1_section', array(
        'title' => __( 'H1 Settings (Content)', 'business-one-page-pro' ),
        'priority' => 23,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** H1 Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_h1_font',
    	'label'       => __( 'H1 Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_h1_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** H1 Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h1_font_size',
        'label'    => __( 'H1 Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h1_section',
        'default'  => '42',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 25,
                        'max'  => 55,
                        'step' => 1,
                    )
    ) );
    
    /** H1 Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h1_line_height',
        'label'    => __( 'H1 Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h1_section',
        'default'  => '46',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 30,
                        'max'  => 60,
                        'step' => 1,
                    )
    ) );
    
    /** H1 Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h1_color',
        'label'    => __( 'H1 Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h1_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** H2 Typography Settings */
    Kirki::add_section( 'business_one_page_pro_h2_section', array(
        'title' => __( 'H2 Settings (Content)', 'business-one-page-pro' ),
        'priority' => 24,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** H2 Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_h2_font',
    	'label'       => __( 'H2 Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_h2_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** H2 Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h2_font_size',
        'label'    => __( 'H2 Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h2_section',
        'default'  => '32',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** H2 Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h2_line_height',
        'label'    => __( 'H2 Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h2_section',
        'default'  => '36',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 30,
                        'max'  => 60,
                        'step' => 1,
                    )
    ) );
    
    /** H2 Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h2_color',
        'label'    => __( 'H2 Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h2_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** H3 Typography Settings */
    Kirki::add_section( 'business_one_page_pro_h3_section', array(
        'title' => __( 'H3 Settings (Content)', 'business-one-page-pro' ),
        'priority' => 25,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** H3 Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_h3_font',
    	'label'       => __( 'H3 Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_h3_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** H3 Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h3_font_size',
        'label'    => __( 'H3 Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h3_section',
        'default'  => '25',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 40,
                        'step' => 1,
                    )
    ) );
    
    /** H3 Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h3_line_height',
        'label'    => __( 'H3 Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h3_section',
        'default'  => '29',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 20,
                        'max'  => 50,
                        'step' => 1,
                    )
    ) );
    
    /** H3 Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h3_color',
        'label'    => __( 'H3 Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h3_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** H4 Typography Settings */
    Kirki::add_section( 'business_one_page_pro_h4_section', array(
        'title' => __( 'H4 Settings (Content)', 'business-one-page-pro' ),
        'priority' => 26,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** H4 Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_h4_font',
    	'label'       => __( 'H4 Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_h4_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** H4 Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h4_font_size',
        'label'    => __( 'H4 Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h4_section',
        'default'  => '23',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 30,
                        'step' => 1,
                    )
    ) );
    
    /** H4 Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h4_line_height',
        'label'    => __( 'H4 Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h4_section',
        'default'  => '27',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 40,
                        'step' => 1,
                    )
    ) );
    
    /** H4 Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h4_color',
        'label'    => __( 'H4 Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h4_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** H5 Typography Settings */
    Kirki::add_section( 'business_one_page_pro_h5_section', array(
        'title' => __( 'H5 Settings (Content)', 'business-one-page-pro' ),
        'priority' => 27,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** H5 Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_h5_font',
    	'label'       => __( 'H5 Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_h5_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** H5 Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h5_font_size',
        'label'    => __( 'H5 Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h5_section',
        'default'  => '21',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 30,
                        'step' => 1,
                    )
    ) );
    
    /** H5 Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h5_line_height',
        'label'    => __( 'H5 Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h5_section',
        'default'  => '25',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 35,
                        'step' => 1,
                    )
    ) );
    
    /** H5 Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h5_color',
        'label'    => __( 'H5 Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h5_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** H6 Typography Settings */
    Kirki::add_section( 'business_one_page_pro_h6_section', array(
        'title' => __( 'H6 Settings (Content)', 'business-one-page-pro' ),
        'priority' => 28,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** H6 Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_h6_font',
    	'label'       => __( 'H6 Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_h6_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** H6 Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h6_font_size',
        'label'    => __( 'H6 Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h6_section',
        'default'  => '19',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 30,
                        'step' => 1,
                    )
    ) );
    
    /** H6 Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h6_line_height',
        'label'    => __( 'H6 Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h6_section',
        'default'  => '23',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 35,
                        'step' => 1,
                    )
    ) );
    
    /** H6 Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_h6_color',
        'label'    => __( 'H6 Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_h6_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    /** Typography Ends */
    
    /** Widget Settings *
    Kirki::add_section( 'business_one_page_pro_widget_section', array(
        'title' => __( 'Widget Settings', 'business-one-page-pro' ),
        //'priority' => 12,
        'capability' => 'edit_theme_options',
        'panel'     => 'business_one_page_pro_typography_section'
    ) );
    
    /** Widget Font *
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_widget_font',
    	'label'       => __( 'Widget Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_widget_section',
    	'default'     => array(
    		'font-family'    => 'Lato',
    		'variant'        => 'regular',
    	),
    ) );
    
    /** Widget Font Size *
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_font_size',
        'label'    => __( 'Widget Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_section',
        'default'  => '16',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 20,
                        'step' => 1,
                    )
    ) );
    
    /** Widget Line Height *
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_line_height',
        'label'    => __( 'Widget Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_section',
        'default'  => '24',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 40,
                        'step' => 1,
                    )
    ) );
    
    /** Widget Color *
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_color',
        'label'    => __( 'Widget Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_section',
        'type'     => 'color',
        'default'  => '#191919',
    ) );
    
    /** Widget Title Settings */
    Kirki::add_section( 'business_one_page_pro_widget_title_section', array(
        'title'      => __( 'Widget Title Settings', 'business-one-page-pro' ),
        'priority'   => 29,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Widget Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_widget_title_font',
    	'label'       => __( 'Widget Title Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_widget_title_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** Widget Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_title_font_size',
        'label'    => __( 'Widget Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_title_section',
        'default'  => '21',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 35,
                        'step' => 1,
                    )
    ) );
    
    /** Widget Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_title_line_height',
        'label'    => __( 'Widget Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_title_section',
        'default'  => '25',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 40,
                        'step' => 1,
                    )
    ) );
    
    /** Widget ul/li Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_ulli_font_size',
        'label'    => __( 'Widget ul/li Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_title_section',
        'default'  => '17',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 20,
                        'step' => 1,
                    )
    ) );
    
    /** Widget ul/li Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_ulli_line_height',
        'label'    => __( 'Widget ul/li Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_title_section',
        'default'  => '24',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 40,
                        'step' => 1,
                    )
    ) );
    
    /** Widget Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_title_color',
        'label'    => __( 'Widget Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_title_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
    /** Widget Post Title Settings */
    Kirki::add_section( 'business_one_page_pro_widget_post_title_section', array(
        'title'      => __( 'Widget Post Title Settings', 'business-one-page-pro' ),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel'      => 'business_one_page_pro_typography_section'
    ) );
    
    /** Widget Post Title Font */
    Kirki::add_field( 'business_one_page_pro', array(
    	'type'        => 'typography',
    	'settings'    => 'business_one_page_pro_widget_post_title_font',
    	'label'       => __( 'Widget Title Font', 'business-one-page-pro' ),
    	'section'     => 'business_one_page_pro_widget_post_title_section',
    	'default'     => array(
    		'font-family'    => 'Oxygen',
    		'variant'        => '700',
    	),
    ) );
    
    /** Widget Post Title Font Size */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_post_font_size',
        'label'    => __( 'Widget Post Title Font Size', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_post_title_section',
        'default'  => '19',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 10,
                        'max'  => 20,
                        'step' => 1,
                    )
    ) );
    
    /** Widget Post Title Line Height */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_post_line_height',
        'label'    => __( 'Widget Post Title Line Height', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_post_title_section',
        'default'  => '22',
        'type'     => 'slider',
        'choices'  => array(
                        'min'  => 15,
                        'max'  => 40,
                        'step' => 1,
                    )
    ) );
    
    /** Widget Post Title Color */
    Kirki::add_field( 'business_one_page_pro', array(    
        'settings' => 'business_one_page_pro_widget_post_title_color',
        'label'    => __( 'Widget Post Title Color', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_widget_post_title_section',
        'type'     => 'color',
        'default'  => '#252626',
    ) );
    
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_typography' );