<?php
/**
 * Customizer Home Page Template Panel 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_home( $wp_customize ) {
    
    /** Option list of all pages */	
    $options_pages = array();
    $options_pages_obj = get_posts('posts_per_page=-1&post_type=page');
    $options_pages[''] = __( 'Choose Page', 'business-one-page-pro' );
    foreach ( $options_pages_obj as $pages ) {
    	$options_pages[$pages->ID] = $pages->post_title;
    }
    
    /** Option list of all Portfolio CPT */
    $options_porfolio = array();
    $options_port_obj = get_posts('posts_per_page=-1&post_type=portfolio');
    $options_porfolio[''] = __( 'Choose Portfolio', 'business-one-page-pro' );
    foreach ( $options_port_obj as $portfolio ) {
    	$options_porfolio[$portfolio->ID] = $portfolio->post_title;
    }
    
    /** Home Page Settings */
    Kirki::add_panel( 'business_one_page_pro_home_page_settings', array(
        'priority' => 24,
        'capability' => 'edit_theme_options',
        'title' => __( 'Home Page Settings', 'business-one-page-pro' ),
        'description' => __( 'Customize Home Page Settings', 'business-one-page-pro' ),
    ) );
    
    /** About Section */
    Kirki::add_section( 'business_one_page_pro_about_section', array(
        'title' => __( 'About Section', 'business-one-page-pro' ),
        'priority' => 20,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** About Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_about_section_menu_title',
        'label'       => __( 'About Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_about_section',
        'default'     => '',
    ) );
    
    /** Select Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_about_section_page',
        'label'       => __( 'Select Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_about_section',
        'default'     => '',
        'choices'     => $options_pages,
    ) );
    /** About Section Ends */
    
    /** Service Section */
    Kirki::add_section( 'business_one_page_pro_services_section', array(
        'title' => __( 'Service Section', 'business-one-page-pro' ),
        'priority' => 22,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Service Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_services_section_menu_title',
        'label'       => __( 'Service Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_services_section',
        'default'     => '',
    ) );
    
    /** Select Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_services_section_page',
        'label'       => __( 'Select Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_services_section',
        'default'     => '',
        'choices'     => $options_pages,
    ) );
    /** Service Section Ends*/
    
    /** Portfolio Section */
    Kirki::add_section( 'business_one_page_pro_portfolio_section', array(
        'title' => __( 'Portfolio Section', 'business-one-page-pro' ),
        'priority' => 25,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Portfolio Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_portfolio_section_menu_title',
        'label'       => __( 'Portfolio Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
    ) );
    
    /** Select Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_portfolio_section_page',
        'label'       => __( 'Select Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
        'choices'     => $options_pages,
    ) );
    
    /** Select Post One */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_portfolio_section_post_one',
        'label'       => __( 'Select Post One', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
        'choices'     => $options_porfolio,
    ) );
    
    /** Select Post Two */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_portfolio_section_post_two',
        'label'       => __( 'Select Post Two', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
        'choices'     => $options_porfolio,
    ) );
    
    /** Select Post Three */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_portfolio_section_post_three',
        'label'       => __( 'Select Post Three', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
        'choices'     => $options_porfolio,
    ) );
    
    /** Select Post Four */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_portfolio_section_post_four',
        'label'       => __( 'Select Post Four', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
        'choices'     => $options_porfolio,
    ) );
    
    /** Select Post Five */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_portfolio_section_post_five',
        'label'       => __( 'Select Post Five', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_portfolio_section',
        'default'     => '',
        'choices'     => $options_porfolio,
    ) );
    
    /** Read More Text */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Read More Text', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_portfolio_section',
        'settings'  => 'business_one_page_pro_portfolio_read_more',
        'type'      => 'text',
        'default'   => __( 'Learn More', 'business-one-page-pro' ),
    ) );
    
    /** Portfolio View All */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Portfolio View All', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_portfolio_section',
        'settings'  => 'business_one_page_pro_portfolio_view_all',
        'type'      => 'text',
        'default'   => __( 'View More Portfolio', 'business-one-page-pro' ),
    ) );
    
    /** No. of Character */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'No. of Character in Excerpt', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_portfolio_section',
        'settings'  => 'business_one_page_pro_portfolio_no_of_char',
        'type'      => 'slider',
        'default'   => 60,
        'choices'   => array(
            'min'   => 50,
            'max'   => 500,
            'step'  => 10
        ),
    ) );
    /** Portfolio Section Ends */
    
    /** Team Section */
    Kirki::add_section( 'business_one_page_pro_team_section', array(
        'title' => __( 'Team Section', 'business-one-page-pro' ),
        'priority' => 26,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Team Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_team_section_menu_title',
        'label'       => __( 'Team Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_team_section',
        'default'     => '',
    ) );
    
    /** Select Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_team_section_page',
        'label'       => __( 'Select Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_team_section',
        'default'     => '',
        'choices'     => $options_pages,
    ) );
    /** Team Section Ends */
    
    /** Client Section */
    Kirki::add_section( 'business_one_page_pro_clients_section', array(
        'title' => __( 'Client Section', 'business-one-page-pro' ),
        'priority' => 27,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Client Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_clients_section_menu_title',
        'label'       => __( 'Client Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_clients_section',
        'default'     => '',
    ) );
    
    /** Client Section Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_clients_section_title',
        'label'       => __( 'Client Section Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_clients_section',
        'default'     => '',
    ) );
    
    /** Client Section BG */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'image',
        'settings'    => 'business_one_page_pro_clients_section_bg',
        'label'       => __( 'Client Section Background', 'business-one-page-pro' ),
        'description' => __( 'Plese use 1400px X 330px size image.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_clients_section',
        'default'     => '',
    ) );
    /** Client Section Ends */
    
    /** Blog Sections */
    Kirki::add_section( 'business_one_page_pro_blog_section', array(
        'title' => __( 'Blog Section', 'business-one-page-pro' ),
        'priority' => 28,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Blog Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_blog_section_menu_title',
        'label'       => __( 'Blog Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_blog_section',
        'default'     => '',
    ) );
    
    /** Blog Section Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_blog_section_title',
        'label'       => __( 'Blog Section Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_blog_section',
        'default'     => '',
    ) );
    
    /** Blog Section Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_blog_section_content',
        'label'       => __( 'Blog Section Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_blog_section',
        'default'     => '',
    ) );
    
    /** Blog View All Text */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_blog_section_view_all',
        'label'       => __( 'View All Blogs', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_blog_section',
        'default'     => __( 'View All Blogs', 'business-one-page-pro' ),
    ) );
    
    /** No. of Character */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'No. of Character in Excerpt', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_blog_section',
        'settings'  => 'business_one_page_pro_blog_no_of_char',
        'type'      => 'slider',
        'default'   => 125,
        'choices'   => array(
            'min'   => 50,
            'max'   => 300,
            'step'  => 5
        ),
    ) );
    /** Blog Sections Ends */
    
    /** Testimonial Section */
    Kirki::add_section( 'business_one_page_pro_testimonial_section', array(
        'title' => __( 'Testimonial Section', 'business-one-page-pro' ),
        'priority' => 29,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Testimonial Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_testimonial_section_menu_title',
        'label'       => __( 'Testimonial Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_testimonial_section',
        'default'     => '',
    ) );
    
    /** Select Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_testimonial_section_page',
        'label'       => __( 'Select Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_testimonial_section',
        'default'     => '',
        'choices'     => $options_pages,
    ) );
    /** Testimonial Section Ends */
    
    /** Contact Section */
    Kirki::add_section( 'business_one_page_pro_contact_section', array(
        'title' => __( 'Contact Section', 'business-one-page-pro' ),
        'priority' => 31,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    /** Contact Section Menu Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_menu_title',
        'label'       => __( 'Contact Section Menu Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
    ) );
    
    /** Select Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_contact_section_page',
        'label'       => __( 'Select Page', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
        'choices'     => $options_pages,
    ) );
    
    /** Contact Form Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_form_title',
        'label'       => __( 'Contact Form Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => __( 'Leave a message', 'business-one-page-pro' ),
    ) );
    
    /** Contact Section Contact Form */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_form',
        'label'       => __( 'Contact Section Contact Form', 'business-one-page-pro' ),
        'description' => __( 'Enter the Contact Form 7 Shortcode. Ex. [contact-form-7 id="186" title="Google contact"]', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
        'sanitize_callback' => 'business_one_page_pro_sanitize_text',
    ) );
    
    /** Contact Info Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_info_title',
        'label'       => __( 'Contact Info Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
    ) );
    
    /** Contact Info Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_contact_section_info_content',
        'label'       => __( 'Contact Info Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
    ) );
    
    /** Contact Address */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_contact_section_address',
        'label'       => __( 'Contact Address', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
    ) );
    
    /** Contact Phone */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_phone',
        'label'       => __( 'Contact Phone', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
    ) );
    
    /** Contact Fax */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_fax',
        'label'       => __( 'Contact Fax', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
    ) );
    
    /** Contact Email */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_section_email',
        'label'       => __( 'Contact Email', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_section',
        'default'     => '',
        'sanitize_callback' => 'business_one_page_pro_sanitize_email',        
    ) );
    /** Contact Section Ends*/
    
    /** Sort Home Page Section */
    Kirki::add_section( 'business_one_page_pro_sort_home_section', array(
        'title' => __( 'Sort Home Page Sections', 'business-one-page-pro' ),
        'priority' => 32,
        'panel' => 'business_one_page_pro_home_page_settings',
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'sortable',
        'settings'    => 'business_one_page_pro_sort_homepage',
        'label'       => __( 'Sort Sections', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sort_home_section',
        'default'     => '',
        'choices'     => array(
    		'about'       => esc_attr__( 'About Section', 'business-one-page-pro' ),
    		'services'    => esc_attr__( 'Service Section', 'business-one-page-pro' ),
    		'cta1'        => esc_attr__( 'First CTA Section', 'business-one-page-pro' ),
    		'portfolio'   => esc_attr__( 'Portfolio Section', 'business-one-page-pro' ),
    		'team'        => esc_attr__( 'Team Section', 'business-one-page-pro' ),
    		'clients'     => esc_attr__( 'Client Section', 'business-one-page-pro' ),
            'blog'        => esc_attr__( 'Blog Section', 'business-one-page-pro' ),
            'testimonial' => esc_attr__( 'Testimonial Section', 'business-one-page-pro' ),
            'cta2'        => esc_attr__( 'Second CTA Section', 'business-one-page-pro' ),
            'contact'     => esc_attr__( 'Contact Section', 'business-one-page-pro' ),
    	),        
    ) );
        
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_home' );