<?php
/**
 * Customizer Contact Page Template Panel 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_contact( $wp_customize ) {
    
    /** Zoom Level */
    $zoom = array();
    for($z = 1; $z < 20; $z++){
        $zoom[$z] = $z;    
    }
    
    Kirki::add_panel( 'business_one_page_pro_contact_page_settings', array(
        'priority' => 26,
        'capability' => 'edit_theme_options',
        'title' => __( 'Contact Page Settings', 'business-one-page-pro' ),
        'description' => __( 'Customize Contact Page Settings', 'business-one-page-pro' ),
    ) );
    
    /** Google Map Section */
    Kirki::add_section( 'business_one_page_pro_google_map_section', array(
        'title' => __( 'Google Map Section', 'business-one-page-pro' ),
        'priority' => 20,
        'panel' => 'business_one_page_pro_contact_page_settings',
    ) );
    
    /** Enable/Disable Google map */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_ed_google_map',
        'label'    => __( 'Enable/Disable Google map', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'toggle',
        'default'  => ''
    ) );
    
    /** Enable/Disable Scrolling Wheel */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_ed_map_scroll',
        'label'    => __( 'Enable/Disable Scrolling Wheel', 'business-one-page-pro' ),
        'help'     => __( 'Zoom map on Scrolling', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'toggle',
        'default'  => '1'
    ) );
    
    /** Enable/Disable Map Controls */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_ed_map_controls',
        'label'    => __( 'Enable/Disable Map Controls', 'business-one-page-pro' ),
        'help'     => __( 'Controls icons that appears above Map', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'toggle',
        'default'  => '1'
    ) );
    
    /** Enable/Disable Map Marker */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_ed_map_marker',
        'label'    => __( 'Enable/Disable Map Marker', 'business-one-page-pro' ),
        'help'     => __( 'Marker icons that appears above Map', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'toggle',
        'default'  => ''
    ) );
    
    /** Marker Title */ 
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_marker_title',
        'label'    => __( 'Marker Title', 'business-one-page-pro' ),
        'help'     => __( 'Enter the Marker Title', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'text',
        'default'  => '',
        'active_callback' => array(
        	array(
        		'setting'  => 'business_one_page_pro_ed_map_marker',
        		'operator' => '==',
        		'value'    => 1,
        	),
         )
    ) );
    
    /** API Key */ 
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_map_api',
        'label'    => __( 'Google Map API Key', 'business-one-page-pro' ),
        'help'     => __( 'Enter the Google Map API Key', 'business-one-page-pro' ),
        'description' => __( 'You can get API key from here https://developers.google.com/maps/documentation/javascript/get-api-key', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'text',
        'default'  => ''
    ) );
    
    /** Latitude */ 
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_lattitude',
        'label'    => __( 'Latitude', 'business-one-page-pro' ),
        'help'     => __( 'Enter the Latitude of your Location', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'number',
        'default'  => '27.7304135'
    ) );
    
    /** Longitude */ 
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_longitude',
        'label'    => __( 'Longitude', 'business-one-page-pro' ),
        'help'     => __( 'Enter the Longitude of your Location', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'number',
        'default'  => '85.3304937'
    ) );
   
    /** Map Height */ 
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_map_height',
        'label'    => __( 'Map Height', 'business-one-page-pro' ),
        'help'     => __( 'Enter the height of map for example: 300', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'number',
        'default'  => '320'
    ) );
    
    /** Zoom Level */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_map_zoom',
        'label'    => __( 'Zoom Level', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'select',
        'default'  => '17',
        'choices'  => $zoom
    ) );
    
    /** Map Type */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_map_type',
        'label'    => __( 'Map Type', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_google_map_section',
        'type'     => 'select',
        'default'  => 'ROADMAP',
        'choices'  => array(
            'ROADMAP'   => __( 'ROADMAP', 'business-one-page-pro' ),
            'SATELLITE' => __( 'SATELLITE', 'business-one-page-pro' ),
            'HYBRID'    => __( 'HYBRID', 'business-one-page-pro' ),
            'TERRAIN'   => __( 'TERRAIN', 'business-one-page-pro' )
        )
    ) );
    
    /** Contact Details Section */
    Kirki::add_section( 'business_one_page_pro_contact_detail_section', array(
        'title' => __( 'Contact Details Section', 'business-one-page-pro' ),
        'priority' => 21,
        'panel' => 'business_one_page_pro_contact_page_settings',
    ) );
    
    /** Contact Details as in Home Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'settings' => 'business_one_page_pro_contact_asin_home_page',
        'label'    => __( 'Contact Details as in Home Page', 'business-one-page-pro' ),
        'help'     => __( 'Enabling will use details from home page contact us setting', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_contact_detail_section',
        'type'     => 'toggle',
        'default'  => '1'
    ) );
    
    /** Contact Info Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_detail_info_title',
        'label'       => __( 'Contact Info Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_detail_section',
        'default'     => '',
        'active_callback'  => array(
    		array(
    			'setting'  => 'business_one_page_pro_contact_asin_home_page',
    			'operator' => '!=',
    			'value'    => 1,
    		)
  	   )
    ) );
    
    /** Contact Info Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_contact_detail_info_content',
        'label'       => __( 'Contact Info Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_detail_section',
        'default'     => '',
        'active_callback'  => array(
    		array(
    			'setting'  => 'business_one_page_pro_contact_asin_home_page',
    			'operator' => '!=',
    			'value'    => 1,
    		)
  	   )
    ) );
    
    /** Contact Address */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_contact_detail_address',
        'label'       => __( 'Contact Address', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_detail_section',
        'default'     => '',
        'active_callback'  => array(
    		array(
    			'setting'  => 'business_one_page_pro_contact_asin_home_page',
    			'operator' => '!=',
    			'value'    => 1,
    		)
  	   )
    ) );
    
    /** Contact Phone */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_detail_phone',
        'label'       => __( 'Contact Phone', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_detail_section',
        'default'     => '',
        'active_callback'  => array(
    		array(
    			'setting'  => 'business_one_page_pro_contact_asin_home_page',
    			'operator' => '!=',
    			'value'    => 1,
    		)
  	   )
    ) );
    
    /** Contact Fax */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_detail_fax',
        'label'       => __( 'Contact Fax', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_detail_section',
        'default'     => '',
        'active_callback'  => array(
    		array(
    			'setting'  => 'business_one_page_pro_contact_asin_home_page',
    			'operator' => '!=',
    			'value'    => 1,
    		)
  	   )
    ) );
    
    /** Contact Email */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_contact_detail_email',
        'label'       => __( 'Contact Email', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_contact_detail_section',
        'default'     => '',
        'active_callback'  => array(
    		array(
    			'setting'  => 'business_one_page_pro_contact_asin_home_page',
    			'operator' => '!=',
    			'value'    => 1,
    		)
        ),
        'sanitize_callback' => 'business_one_page_pro_sanitize_email',        
    ) );    
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_contact' );