<?php
/**
 * Customizer About Page Template Panel 
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_about( $wp_customize ) {
    
    Kirki::add_panel( 'business_one_page_pro_about_page_settings', array(
        'priority' => 25,
        'capability' => 'edit_theme_options',
        'title' => __( 'About Page Settings', 'business-one-page-pro' ),
        'description' => __( 'Customize About Page Settings', 'business-one-page-pro' ),
    ) );
    
    /** Our Mission Section */
    Kirki::add_section( 'business_one_page_pro_mission_section', array(
        'title' => __( 'Our Mission Section', 'business-one-page-pro' ),
        'priority' => 21,
        'panel' => 'business_one_page_pro_about_page_settings',
    ) );
    
    /** Our Mission Section Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_mission_section_title',
        'label'       => __( 'Our Mission Section Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_mission_section',
        'default'     => '',
    ) );
    
    /** Our Mission Section Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'editor',
        'settings'    => 'business_one_page_pro_mission_section_content',
        'label'       => __( 'Our Mission Section Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_mission_section',
        'default'     => '',
    ) );
    
    /** Core Values Section */
    Kirki::add_section( 'business_one_page_pro_core_value_section', array(
        'title' => __( 'Core Values Section', 'business-one-page-pro' ),
        'priority' => 22,
        'panel' => 'business_one_page_pro_about_page_settings',
    ) );
    
    /** Core Values Section Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_core_section_title',
        'label'       => __( 'Our Mission Section Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_core_value_section',
        'default'     => '',
    ) );
    
    /** Our Mission Section Content */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'editor',
        'settings'    => 'business_one_page_pro_core_section_content',
        'label'       => __( 'Our Mission Section Content', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_core_value_section',
        'default'     => '',
    ) );
    
    /** Our Client Section */
    Kirki::add_section( 'business_one_page_pro_our_client_section', array(
        'title' => __( 'Our Client Section', 'business-one-page-pro' ),
        'priority' => 24,
        'panel' => 'business_one_page_pro_about_page_settings',
    ) );
    
    /** Our Client Section Title */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'text',
        'settings'    => 'business_one_page_pro_our_client_title',
        'label'       => __( 'Our Client Section Title', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_our_client_section',
        'default'     => '',
    ) );
    
    /** Client Section BG */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'image',
        'settings'    => 'business_one_page_pro_our_clients_bg',
        'label'       => __( 'Our Client Section Background', 'business-one-page-pro' ),
        'description' => __( 'Plese use 1400px X 330px size image.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_our_client_section',
        'default'     => '',
    ) );
    
    /** Sort About Page Section */
    Kirki::add_section( 'business_one_page_pro_sort_about_section', array(
        'title' => __( 'Sort About Page Section', 'business-one-page-pro' ),
        'priority' => 25,
        'panel' => 'business_one_page_pro_about_page_settings',
    ) );
    
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'sortable',
        'settings'    => 'business_one_page_pro_sort_aboutpage',
        'label'       => __( 'Sort Sections', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_sort_about_section',
        'default'     => '',        
        'choices'     => array(
    		'intro'   => esc_attr__( 'Intro Section', 'business-one-page-pro' ),
    		'stat'    => esc_attr__( 'Stat Counter Section', 'business-one-page-pro' ),
    		'mission' => esc_attr__( 'Our Mission Section', 'business-one-page-pro' ),
    		'core'    => esc_attr__( 'Our Core Values Section', 'business-one-page-pro' ),
    		'client'  => esc_attr__( 'Our Client Section', 'business-one-page-pro' ),            
    	),        
    ) );
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_about' );