<?php
/**
 * Custom Functions used in this theme.
 *
 * @package Business_One_Page_Pro
 */

if ( ! function_exists( 'business_one_page_pro_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function business_one_page_pro_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Business One Page, use a find and replace
	 * to change 'business-one-page-pro' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'business-one-page-pro', get_template_directory() . '/languages' );
    
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'business-one-page-pro' ),
        'top'     => esc_html__( 'Top', 'business-one-page-pro' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
	) );

	/* Custom Logo */
    add_theme_support( 'custom-logo', array(
    	'header-text' => array( 'site-title', 'site-description' ),
    ) );
    
    //Custom Image Sizes
    add_image_size( 'business-one-page-pro-post-thumb', 80, 70, true);    
    add_image_size( 'business-one-page-pro-slider', 1400, 577, true);
    
    add_image_size( 'business-one-page-pro-full', 1170, 480, true);
    add_image_size( 'business-one-page-pro-with-sidebar', 750, 460, true);
    add_image_size( 'business-one-page-pro-cat-blog', 750, 360, true);
    add_image_size( 'business-one-page-pro-blog-small', 293, 293, true);
    add_image_size( 'business-one-page-pro-team', 340, 310, true);
    
    add_image_size( 'business-one-page-pro-blog', 360, 280, true);
    add_image_size( 'business-one-page-pro-testimonial', 111, 111, true);
    add_image_size( 'business-one-page-pro-360x340', 360, 340, true);
    add_image_size( 'business-one-page-pro-360x380', 360, 380, true);
    add_image_size( 'business-one-page-pro-360x500', 360, 500, true);
    
    
}
endif;

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function business_one_page_pro_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'business_one_page_pro_content_width', 750 );
}

/**
 * Enqueue scripts and styles.
 */
function business_one_page_pro_scripts() {
	
    $my_theme = wp_get_theme();
    $version = $my_theme['Version'];
    
    $map_api = get_theme_mod( 'business_one_page_pro_map_api' );
    
    $key = $map_api ? '?key='.esc_attr( $map_api ) : '' ;
    
    wp_enqueue_style( 'business-one-page-pro-font-awesome', get_template_directory_uri() . '/css/font-awesome.css' );
    wp_enqueue_style( 'business-one-page-pro-lightslider-style', get_template_directory_uri() . '/css/lightslider.css' );
    wp_enqueue_style( 'business-one-page-pro-sidr-style', get_template_directory_uri() . '/css/jquery.sidr.light.css' );
    wp_enqueue_style( 'business-one-page-pro-scrollbar-style', get_template_directory_uri() . '/css/jquery.mCustomScrollbar.css' );
    wp_enqueue_style( 'business-one-page-pro-style', get_stylesheet_uri(), '', $version );
    
    if( is_woocommerce_activated() )
    wp_enqueue_style( 'business-one-page-pro-woocommerce-style', get_template_directory_uri(). '/css/woocommerce.css', array('business-one-page-pro-style'), $version );
    
    if( get_theme_mod( 'business_one_page_pro_ed_lightbox') ){
        wp_enqueue_style( 'business-one-page-pro-fancybox-style', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.css', '', '2.1.5' );
        wp_enqueue_script( 'business-one-page-pro-fancybox', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.pack.js', array('jquery'), '2.1.5', true );
    }
    
	if( is_page_template( 'templates/template-contact.php' ) )
    wp_enqueue_script( 'business-one-page-pro-googlemap', '//maps.googleapis.com/maps/api/js'.$key, array('jquery'), '3.0', false );
    
    if( is_page_template( array( 'templates/template-home.php', 'templates/template-portfolio.php', 'templates/template-testimonial.php', 'templates/template-team.php' ) ) )
    wp_enqueue_script( 'masonry' );
    
    if( is_page_template( 'templates/template-portfolio.php' ) )
    wp_enqueue_script( 'business-one-page-pro-isotope', get_template_directory_uri() . '/js/isotope.pkgd.js', array('jquery'), '3.0.1', true );
    
    if( is_active_widget( false, false, 'business_one_page_pro_flickr_widget' ) )
    wp_enqueue_script( 'business-one-page-pro-flickr', get_template_directory_uri() . '/js/jflickrfeed.js', array('jquery'), $version, true );
    
    if( is_active_widget( false, false, 'business_one_page_pro_stat_counter_widget' ) ){
        wp_enqueue_script( 'business-one-page-pro-waypoint', get_template_directory_uri() . '/js/waypoint.js', array('jquery'), '2.0.3', true );
        wp_enqueue_script( 'business-one-page-pro-counterup', get_template_directory_uri() . '/js/jquery.counterup.js', array('jquery', 'business-one-page-pro-waypoint'), '1.0', true );
    }
    
    wp_enqueue_script( 'business-one-page-pro-scrollbar', get_template_directory_uri() . '/js/jquery.mCustomScrollbar.js', array('jquery'), '3.1.5', true );
    wp_enqueue_script( 'business-one-page-pro-fitvids', get_template_directory_uri() . '/js/jquery.fitvids.js', array('jquery'), '1.1', true );
    wp_enqueue_script( 'business-one-page-pro-lightslider', get_template_directory_uri() . '/js/lightslider.js', array('jquery'), '1.1.5', true );
    wp_enqueue_script( 'business-one-page-pro-sidr', get_template_directory_uri() . '/js/jquery.sidr.js', array('jquery'), '2.2.1', true );
    wp_enqueue_script( 'business-one-page-pro-headroom', get_template_directory_uri() . '/js/headroom.js', array('jquery'), '0.7.0', true );
    wp_enqueue_script( 'business-one-page-pro-equalheight', get_template_directory_uri() . '/js/equal-height.js', array('jquery'), $version, true );
    wp_enqueue_script( 'business-one-page-pro-scrollnav', get_template_directory_uri() . '/js/scroll-nav.js', array('jquery'), '3.0.0', true );
    wp_register_script( 'business-one-page-pro-custom', get_template_directory_uri() . '/js/custom.js', array('jquery'), $version, true );
    wp_register_script( 'business-one-page-pro-ajax', get_template_directory_uri() . '/js/ajax.js', array('jquery'), $version, true );
    
    $slider_auto      = get_theme_mod( 'business_one_page_pro_slider_auto', '1' );
    $slider_loop      = get_theme_mod( 'business_one_page_pro_slider_loop', '1' );
    $slider_pager     = get_theme_mod( 'business_one_page_pro_slider_pager', '1' );    
    $slider_animation = get_theme_mod( 'business_one_page_pro_slider_animation', 'slide' );
    $slider_speed     = get_theme_mod( 'business_one_page_pro_slider_speed', '400' );
    $slider_pause     = get_theme_mod( 'business_one_page_pro_slider_pause', '6000' );
    
    $array = array(
        'auto'      => esc_attr( $slider_auto ),
        'loop'      => esc_attr( $slider_loop ),
        'pager'     => esc_attr( $slider_pager ),
        'mode'      => esc_attr( $slider_animation ),
        'speed'     => absint( $slider_speed ),
        'pause'     => absint( $slider_pause ),
        'lightbox'  => esc_attr( get_theme_mod( 'business_one_page_pro_ed_lightbox') ),
        'rtl'       => is_rtl(),
    );
    
    wp_localize_script( 'business-one-page-pro-custom', 'business_one_page_pro_data', $array );
    wp_enqueue_script( 'business-one-page-pro-custom' );
    
    $pagination = get_theme_mod( 'business_one_page_pro_pagination_type', 'default' );
    
    if( get_theme_mod( 'business_one_page_pro_ed_ajax_search' ) || $pagination == 'load_more' || $pagination == 'infinite_scroll' ){
        
        // Add parameters for the JS
        global $wp_query;
        $max = $wp_query->max_num_pages;
        $paged = ( get_query_var( 'paged' ) > 1 ) ? get_query_var( 'paged' ) : 1;
        
        wp_enqueue_script( 'business-one-page-pro-ajax' );
        
        wp_localize_script( 
            'business-one-page-pro-ajax', 
            'business_one_page_pro_ajax',
            array(
                'url'           => admin_url( 'admin-ajax.php' ),
                'startPage'     => $paged,
                'maxPages'      => $max,
                'nextLink'      => next_posts( $max, false ),
                'autoLoad'      => $pagination,
                'loadmore'      => __( 'Load More Posts', 'business-one-page-pro' ),
                'loading'       => __('Loading...', 'business-one-page-pro'),
                'nomore'        => __( 'No more posts.', 'business-one-page-pro' ),
                'plugin_url'    => plugins_url()
             )
        );
        
        if ( is_jetpack_activated( true ) ) {
            wp_enqueue_style( 'business-one-page-pro-jetpack-style', plugins_url() . '/jetpack/modules/tiled-gallery/tiled-gallery/tiled-gallery.css' );            
        }
    }
    
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

/**
 * Enqueue google fonts
*/
function business_one_page_pro_scripts_styles() {
    wp_enqueue_style( 'business-one-page-pro-google-fonts', business_one_page_pro_fonts_url(), array(), null );
}

/**
 * Enqueue admin scripts and styles.
 */
function business_one_page_pro_admin_scripts(){
    
    $my_theme = wp_get_theme();
    $version = $my_theme['Version'];
    
    if( function_exists( 'wp_enqueue_media' ) )
    wp_enqueue_media();
    
    wp_enqueue_style( 'wp-color-picker' );  
    wp_enqueue_style( 'business-one-page-pro-admin-fontawesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.6.3' );
    wp_enqueue_style( 'business-one-page-pro-admin-style', get_template_directory_uri() . '/inc/css/admin.css', array(), $version );
    
    wp_register_script( 'business-one-page-pro-media-uploader', get_template_directory_uri() . '/inc/js/media-uploader.js', array('jquery'), $version );
    wp_register_script( 'business-one-page-pro-admin-js', get_template_directory_uri() . '/inc/js/admin.js', array('jquery'), $version );
    
    wp_localize_script( 'business-one-page-pro-media-uploader', 'business_one_page_pro_uploader', array(
        'upload' => __( 'Upload', 'business-one-page-pro' ),
        'change' => __( 'Change', 'business-one-page-pro' ),
        'msg'    => __( 'Please upload valid image file.', 'business-one-page-pro' )
    ));
    
    wp_localize_script( 'business-one-page-pro-admin-js', 'business_one_page_pro_admin', array(
        'import_true' => __( 'Are you sure to import dummy content?', 'business-one-page-pro' ),
        'demo_msg'    => __( 'The Demo Contents are Loading. It might take a while. Please keep patience.', 'business-one-page-pro' ),
        'success_msg' => __( 'Demo Contents Successfully Imported.', 'business-one-page-pro' ),
    ));
    
    wp_enqueue_script( 'business-one-page-pro-media-uploader' );
    
    //For Color Picker
    wp_enqueue_script('business-one-page-pro-color-picker', get_template_directory_uri() . '/inc/js/color-picker.js', array( 'wp-color-picker' ), $version );
    
    wp_enqueue_script( 'business-one-page-pro-admin-js' );
    
}

/** 
 * Registering and enqueuing scripts/stylesheets for Customizer controls.
 */ 
function business_one_page_pro_customizer_js() {
	wp_enqueue_script( 'business-one-page-pro-customizer-js', get_template_directory_uri() . '/inc/js/customizer.js', array('jquery'), '20160523', true  );
}

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function business_one_page_pro_body_classes( $classes ) {
	
    $bg_color   = get_theme_mod( 'business_one_page_pro_bg_color', '#FFFFFF' );
    $bg_image   = get_theme_mod( 'business_one_page_pro_bg_image' );
    $bg_pattern = get_theme_mod( 'business_one_page_pro_bg_pattern', 'nobg' );
    $bg         = get_theme_mod( 'business_one_page_pro_body_bg', 'image' );
    
    // Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
    
    // Adds a class for custom background Color
    if( $bg_color != '#FFFFFF' ){
        $classes[] = 'custom-background-color';
    }
    
    // Adds a class for custom background Color
    if( ( $bg == 'image' && $bg_image ) || (  $bg == 'pattern' && $bg_pattern != 'nobg' ) ){
        $classes[] = 'custom-background-image';
    }
    
    $classes[] = business_one_page_pro_sidebar( false, true );
    
    if( is_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() || 'product' === get_post_type() ) && ! is_active_sidebar( 'shop-sidebar' ) ){
        $classes[] = 'full-width';
    }
                
	return $classes;
}

/**
 * Adds custom classes to the array of post classes.
 *
 * @param array $classes Classes for the post element.
 * @return array
 */
function business_one_page_pro_post_classes( $classes ) {
    
    $classes[] = 'latest_post';
    
    return $classes;
}

/** 
* Hook to move comment text field to the bottom in WP 4.4
* 
* @link http://www.wpbeginner.com/wp-tutorials/how-to-move-comment-text-field-to-bottom-in-wordpress-4-4/ 
*/
function business_one_page_pro_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}

/**
 * Custom CSS
*/
function business_one_page_pro_custom_css(){
    $custom_css = get_theme_mod( 'business_one_page_pro_custom_css' );
    if( !empty( $custom_css ) ){
		echo '<style type="text/css">';
		echo wp_strip_all_tags( $custom_css );
		echo '</style>';
	}
}

/**
 * Custom JS
*/
function business_one_page_pro_custom_js(){
    $custom_script = get_theme_mod( 'business_one_page_pro_custom_script' );
    if( $custom_script ){
        echo '<script type="text/javascript">';
		echo wp_strip_all_tags( $custom_script );
		echo '</script>';
    }
}

/**
 * Flush out the transients used in business_one_page_pro_categorized_blog.
 */
function business_one_page_pro_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'business_one_page_pro_categories' );
}

/**
 * Function that removes the default thumbnail and add custom thumbnail meta box 
 */
function business_one_page_pro_logo_metabox(){
   remove_meta_box( 'postimagediv', 'logo', 'side' );
   add_meta_box( 'postimagediv', __( 'Featured Image', 'business-one-page-pro' ), 'post_thumbnail_meta_box', 'logo', 'normal', 'high' );
}

/**
 * Function to add excerpt field in pages
*/
function business_one_page_pro_excerpts_in_pages() {
     add_post_type_support( 'page', 'excerpt' );
}

/**
 * Callback Function for Google Map 
 * @link https://developers.google.com/maps/documentation/javascript/examples/marker-simple#try-it-yourself
*/
function business_one_page_pro_google_map_cb(){
    if( is_page_template( 'templates/template-contact.php' ) ){
        
        $ed_google_map   = get_theme_mod( 'business_one_page_pro_ed_google_map' );
        $lattitude       = get_theme_mod( 'business_one_page_pro_lattitude', '27.7304135' );
        $longitude       = get_theme_mod( 'business_one_page_pro_longitude', '85.3304937' );
        $map_height      = get_theme_mod( 'business_one_page_pro_map_height', '320' );
        $map_zoom        = get_theme_mod( 'business_one_page_pro_map_zoom', '17' );
        $map_type        = get_theme_mod( 'business_one_page_pro_map_type', 'ROADMAP' );
        $map_scroll      = ( get_theme_mod( 'business_one_page_pro_ed_map_scroll', '1' ) == 1 ) ? 'true' : 'false';
        $map_control     = ( get_theme_mod( 'business_one_page_pro_ed_map_controls', '1' ) != 1 ) ? 'true' : 'false';
        $map_control_inv = ( get_theme_mod( 'business_one_page_pro_ed_map_controls', '1' ) == 1 ) ? 'true' : 'false';
        $ed_map_marker   = get_theme_mod( 'business_one_page_pro_ed_map_marker' );
        $marker_title    = get_theme_mod( 'business_one_page_pro_marker_title' );
            
        if( $ed_google_map ){ ?>
        <style>
          #map {
            width: 100%;
            height: <?php echo $map_height; ?>px;
          }
        </style>
        <script type="text/javascript">
        
            var map;
            var myLatLng = {lat: <?php echo $lattitude;?>, lng: <?php echo $longitude;?>};
            
            function initialize() {
                var mapOptions = {
                    zoom: <?php echo $map_zoom; ?>,
                    center: new google.maps.LatLng(<?php echo $lattitude;?>, <?php echo $longitude;?> ),
                    mapTypeId: google.maps.MapTypeId.<?php echo $map_type; ?>,
                    scrollwheel: <?php echo $map_scroll ?>,
                    zoomControl: <?php echo $map_control_inv ?>,
                    zoomControlOptions: {
                        style: google.maps.ZoomControlStyle.SMALL
                    },
                    mapTypeControl: <?php echo $map_control_inv ?>,
                    mapTypeControlOptions: {
                        style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
                    },
                    disableDefaultUI: <?php echo $map_control ?>,
                };
                map = new google.maps.Map(document.getElementById('map'), mapOptions);
                
                <?php if( $ed_map_marker ){ ?>
                var marker = new google.maps.Marker({
                  position: myLatLng,
                  map: map,
                  <?php if( $marker_title ) echo 'title: "' . esc_html( $marker_title ) . '"' ?>
                });
                <?php } ?>
            }
            google.maps.event.addDomListener(window, 'load', initialize); 
          
        </script>
    <?php }
    }    
}

/**
 * AJAX Search results
 */ 
function business_one_page_pro_ajax_search() {
    $query = $_REQUEST['q']; // It goes through esc_sql() in WP_Query
    $search_query = new WP_Query( array( 's' => $query, 'posts_per_page' => 3, 'post_status' => 'publish' )); 
    $search_count = new WP_Query( array( 's' => $query, 'posts_per_page' => -1, 'post_status' => 'publish' ));
    $search_count = $search_count->post_count;
    if ( !empty( $query ) && $search_query->have_posts() ) : 
        
        echo '<ul class="ajax-search-results">';
        while ( $search_query->have_posts() ) : $search_query->the_post(); ?>
        <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>   
        <?php
        endwhile;
        echo '</ul>';
        
        echo '<div class="ajax-search-meta"><span class="results-count">'.$search_count.' '.__( 'Results', 'business-one-page-pro' ).'</span><a href="'.get_search_link( $query ).'" class="results-link">'.__('Show all results.', 'business-one-page-pro').'</a></div>';
    else:
        echo '<div class="no-results">'.__( 'No results found.', 'business-one-page-pro' ).'</div>';
    endif;
    
    wp_die(); // this is required to terminate immediately and return a proper response
}

/**
 * Exclude post with Category from blog and archive page. 
*/
function business_one_page_pro_exclude_cat( $query ){
    $cat = get_theme_mod( 'business_one_page_pro_exclude_categories' );
    
    if( $cat && ! is_admin() && $query->is_main_query() ){
        $cat = array_diff( array_unique( $cat ), array('') );
        if( $query->is_home() || $query->is_archive() ) {
			$query->set( 'category__not_in', $cat );
		}
    }    
}

/** 
 * Exclude Categories from Category Widget 
*/ 
function business_one_page_pro_custom_category_widget( $arg ) {
	$cat = get_theme_mod( 'business_one_page_pro_exclude_categories' );
    
    if( $cat ){
        $cat = array_diff( array_unique( $cat ), array('') );
        $arg["exclude"] = $cat;
    }
	return $arg;
}

/**
 * Exclude post from recent post widget of excluded catergory
 * 
 * @link http://blog.grokdd.com/exclude-recent-posts-by-category/
*/
function business_one_page_pro_exclude_posts_from_recentPostWidget_by_cat(){
    $s = '';
    $i = 1;
    $cat = get_theme_mod( 'business_one_page_pro_exclude_categories' );
   
    if( $cat ){
        $cat = array_diff( array_unique( $cat ), array('') );
        foreach( $cat as $c ){
            $i++;
            $s .= '-'.$c;
            if( count($cat) >= $i )
            $s .= ', ';
        }
    }
    
    $exclude = array( 'cat' => $s );
    
    return $exclude;   
}

/**
 * List of allowed social protocols in HTML attributes.
 * @param  array $protocols Array of allowed protocols.
 * @return array
 */
function business_one_page_pro_allowed_social_protocols( $protocols ) {
    $social_protocols = array(
        'skype'
    );
    return array_merge( $protocols, $social_protocols );    
}

/**
 * Load theme updater functions.
 * Action is used so that child themes can easily disable.
 */
function business_one_page_pro_theme_updater() {
    require( get_template_directory() . '/updater/theme-updater.php' );
}