<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Business_One_Page_Pro
 */
?>
    <?php
    /**
     * Function hooked into business_one_page_wrapper_end action
     * 
     * @hooked business_one_page_pro_wrapper_end_cb     - 20
     * @hooked business_one_page_pro_outer_wrapper_end  - 30
    */    
    
    do_action( 'business_one_page_wrapper_end' );
    
    ?>
    
	<footer id="colophon" class="site-footer" role="contentinfo">
		
        <div class="container">
			
            <?php if( is_active_sidebar( 'footer-one' ) || is_active_sidebar( 'footer-two' ) || is_active_sidebar( 'footer-three' ) ){?>
            <div class="footer-t">
				<div class="row">
					
                    <?php if( is_active_sidebar( 'footer-one' ) ){ ?>
                    <div class="columns-3">
						<?php dynamic_sidebar( 'footer-one' ); ?>
					</div>
					<?php } ?>
                    
                    <?php if( is_active_sidebar( 'footer-two' ) ){ ?>
                    <div class="columns-3">
						<?php dynamic_sidebar( 'footer-two' ); ?>
					</div>
                    <?php } ?>
					
                    <?php if( is_active_sidebar( 'footer-three' ) ){ ?>
                    <div class="columns-3">
						<?php dynamic_sidebar( 'footer-three' ); ?>
					</div>
                    <?php } ?>
                    
				</div><!-- .row -->
			</div><!-- .footer-t -->
            <?php } 
                /**
                 * Footer Credits
                 * 
                 * @hoooked business_one_page_pro_footer_credit
                */
                do_action( 'business_one_page_pro_footer' );
            ?>
            
		</div><!-- .container -->
        
	</footer><!-- #colophon -->
    
    <div id="rara-top"><i class="fa fa-angle-up"></i></div>
    
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
