<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://rarathemes.com', // Site where EDD is hosted
		'item_name'      => 'Business One Page Pro', // Name of theme
		'theme_slug'     => 'business-one-page-pro', // Theme slug
		'version'        => '1.3.9', // The current version of this theme
		'author'         => 'Rara Theme', // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Getting Started', 'business-one-page-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'business-one-page-pro' ),
		'license-key'               => __( 'License Key', 'business-one-page-pro' ),
		'license-action'            => __( 'License Action', 'business-one-page-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'business-one-page-pro' ),
		'activate-license'          => __( 'Activate License', 'business-one-page-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'business-one-page-pro' ),
		'renew'                     => __( 'Renew?', 'business-one-page-pro' ),
		'unlimited'                 => __( 'unlimited', 'business-one-page-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'business-one-page-pro' ),
		'expires%s'                 => __( 'Expires %s.', 'business-one-page-pro' ),
		'expires-never'             => __( 'Lifetime License.', 'business-one-page-pro' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'business-one-page-pro' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'business-one-page-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'business-one-page-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'business-one-page-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'business-one-page-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'business-one-page-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'business-one-page-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'business-one-page-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'business-one-page-pro' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4$s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'business-one-page-pro' ),
	)

);