<?php
/**
 * Template Name: Testimonial Page
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Business_One_Page_Pro
 */

get_header(); ?>

<div class="testimonail-section">
    <div class="container">
        
        <div class="entry-content">
            <?php 
            while ( have_posts() ) : the_post();
                the_content(); 
            endwhile; // End of the loop.
            ?>
        </div>
        
        <div class="row js-masonry">
            <?php
                $arg = array(
                    'post_type'     => 'testimonial',
                    'post_status'   => 'publish',
                    'posts_per_page'=> -1
                );
                $testimonial_qry = new WP_Query( $arg );
                if( $testimonial_qry->have_posts() ){
                    while( $testimonial_qry->have_posts() ){
                        $testimonial_qry->the_post();
                        $designation = get_post_meta( get_the_ID(), '_business_one_page_pro_testimonial_designation', true );
                        ?>
                        <div class="testimonial-wrap">
                            <div class="testimonial-holder">
                                <div class="testimonail-content"><?php the_content(); ?></div>
                                <?php if( has_post_thumbnail() ){ ?>
                                    <div class="testimonial-img"><?php the_post_thumbnail( 'business-one-page-pro-testimonial', array( 'itemprop' => 'image' ) ); ?></div> 
                                <?php }?>
                                <?php 
                                    the_title( '<h3 class="testimonial-title">', '</h3>' );
                                    if( $designation ) echo '<div class="testimonail-designation">' . esc_html( $designation ) . '</div>'; 
                                ?>
                            </div>
                        </div>
                        <?php                        
                    }
                }
            ?>
        
        
        </div>
        
    </div>
</div>
            
<?php
get_footer();