<?php
/**
 * Template Name: Contact Page
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Business_One_Page_Pro
 */

get_header(); 

$ed_google_map     = get_theme_mod( 'business_one_page_pro_ed_google_map' );
$google_map_option = get_theme_mod( 'business_one_page_pro_google_map_option', 'google_map_api' );
$map_iframe        = get_theme_mod( 'business_one_page_pro_map_iframe' );


 	if( $ed_google_map && 'google_map_api' == $google_map_option ){ 
 		echo '<div id="map" class="map-holder"></div>';
 	}elseif( $ed_google_map && 'google_map_iframe' == $google_map_option ){
            echo '<div id="map" class="map-holder">';
            echo wp_specialchars_decode( $map_iframe );
            echo '</div>';
    } 
    ?>
	    
	<section class="contact-section">
		<div class="container">
			<div class="row">
				
                <?php while ( have_posts() ) : the_post(); ?>
                <div class="columns-6">
					<?php the_content(); ?>
				</div><!-- .columns-6 -->
				<?php endwhile; ?>
                
                <div class="columns-6">
                    <?php
                        /**
                         * Contact Details
                         * @hooked business_one_page_pro_contact_details_cb
                        */ 
                        do_action( 'business_one_page_pro_contact_details' ); 
                    ?>						
				</div><!-- .columns-6 -->
                
			</div><!-- .row -->
		</div><!-- .container -->
	</section><!-- .contact-section -->
            
<?php
get_footer();