<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Business_One_Page_Pro
 */

$blog_layout = get_theme_mod( 'business_one_page_pro_blog_layout', 'default' );
$char_length = get_theme_mod( 'business_one_page_pro_post_no_of_char', 200 );
$read_more   = get_theme_mod( 'business_one_page_pro_post_read_more', __( 'Read More', 'business-one-page-pro' ) );
$img_size    = '';

if( is_home() ){ //img size for Four different blog layouts
    if( $blog_layout == 'default' || $blog_layout == 'full' ){
        $img_size = 'business-one-page-pro-cat-blog';
    }elseif( $blog_layout == 'square' || $blog_layout == 'circular' ){
        $img_size = 'business-one-page-pro-blog-small';
    }
}else{
    $img_size = 'business-one-page-pro-cat-blog';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    
    <?php 
    if( has_post_thumbnail() ){
        if( is_single() ){ 
            if( get_theme_mod( 'business_one_page_pro_ed_featured_image', '1' ) ){ ?>
            <div class="post-thumbnail">
                <?php business_one_page_pro_sidebar( true ) ? the_post_thumbnail( 'business-one-page-pro-with-sidebar', array( 'itemprop' => 'image' ) ) : the_post_thumbnail( 'business-one-page-pro-full', array( 'itemprop' => 'image' ) ) ; ?>
            </div>
        <?php }
        }else{ ?>
            <a href="<?php the_permalink(); ?>" class="post-thumbnail">
                <?php business_one_page_pro_sidebar( true ) ? the_post_thumbnail( $img_size, array( 'itemprop' => 'image' ) ) : the_post_thumbnail( 'business-one-page-pro-full', array( 'itemprop' => 'image' ) ) ;?>
            </a>
        <?php }
    } ?>
    
    <div class="text-holder">
        <header class="entry-header">
    		<?php
    		if ( 'post' === get_post_type() ) : ?>
    		<div class="entry-meta">
    			<?php business_one_page_pro_posted_on( true ); ?>
    		</div><!-- .entry-meta -->
    		<?php
    		endif; 
            
            if ( ! is_single() ) {
				the_title( '<h2 class="entry-title" itemprop="headline"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}
            ?>
    	</header><!-- .entry-header -->
    
    	<div class="entry-content" itemprop="text">
    		<?php
    		if( is_single() ){	
                the_content( sprintf(
    				/* translators: %s: Name of current post. */
    				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'business-one-page-pro' ), array( 'span' => array( 'class' => array() ) ) ),
    				the_title( '<span class="screen-reader-text">"', '"</span>', false )
    			) );
            }else{
                if( false === get_post_format() ){
                    if( has_excerpt() ){
                        the_excerpt();
                    }else{
                        echo wpautop( wp_kses_post( force_balance_tags( business_one_page_pro_excerpt( get_the_content(), $char_length, '...' ) ) ) );
                    }
                ?>
                <a href="<?php the_permalink(); ?>" class="btn-readmore"><?php echo esc_html( $read_more ); ?></a>
                <?php 
                }else{
                    the_content();                    
                }
            }
    			wp_link_pages( array(
    				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'business-one-page-pro' ),
    				'after'  => '</div>',
    			) );
    		?>
    	</div><!-- .entry-content -->
        
        <footer class="entry-footer">
    		<?php business_one_page_pro_entry_footer(); ?>
    	</footer><!-- .entry-footer -->
        
    </div><!-- .text-holder -->
    
</article><!-- #post-## -->
