<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Business_One_Page_Pro
 */

get_header(); ?>

    <div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php
		while ( have_posts() ) : the_post();
            
            //Add and Increase Post View Count
            business_one_page_pro_set_views( get_the_ID() );
                
			get_template_part( 'template-parts/content', get_post_format() );
                        
            business_one_page_pro_cat_tag(); // Categories and Tags
            
            if( get_theme_mod( 'business_one_page_pro_ed_bio', '1' ) ) business_one_page_pro_author_details(); // Author Bio
            
            $exclude_categories = !empty( get_theme_mod( 'business_one_page_pro_exclude_categories' ) ) ? get_theme_mod( 'business_one_page_pro_exclude_categories' ) : '';

			the_post_navigation( array( 'excluded_terms'=> $exclude_categories ) );
            
			// If comments are open or we have at least one comment, load up the comment template.
			if ( ( comments_open() || get_comments_number() ) && get_theme_mod( 'business_one_page_pro_ed_comments', '1' ) ) :
				comments_template();
			endif;
            
		endwhile; // End of the loop.
		?>

		</main><!-- #main -->
	</div><!-- #primary -->
            
<?php
get_sidebar(); 
get_footer();