<?php
/**
 * Template part for displaying Testimonial Section
 *
 * @package Business_One_Page_Pro
 */

$testimonial_page  = get_theme_mod( 'business_one_page_pro_testimonial_section_page' );
$testimonial_query = new WP_Query( array( 'post_type' => 'testimonial', 'posts_per_page' => -1, 'post_status' => 'publish' ) );

if( $testimonial_query->have_posts() || $testimonial_page ){
?>
<section id="testimonial">
    <div class="container">
    <?php
    if( $testimonial_page ){
        
        $testimonial_qry = new WP_Query( array( 'page_id' => $testimonial_page ) );
    
        if( $testimonial_qry->have_posts() ){
            while( $testimonial_qry->have_posts() ){
                $testimonial_qry->the_post();
            ?>
                <header class="heading">
                	<?php 
                        the_title( '<h2 class="section-title">', '</h2>' ); 
                        if( has_excerpt() ){ 
                            the_excerpt();
                        }else{
                            echo wpautop( wp_kses_post( force_balance_tags( business_one_page_pro_excerpt( get_the_content(), 200, '...' ) ) ) );
                        } 
                    ?>
                </header>
            <?php            
            }
        }
        wp_reset_postdata();
    }

    if( $testimonial_query->have_posts() ){
        echo '<div class="testimonial-slider"><div id="testimonialSlider" class="owl-carousel owl-theme">';
            while( $testimonial_query->have_posts() ){
                $testimonial_query->the_post();
                $designation = get_post_meta( get_the_ID(), '_business_one_page_pro_testimonial_designation', true );
                ?>
                <div>
					<?php if( has_post_thumbnail() ){ ?>
                    <div class="img-holder"><?php the_post_thumbnail( 'business-one-page-pro-testimonial', array( 'itemprop' => 'image' ) ); ?></div>
					<?php } ?>
                    <?php the_content(); ?>
					<strong class="name"><?php the_title(); ?></strong>
                    <?php if( $designation ) echo '<div class="testimonail-designation">' . esc_html( $designation ) . '</div>'; ?>
				</div>
                <?php
            }
        wp_reset_postdata();
        
        echo '</div></div>';
    }
    ?>
    </div>
</section>
<?php
}