<?php
/**
 * Template part for displaying Team Section
 *
 * @package Business_One_Page_Pro
 */

$team_page  = get_theme_mod( 'business_one_page_pro_team_section_page' );
$view_all   = get_theme_mod( 'business_one_page_pro_team_view_all', __( 'View All Teams', 'business-one-page-pro' ) );
$ed_tsocial = get_theme_mod( 'business_one_page_pro_ed_team_social' );

if( $team_page ){
?>
<section id="team" class="our-team">
    <div class="container">
    <?php        
        $team_qry = new WP_Query( array( 'page_id' => $team_page ) );
    
        if( $team_qry->have_posts() ){
            while( $team_qry->have_posts() ){
                $team_qry->the_post();
            ?>
                <header class="heading">
                	<?php 
                        the_title( '<h2 class="section-title">', '</h2>' ); 
                        if( has_excerpt() ){ 
                            the_excerpt();
                        }else{
                            echo wpautop( wp_kses_post( force_balance_tags( business_one_page_pro_excerpt( get_the_content(), 200, '...' ) ) ) );
                        } 
                    ?>
                </header>
            <?php            
            }
        }
        wp_reset_postdata();
    
        $team_query = new WP_Query( array( 'post_type' => 'team', 'posts_per_page' => -1, 'post_status' => 'publish' ) );
        if( $team_query->have_posts() ){ ?>
        
            <div class="team-holder">
                <div id="lightSlider" class="owl-carousel owl-theme">
                <?php 
                    while( $team_query->have_posts() ){
                        $team_query->the_post();
                        $designation = get_post_meta( get_the_ID(), '_business_one_page_pro_team_designation', true );
                        $facebook    = get_post_meta( get_the_ID(), '_business_one_page_pro_team_facebook', true );
                        $twitter     = get_post_meta( get_the_ID(), '_business_one_page_pro_team_twitter', true );
                        $dribble     = get_post_meta( get_the_ID(), '_business_one_page_pro_team_dribble', true );
                        $linkedin    = get_post_meta( get_the_ID(), '_business_one_page_pro_team_linkedin', true );
                        $pinterest   = get_post_meta( get_the_ID(), '_business_one_page_pro_team_pinterest', true );
                        if( has_post_thumbnail() ){
                        ?>
                        <div>
    						<div class="box">
    							<div class="img-holder"><?php the_post_thumbnail( 'business-one-page-pro-team', array( 'itemprop' => 'image' ) ); ?></div>
    							<strong class="name"><?php the_title(); ?></strong>
    							<em class="designation"><?php echo esc_html( $designation ); ?></em>
                                <?php if( $ed_tsocial && ( $facebook || $twitter || $dribble || $linkedin || $pinterest ) ){ ?>
                                <ul class="social-networks">
            						<?php if( $facebook ){?>
                                    <li><a href="<?php echo esc_url( $facebook ); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                    <?php } if( $twitter ){ ?>
            						<li><a href="<?php echo esc_url( $twitter ); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                    <?php } if( $dribble ){ ?>
            						<li><a href="<?php echo esc_url( $dribble );?>" target="_blank"><i class="fa fa-dribbble"></i></a></li>
                                    <?php } if( $linkedin ){ ?>
            						<li><a href="<?php echo esc_url( $linkedin ); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                    <?php } if( $pinterest ){ ?>
            						<li><a href="<?php echo esc_url( $pinterest ); ?>" target="_blank"><i class="fa fa-pinterest-p"></i></a></li>
                                    <?php } ?>
            					</ul>
                                <?php } ?>
    							<div class="hover-state">
    								<div class="table">
    									<div class="tabel-row">
    										<div class="tabel-cell">
                                                <div class="team-content">
                                                    <strong class="name"><?php the_title(); ?></strong>
        											<em class="designation"><?php echo esc_html( $designation ); ?></em>
        											<?php the_content(); ?>
                                                    <?php if( $ed_tsocial && ( $facebook || $twitter || $dribble || $linkedin || $pinterest ) ){ ?>
                                                    <ul class="social-networks">
                                						<?php if( $facebook ){?>
                                                        <li><a href="<?php echo esc_url( $facebook ); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                                        <?php } if( $twitter ){ ?>
                                						<li><a href="<?php echo esc_url( $twitter ); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                                        <?php } if( $dribble ){ ?>
                                						<li><a href="<?php echo esc_url( $dribble );?>" target="_blank"><i class="fa fa-dribbble"></i></a></li>
                                                        <?php } if( $linkedin ){ ?>
                                						<li><a href="<?php echo esc_url( $linkedin ); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                                        <?php } if( $pinterest ){ ?>
                                						<li><a href="<?php echo esc_url( $pinterest ); ?>" target="_blank"><i class="fa fa-pinterest-p"></i></a></li>
                                                        <?php } ?>
                                					</ul>
                                                    <?php } ?>
                                                </div>
    										</div>
    									</div>
    								</div>
    							</div>
    						</div>
                        </div>
                        <?php
                        }
                    }
                    wp_reset_postdata();
                ?>
                </div>
            </div>
        <?php   
        
        if( $view_all ) echo '<div class="btn-holder"><a href="' . esc_url( get_permalink( $team_page ) ) . '">' . esc_html( $view_all ) . '</a></div>';
         
        }
    ?>
    </div>
</section>
<?php
}