<?php
/**
 * Template part for displaying Service Section
 *
 * @package Business_One_Page_Pro
 */

$services_section_page = get_theme_mod( 'business_one_page_pro_services_section_page' );
 
if( $services_section_page || is_active_sidebar( 'service-section' ) ){
?>
<section id="services">
    <div class="container">
    <?php        
        $services_qry = new WP_Query( array( 'page_id' => $services_section_page ) );
    
        if( $services_qry->have_posts() ){
            while( $services_qry->have_posts() ){
                $services_qry->the_post();
            ?>
                <header class="heading">
                	<?php 
                        the_title( '<h2 class="section-title">', '</h2>' ); 
                        if( has_excerpt() ){ 
                            the_excerpt();
                        }else{
                            echo wpautop( wp_kses_post( force_balance_tags( business_one_page_pro_excerpt( get_the_content(), 200, '...' ) ) ) );
                        } 
                    ?>
                </header>
            <?php            
            }
        }
        wp_reset_postdata();
    
    
        if( is_active_sidebar( 'service-section' ) ){ ?>
        <div class="three-cols">
            <div class="row">
                <?php dynamic_sidebar( 'service-section' ); ?>
            </div>
        </div>
        <?php
        }
        ?>
    </div>
</section>
<?php    
}
?>