<?php
/**
 * Template part for displaying Our Core Value in About Page
 *
 * @package Business_One_Page_Pro
 */

$title   = get_theme_mod( 'business_one_page_pro_core_section_title' );
$content = get_theme_mod( 'business_one_page_pro_core_section_content' );

if( $title || $content || is_active_sidebar( 'about-second' ) ){
?>
<div id="about-core" class="our-values">
	<div class="container">
		<?php 
            if( $title ) echo '<h2 class="title">' . esc_html( $title ) . '</h2>';
            if( $content ) echo wpautop( wp_kses_post( $content ) ) ;
            
            if( is_active_sidebar( 'about-second' ) ) {
        ?>
        		<div class="row">
                    <?php dynamic_sidebar( 'about-second' ); ?>
        		</div>                
        <?php 
            } 
        ?>
	</div>
</div>
<?php
}