(function(window,document){'use strict';var features={bind:!!(function(){}.bind),classList:'classList' in document.documentElement,rAF:!!(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame)};window.requestAnimationFrame=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame;function Debouncer(callback){this.callback=callback;this.ticking=!1}
Debouncer.prototype={constructor:Debouncer,update:function(){this.callback&&this.callback();this.ticking=!1},requestTick:function(){if(!this.ticking){requestAnimationFrame(this.rafCallback||(this.rafCallback=this.update.bind(this)));this.ticking=!0}},handleEvent:function(){this.requestTick()}};function isDOMElement(obj){return obj&&typeof window!=='undefined'&&(obj===window||obj.nodeType)}
function extend(object){if(arguments.length<=0){throw new Error('Missing arguments in extend function')}
var result=object||{},key,i;for(i=1;i<arguments.length;i++){var replacement=arguments[i]||{};for(key in replacement){if(typeof result[key]==='object'&&!isDOMElement(result[key])){result[key]=extend(result[key],replacement[key])}
else{result[key]=result[key]||replacement[key]}}}
return result}
function normalizeTolerance(t){return t===Object(t)?t:{down:t,up:t}}
function Headroom(elem,options){options=extend(options,Headroom.options);this.lastKnownScrollY=0;this.elem=elem;this.debouncer=new Debouncer(this.update.bind(this));this.tolerance=normalizeTolerance(options.tolerance);this.classes=options.classes;this.offset=options.offset;this.scroller=options.scroller;this.initialised=!1;this.onPin=options.onPin;this.onUnpin=options.onUnpin;this.onTop=options.onTop;this.onNotTop=options.onNotTop}
Headroom.prototype={constructor:Headroom,init:function(){if(!Headroom.cutsTheMustard){return}
this.elem.classList.add(this.classes.initial);setTimeout(this.attachEvent.bind(this),100);return this},destroy:function(){var classes=this.classes;this.initialised=!1;this.elem.classList.remove(classes.unpinned,classes.pinned,classes.top,classes.initial);this.scroller.removeEventListener('scroll',this.debouncer,!1)},attachEvent:function(){if(!this.initialised){this.lastKnownScrollY=this.getScrollY();this.initialised=!0;this.scroller.addEventListener('scroll',this.debouncer,!1);this.debouncer.handleEvent()}},unpin:function(){var classList=this.elem.classList,classes=this.classes;if(classList.contains(classes.pinned)||!classList.contains(classes.unpinned)){classList.add(classes.unpinned);classList.remove(classes.pinned);this.onUnpin&&this.onUnpin.call(this)}},pin:function(){var classList=this.elem.classList,classes=this.classes;if(classList.contains(classes.unpinned)){classList.remove(classes.unpinned);classList.add(classes.pinned);this.onPin&&this.onPin.call(this)}},top:function(){var classList=this.elem.classList,classes=this.classes;if(!classList.contains(classes.top)){classList.add(classes.top);classList.remove(classes.notTop);this.onTop&&this.onTop.call(this)}},notTop:function(){var classList=this.elem.classList,classes=this.classes;if(!classList.contains(classes.notTop)){classList.add(classes.notTop);classList.remove(classes.top);this.onNotTop&&this.onNotTop.call(this)}},getScrollY:function(){return(this.scroller.pageYOffset!==undefined)?this.scroller.pageYOffset:(this.scroller.scrollTop!==undefined)?this.scroller.scrollTop:(document.documentElement||document.body.parentNode||document.body).scrollTop},getViewportHeight:function(){return window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight},getDocumentHeight:function(){var body=document.body,documentElement=document.documentElement;return Math.max(body.scrollHeight,documentElement.scrollHeight,body.offsetHeight,documentElement.offsetHeight,body.clientHeight,documentElement.clientHeight)},getElementHeight:function(elm){return Math.max(elm.scrollHeight,elm.offsetHeight,elm.clientHeight)},getScrollerHeight:function(){return(this.scroller===window||this.scroller===document.body)?this.getDocumentHeight():this.getElementHeight(this.scroller)},isOutOfBounds:function(currentScrollY){var pastTop=currentScrollY<0,pastBottom=currentScrollY+this.getViewportHeight()>this.getScrollerHeight();return pastTop||pastBottom},toleranceExceeded:function(currentScrollY,direction){return Math.abs(currentScrollY-this.lastKnownScrollY)>=this.tolerance[direction]},shouldUnpin:function(currentScrollY,toleranceExceeded){var scrollingDown=currentScrollY>this.lastKnownScrollY,pastOffset=currentScrollY>=this.offset;return scrollingDown&&pastOffset&&toleranceExceeded},shouldPin:function(currentScrollY,toleranceExceeded){var scrollingUp=currentScrollY<this.lastKnownScrollY,pastOffset=currentScrollY<=this.offset;return(scrollingUp&&toleranceExceeded)||pastOffset},update:function(){var currentScrollY=this.getScrollY(),scrollDirection=currentScrollY>this.lastKnownScrollY?'down':'up',toleranceExceeded=this.toleranceExceeded(currentScrollY,scrollDirection);if(this.isOutOfBounds(currentScrollY)){return}
if(currentScrollY<=this.offset){this.top()}else{this.notTop()}
if(this.shouldUnpin(currentScrollY,toleranceExceeded)){this.unpin()}
else if(this.shouldPin(currentScrollY,toleranceExceeded)){this.pin()}
this.lastKnownScrollY=currentScrollY}};Headroom.options={tolerance:{up:0,down:0},offset:0,scroller:window,classes:{pinned:'headroom--pinned',unpinned:'headroom--unpinned',top:'headroom--top',notTop:'headroom--not-top',initial:'headroom'}};Headroom.cutsTheMustard=typeof features!=='undefined'&&features.rAF&&features.bind&&features.classList;window.Headroom=Headroom}(window,document))