/*! .isOnScreen() returns bool */
jQuery.fn.isOnScreen = function(){
    
    var win = jQuery(window);

    /** Dynamic header height calculation for responsive devices */
    var header_height = jQuery('#masthead').height();
    jQuery('.banner').css( 'margin-top', header_height );
    jQuery('.inner-page').css( 'margin-top', header_height );
    
    var viewport = {
        top : win.scrollTop(),
        left : win.scrollLeft()
    };
    viewport.right = viewport.left + win.width();
    viewport.bottom = viewport.top + win.height();
    
    var bounds = this.offset();
    bounds.right = bounds.left + this.outerWidth();
    bounds.bottom = bounds.top + this.outerHeight();
    
    return (!(viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom));
    
};

jQuery(document).ready(function($) {
    var slider_auto, slider_loop, slider_control, rtl, mrtl, slider_animation, tslider_auto, cslider_auto, teslider_auto, pause_on_hover;
    /** Variables from Customizer for Slider settings */
    if( business_one_page_pro_data.auto == '1' ){
        slider_auto = true;
    }else{
        slider_auto = false;
    }
    
    if( business_one_page_pro_data.loop == '1' ){
        slider_loop = true;
    }else{
        slider_loop = false;
    }
    
    if( business_one_page_pro_data.pager == '1' ){
        slider_control = true;
    }else{
        slider_control = false;
    }
    
    if( business_one_page_pro_data.rtl == '1' ){
        rtl = true;
        mrtl = false;
    }else{
        rtl = false;
        mrtl = true;
    }

    if( business_one_page_pro_data.mode == 'slide' ){
        slider_animation = '';
    }else if( business_one_page_pro_data.mode == 'fade' ){
        slider_animation = 'fadeOut';
    }else{
        slider_animation = business_one_page_pro_data.mode;
    }
    
    if( business_one_page_pro_data.tauto == '1' ){
        tslider_auto = true;
    }else{
        tslider_auto = false;
    }
    if( business_one_page_pro_data.tloop == '1' ){
        tslider_loop = true;
    }else{
        tslider_loop = false;
    }
    
    if( business_one_page_pro_data.cauto == '1' ){
        cslider_auto = true;
    }else{
        cslider_auto = false;
    }
    
    if( business_one_page_pro_data.teauto == '1' ){
        teslider_auto = true;
    }else{
        teslider_auto = false;
    }

    if( business_one_page_pro_data.pauseonhover == '1' ){
        pause_on_hover = true;
    }else{
        pause_on_hover = false;
    }
    
    /** Home Page Slider */
    $("#banner-slider").owlCarousel({
        items           : 1,
        margin          : 0,
        loop            : slider_loop,
        autoplay        : slider_auto,
        dots            : slider_control,
        nav             : false,
        animateOut      : slider_animation,
        autoplayTimeout : business_one_page_pro_data.pause,
        lazyLoad        : true,
        mouseDrag       : false,
        rtl             : rtl,
        autoplaySpeed   : business_one_page_pro_data.speed,
    });
    
    $("#testimonialSlider").owlCarousel({
        items           : 1,
        margin          : 0,
        loop            : true,
        autoplay        : teslider_auto,
        dots            : true,
        nav             : false,
        autoplayTimeout : business_one_page_pro_data.tepause,
        lazyLoad        : true,
        mouseDrag       : false,
        rtl             : rtl,
        autoplaySpeed   : 500,
        autoplayHoverPause   : pause_on_hover,
    });

    $("#lightSlider").owlCarousel({
        items           : 3,
        margin          : 30,
        loop            : tslider_loop,
        autoplay        : tslider_auto,
        dots            : false,
        nav             : true,
        autoplaySpeed   : 500,
        autoplayTimeout : 4000,
        lazyLoad        : true,
        mouseDrag       : false,
        rtl             : rtl,
        responsive : {
            // breakpoint from 0 up
            0 : {
                items : 1,
            },
            // breakpoint from 480 up
            640 : {
                items : 2,
            },

            768 : {
                items : 3,
            }
        }
    });

    $('.language-dropdown ul li.pll-parent-menu-item > a').click(function(e){
        e.preventDefault();
        $(this).siblings('.sub-menu').slideToggle();
    });
    

    /** Lightbox */
    if( business_one_page_pro_data.lightbox == '1' ){
        
        $("a[href$='.jpg'],a[href$='.jpeg'],a[href$='.png'],a[href$='.gif'],[data-fancybox]").fancybox({
            buttons: [
               "zoom",
               //"share",
               "slideShow",
               "fullScreen",
               //"download",
               // "thumbs",
               "close"
            ]
        });
        
    }
    
    // Script for back to top
    $(window).scroll(function(){
        if($(this).scrollTop() > 300){
          $('#rara-top').fadeIn();
        }else{
          $('#rara-top').fadeOut();
        }
    });
    
    $("#rara-top").click(function(){
        $('html,body').animate({scrollTop:0},600);
    });
    
    /* Sticky Header */
    // grab an element
    var myElement = document.querySelector("header");
    // construct an instance of Headroom, passing the element
    var headroom  = new Headroom(myElement);
    // initialise
    headroom.init();
    
    
    if( business_one_page_pro_data.one_page != '1' ){
        $('#site-navigation, .mobile-main-navigation').onePageNav({
            currentClass: 'current-menu-item',
            changeHash: false,
            scrollSpeed: 1500,
            scrollThreshold: 0.5,
            filter: '',
            easing: 'swing',        
        });
    }
     
    
    /** Client Slider*/
    $("#client-slider").owlCarousel({
        items           : 5,
        margin          : 0,
        loop            : true,
        autoplay        : cslider_auto,
        dots            : false,
        nav             : true,
        autoplaySpeed   : 500,
        autoplayTimeout : 4000,
        lazyLoad        : true,
        mouseDrag       : false,
        rtl             : rtl,
        responsive : {
            // breakpoint from 0 up
            0 : {
                items : 2,
            },
            // breakpoint from 480 up
            640 : {
                items : 4,
            },

            768 : {
                items : 5,
            }
        }
    });

    
    /** Video Iframe Used in Service Page Template */
    // Find all YouTube videos
    var $allVideos = $("iframe[src^='//player.vimeo.com'], iframe[src^='//www.youtube.com']"), //$("iframe[src^='//www.youtube.com']"),

    // The element that is fluid width
    $fluidEl = $("body");

    // Figure out and save aspect ratio for each video
    $allVideos.each(function() {

      $(this).data('aspectRatio', this.height / this.width)

        // and remove the hard coded width/height
        .removeAttr('height')
        .removeAttr('width');

      });

    // When the window is resized
    $(window).resize(function() {

        var newWidth = $fluidEl.width();

        // Resize all videos according to their own aspect ratio
        $allVideos.each(function() {        
            var $el = $(this);
            $el
            .width(newWidth)
            .height(newWidth * $el.data('aspectRatio'));        
        });

    // Kick off one resize to fix all videos on page load
    }).resize();
    
    /* Counter for Stat Counter Widget */
    if( $('.widget_business_one_page_pro_stat_counter_widget').length > 0 ){
        $('.number').counterUp({
            delay: 10,
            time: 1000
        });
    }
    
    /* Fits embed video according to container */
    $("#content").fitVids();
    
    /****SHORTCODE***/
    $('.shortcode-slider .slides').owlCarousel({
        items: 1,
        margin: 0,
        dots: false,
        nav: true,
        autoplay: true,
    });    
    
    $('.rara_accordian .rara_accordian_content').hide(); /**Need to be CSS*/
    $('.rara_accordian:first').children('.rara_accordian_content').show();
    $('.rara_accordian:first').children('.rara_accordian_title').addClass('active');
    $('.rara_accordian_title').click(function(){
    if($(this).hasClass('active')){
    }
    else{
      $(this).parent('.rara_accordian').siblings().find('.rara_accordian_content').slideUp();
      $(this).next('.rara_accordian_content').slideToggle();
      $(this).parent('.rara_accordian').siblings().find('.rara_accordian_title').removeClass('active');
      $(this).toggleClass('active');
    }
    });
    
    $('.rara_toggle.close .rara_toggle_content').hide(); /**Need to be CSS*/
    $('.rara_toggle.open .rara_toggle_title').addClass('active');
    $('.rara_toggle_title').click(function(){
      $(this).next('.rara_toggle_content').slideToggle();
      $(this).toggleClass('active');
    });
    
    $('.rara_tab').hide();/**Need to be CSS*/
    $('.rara_tab_wrap').prepend('<div class="rara_tab_group clearfix"></div>');

    $('.rara_tab_wrap').each(function(){
        $(this).children('.rara_tab').find('.tab-title').prependTo($(this).find('.rara_tab_group'));
        $(this).children('.rara_tab').wrapAll( "<div class='rara_tab_content clearfix' />");
    });

    $('#page').each(function(){
        $(this).find('.rara_tab:first-child').show();
        $(this).find('.tab-title:first-child').addClass('active');
    });
 
    $('.rara_tab_group .tab-title').click(function(){
        $(this).siblings().removeClass('active');
        $(this).addClass('active');
        $(this).parent('.rara_tab_group ').next('.rara_tab_content').find('.rara_tab').hide();
        var ap_id = $(this).attr('id');
        $(this).parent('.rara_tab_group ').next('.rara_tab_content').find('.'+ap_id).show();
    });    
    /****SHORTCODE***/ 
    
    

    /* Equal Height */
     $('.widget_business_one_page_pro_icon_text_widget').matchHeight({
        byRow: true,
        property: 'height',
        target: null,
        remove: false
    });   
    
    /* Custom Scroll Bar */
    $(".our-team .team-holder .box .hover-state .tabel-cell .team-content").mCustomScrollbar({
     theme:"minimal"
    });

    /** Home Page Portfolio Section Masonry */
    if( $('.page-template-template-home').length > 0 ){        
        $('.js-masonry').imagesLoaded(function(){ 
            $('.js-masonry').masonry({
                itemSelector: '.portfolio-col',
                isOriginLeft: mrtl
            }); 
        });
    }
    
    /** Testimonial Page Template Masonry */
    if( $('.page-template-template-testimonial').length > 0 ){        
        $('.js-masonry').imagesLoaded(function(){ 
            $('.js-masonry').masonry({
                itemSelector: '.testimonial-wrap',
                isOriginLeft: mrtl
            }); 
        });
    }
    
    /** Team Page Template Masonry */
    if( $('.page-template-template-team').length > 0 ){        
        $('.js-masonry').imagesLoaded(function(){ 
            $('.js-masonry').masonry({
                itemSelector: '.col',
                isOriginLeft: mrtl
            }); 
        });
    }
    
    /* Portfolio Isotope Filter */
    if( $('.page-template-template-portfolio').length > 0 ){
        // init Isotope
        var $grid = $('.portfolio-grid').imagesLoaded( function(){  
        
            $grid.isotope({
              // options
            });
            
            // filter items on button click
            $('.filter-button-group').on( 'click', 'button', function() {
              $('.filter-button-group button').removeClass('is-active');
              $(this).addClass('is-active');
              var filterValue = $(this).attr('data-filter');
              $grid.isotope({ filter: filterValue });
            });
        
        });
    }

    var headerHeight = $('.site-header').outerHeight();
    $('.banner').css('margin-top', headerHeight);
    $('.inner-page').css('margin-top', headerHeight);

    //mobile-menu
    $('.btn-menu-opener').click(function(){
        $('body').addClass('menu-open');

        $('.btn-close-menu').click(function(){
            $('body').removeClass('menu-open');
        });

        $('.mobile-main-navigation ul li a').click(function(){
            $('body').removeClass('menu-open');
        });

    });

    $('.overlay').click(function(){
        $('body').removeClass('menu-open');
    });

    $('.mobile-menu').prepend('<div class="btn-close-menu"></div<');

    $('.mobile-main-navigation ul .menu-item-has-children').append('<div class="angle-down"></div>');

    $('.secondary-mobile-menu ul .menu-item-has-children').append('<div class="angle-down"></div>');

    $('.mobile-main-navigation ul li .angle-down').click(function(){
        $(this).prev().slideToggle();
        $(this).toggleClass('active');
    });

    $('.secondary-mobile-menu ul li .angle-down').click(function(){
        $(this).prev().slideToggle();
        $(this).toggleClass('active');
    });
    
});
