<?php
/**
 * Stat Counter Widget
 *
 * @package Business_One_Page_Pro
 */

// register Business_One_Page_Pro_Stat_Counter_Widget widget
function business_one_page_pro_register_stat_counter_widget(){
    register_widget( 'Business_One_Page_Pro_Stat_Counter_Widget' );
}
add_action('widgets_init', 'business_one_page_pro_register_stat_counter_widget');
 
 /**
 * Adds Business_One_Page_Pro_Stat_Counter_Widget widget.
 */
class Business_One_Page_Pro_Stat_Counter_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
            'business_one_page_pro_stat_counter_widget', // Base ID
            __( 'RARA: Stat Counter Widget', 'business-one-page-pro' ), // Name
            array( 'description' => __( 'Widget for stat counter.', 'business-one-page-pro' ), ) // Args
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : '' ;        
        $counter = ! empty( $instance['counter'] ) ? absint( $instance['counter'] ) : '';
        $icon    = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
        $image   = ! empty( $instance['image'] ) ? absint( $instance['image'] ) : '';
        
        if( $image ){
            $fimg_url = wp_get_attachment_image_url( $image, 'full');
        }
        
        echo $args['before_widget']; ?>
        
            <div class="col">
                
                <?php if( $image ){ ?>
                    <div class="icon-holder">
                        <img src="<?php echo esc_url( $fimg_url ); ?>" alt="<?php echo esc_attr( $title ); ?>" />
                    </div>
                <?php }elseif( $icon ){ ?>
                    <div class="icon-holder">
                        <span class="fa <?php echo esc_attr( $icon ); ?>"></span>
                    </div>
                <?php }?>
                
                <div class="text-holder">
                    <?php 
                        if( $counter ) echo '<strong class="number">' . absint( $counter ) . '</strong>';
                         
                        if( $title ) echo $args['before_title'] . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $args['after_title']; 
                    ?>                    
                </div>
                
            </div>        
        
        <?php
        echo $args['after_widget'];
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : '' ;        
        $counter = ! empty( $instance['counter'] ) ? absint( $instance['counter'] ) : '';
        $icon    = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
        $image   = ! empty( $instance['image'] ) ? absint( $instance['image'] ) : '';
        
        ?>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title', 'business-one-page-pro' ); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />            
        </p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'counter' ) ); ?>"><?php esc_html_e( 'Counter', 'business-one-page-pro' ); ?></label>
            <input name="<?php echo esc_attr( $this->get_field_name( 'counter' ) ); ?>" type="number" step="1" min="1" id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>" value="<?php echo absint( $counter ); ?>" class="small-text" />         
        </p>
        
        <?php business_one_page_pro_get_image_field( $this->get_field_id( 'image' ), $this->get_field_name( 'image' ), $image, __( 'Upload Image', 'business-one-page-pro' ) ); ?>
        
        <p><strong><?php esc_html_e( 'or', 'business-one-page-pro' ); ?></strong></p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'icon' ); ?>"><?php esc_html_e( 'Icons', 'business-one-page-pro' ); ?></label><br />
            <span class="icon-receiver"><i class="<?php echo esc_attr( $icon ); ?>"></i></span>
            <input class="hidden-icon-input" name="<?php echo $this->get_field_name( 'icon' ); ?>" type="hidden" id="<?php echo $this->get_field_id( 'icon' ); ?>" value="<?php echo esc_html( $icon ); ?>" />            
        </p>
        
        <?php business_one_page_pro_get_icon_list(); ?>
                        
        <?php
    }
    
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        
        $instance['title']   = ! empty( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '' ;
        $instance['counter'] = ! empty( $new_instance['counter'] ) ? absint( $new_instance['counter'] ) : '';
        $instance['image']   = ! empty( $new_instance['image'] ) ? absint( $new_instance['image'] ) : '';
        $instance['icon']    = ! empty( $new_instance['icon'] ) ? $new_instance['icon'] : '';
        
        return $instance;
    }
    
}  // class Business_One_Page_Pro_Stat_Counter_Widget 