<?php
/**
 * Icon Text Widget
 *
 * @package Business_One_Page_Pro
 */

// register Business_One_Page_Pro_Icon_Text_Widget widget
function business_one_page_pro_register_icon_text_widget(){
    register_widget( 'Business_One_Page_Pro_Icon_Text_Widget' );
}
add_action('widgets_init', 'business_one_page_pro_register_icon_text_widget');
 
 /**
 * Adds Business_One_Page_Pro_Icon_Text_Widget widget.
 */
class Business_One_Page_Pro_Icon_Text_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
			'business_one_page_pro_icon_text_widget', // Base ID
			__( 'RARA: Icon Text Widget', 'business-one-page-pro' ), // Name
			array( 'description' => __( 'An Icon Text Widget.', 'business-one-page-pro' ), ) // Args
		);
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : '' ;		
        $content = ! empty( $instance['content'] ) ? $instance['content'] : '';
        $icon    = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
        $image   = ! empty( $instance['image'] ) ? absint( $instance['image'] ) : '';
        $style   = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';
        $url     = ! empty( $instance['url'] ) ? esc_url_raw( $instance['url'] ) : '';
        $new_tab = ! empty( $instance['new_tab'] ) ? $instance['new_tab'] : '' ; 

        if( $image ){
            $attachment_id = $image;
        }
        
        if( $new_tab ){
            $target = ' target="_blank"';
        }else{
            $target = '';
        }
        
        echo $args['before_widget']; ?>
        
        
            <div class="col <?php echo esc_attr( $style ); ?>">
				<?php if( $style == 'style3' ){?>
                <div class="table">
					<div class="table-row">
						<div class="table-cell">
				<?php } ?>
                            <?php if( $image ){ ?>
                                <div class="icon-holder">
                                    <?php echo wp_get_attachment_image( $attachment_id, 'full', false, 
                                                array( 'alt' => esc_html( $title ))); ?>
                                </div>
                            <?php }elseif( $icon ){ ?>
                                <div class="icon-holder">
                                    <span>
                                        <i class="<?php echo esc_attr( $icon ); ?>"></i>
                                    </span>
                                </div>
                            <?php }?>
                
                            <div class="text-holder">
                            <?php 
                                if( $title ) {
                                    echo $args['before_title']; 
                                    if( $url ) echo '<a href="' . esc_url( $url ) . '"' . $target . '>';
                                    echo apply_filters( 'widget_title', $title, $instance, $this->id_base );
                                    if( $url ) echo '</a>';
                                    echo $args['after_title'];    
                                }
                                
                                if( $content ) echo wpautop( wp_kses_post( $content ) );
                            ?>								
							</div>
                            
                <?php if( $style == 'style3' ){?>    
						</div>
					</div>
				</div>
                <?php } ?>
			</div>
        <?php    
            
            
        
        echo $args['after_widget'];
    }

    /**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        
        $title   = ! empty( $instance['title'] ) ? $instance['title'] : '' ;		
        $content = ! empty( $instance['content'] ) ? $instance['content'] : '';
        $icon    = ! empty( $instance['icon'] ) ? $instance['icon'] : '';
        $image   = ! empty( $instance['image'] ) ? absint( $instance['image'] ) : '';
        $style   = ! empty( $instance['style'] ) ? $instance['style'] : 'style1';
        $url     = ! empty( $instance['url'] ) ? esc_url_raw( $instance['url'] ) : '';
        $new_tab = ! empty( $instance['new_tab'] ) ? $instance['new_tab'] : '' ; 
        
        ?>
		
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title', 'business-one-page-pro' ); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />            
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php esc_html_e( 'Content', 'business-one-page-pro' ); ?></label>
            <textarea name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"><?php print $content; ?></textarea>
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'url' ); ?>"><?php esc_html_e( 'Link', 'business-one-page-pro' ); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id( 'url' ); ?>" name="<?php echo $this->get_field_name( 'url' ); ?>" type="text" value="<?php echo esc_attr( $url ); ?>" />            
		</p>
        
        <p>
            <input id="<?php echo $this->get_field_id( 'new_tab' ); ?>" name="<?php echo $this->get_field_name( 'new_tab' ); ?>" type="checkbox" value="1" <?php checked( '1', $new_tab ); ?>/>
            <label for="<?php echo $this->get_field_id( 'new_tab' ); ?>"><?php esc_html_e( 'Open in new tab', 'business-one-page-pro' ); ?></label>
		</p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>"><?php esc_html_e( 'Select Style', 'business-one-page-pro' ); ?></label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'style' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'style' ) ); ?>" class="widefat">
				<option value="style1" <?php selected( 'style1', $style ) ?>><?php esc_html_e( 'Style 1', 'business-one-page-pro' ); ?></option>
				<option value="style2" <?php selected( 'style2', $style ) ?>><?php esc_html_e( 'Style 2', 'business-one-page-pro' ); ?></option>
				<option value="style3" <?php selected( 'style3', $style ) ?>><?php esc_html_e( 'Style 3', 'business-one-page-pro' ); ?></option>
				<option value="style4" <?php selected( 'style4', $style ) ?>><?php esc_html_e( 'Style 4', 'business-one-page-pro' ); ?></option>
			</select>
		</p>
        
        <?php business_one_page_pro_get_image_field( $this->get_field_id( 'image' ), $this->get_field_name( 'image' ), $image, __( 'Upload Image', 'business-one-page-pro' ) ); ?>
        
        <p><strong><?php esc_html_e( 'or', 'business-one-page-pro' ); ?></strong></p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'icon' ); ?>"><?php esc_html_e( 'Icons', 'business-one-page-pro' ); ?></label><br />
            <?php 
                $class = "";
                if( isset($icon) && $icon!='' )
                {
                    $class = "yes";
                }
            ?>
            <span class="icon-receiver <?php echo $class;?>"><i class="<?php echo esc_attr( $icon ); ?>"></i></span>
            <input class="hidden-icon-input" name="<?php echo $this->get_field_name( 'icon' ); ?>" type="hidden" id="<?php echo $this->get_field_id( 'icon' ); ?>" value="<?php echo esc_attr( $icon ); ?>" />            
        </p>
        
        <?php business_one_page_pro_get_icon_list(); ?>
                        
        <?php
	}
    
    /**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		
        $instance['title']   = ! empty( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '' ;
        $instance['content'] = ! empty( $new_instance['content'] ) ? $new_instance['content'] : '';
        $instance['style']   = ! empty( $new_instance['style'] ) ? $new_instance['style'] : 'style1';        
        $instance['image']   = ! empty( $new_instance['image'] ) ? absint( $new_instance['image'] ) : '';
        $instance['icon']    = ! empty( $new_instance['icon'] ) ? $new_instance['icon'] : '';
        $instance['url']     = ! empty( $new_instance['url'] ) ? esc_url_raw( $new_instance['url'] ) : '';
        $instance['new_tab'] = ! empty( $new_instance['new_tab'] ) ? $new_instance['new_tab'] : '' ; 
        
        return $instance;
	}
    
}  // class Business_One_Page_Pro_Icon_Text_Widget 