<?php
/**
 * Typography Related Functions
 *
 * @package Business_One_Page_Pro
 */
 
/**
 * Function return google fonts url
 * 
 * @link http://themeshaper.com/2014/08/13/how-to-add-google-fonts-to-wordpress-themes/
*/
function business_one_page_pro_fonts_url() {
    $fonts_url = '';
    
    $body_font    = get_theme_mod( 'business_one_page_pro_body_font', array('font-family'=>'Source Sans Pro', 'variant'=>'regular') );
    $ig_body_font = business_one_page_pro_is_google_font( $body_font['font-family'] );
    
    //Setting for the Section Title of Home Page Section
    $home_section_font    = get_theme_mod( 'business_one_page_pro_hps_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $ig_home_section_font = business_one_page_pro_is_google_font( $home_section_font['font-family'] );
    
    //Setting for Portfolio Title of Portfolio Section of Home Page
    $home_p_title_font    = get_theme_mod( 'business_one_page_pro_hps_portfolio_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $ig_home_p_title_font = business_one_page_pro_is_google_font( $home_p_title_font['font-family'] );
    
    //Setting for Team Title of Team Section of Home Page
    $home_t_title_font    = get_theme_mod( 'business_one_page_pro_hps_team_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_home_t_title_font = business_one_page_pro_is_google_font( $home_t_title_font['font-family'] );
    
    //Setting for Blog Title of Blog Section of Home Page
    $blog_title_font    = get_theme_mod( 'business_one_page_pro_blog_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_blog_title_font = business_one_page_pro_is_google_font( $blog_title_font['font-family'] );
    
    //Setting for Page title above breadcrumb
    $page_title_font    = get_theme_mod( 'business_one_page_pro_page_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_page_title_font = business_one_page_pro_is_google_font( $page_title_font['font-family'] );
    
    //Setting for Post Title in Blog/Archive Page.
    $post_title_font    = get_theme_mod( 'business_one_page_pro_post_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $ig_post_title_font = business_one_page_pro_is_google_font( $post_title_font['font-family'] );
    
    //Setting for Contact Title of Contact Section and Contact Page Template
    $contact_title_font    = get_theme_mod( 'business_one_page_pro_contact_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_contact_title_font = business_one_page_pro_is_google_font( $contact_title_font['font-family'] );
    
    //Setting for Testimonial Title of Testimonial Page Template
    $testimonial_title_font    = get_theme_mod( 'business_one_page_pro_testimonial_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_testimonial_title_font = business_one_page_pro_is_google_font( $testimonial_title_font['font-family'] );
    
    //Setting for Team Title of Team Page Template
    $team_title_font    = get_theme_mod( 'business_one_page_pro_team_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_team_title_font = business_one_page_pro_is_google_font( $team_title_font['font-family'] );
    
    //Setting for Portfolio Title of Portfolio Page Template
    $portfolio_title_font    = get_theme_mod( 'business_one_page_pro_portfolio_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_portfolio_title_font = business_one_page_pro_is_google_font( $portfolio_title_font['font-family'] );
    
    //Setting for Our Mission Title & Our Core Value Title of About Page Template
    $mcv_title_font    = get_theme_mod( 'business_one_page_pro_mcv_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $ig_mcv_title_font = business_one_page_pro_is_google_font( $mcv_title_font['font-family'] );
    
    //Setting for Our Client Title of Home page & About page Template
    $client_title_font    = get_theme_mod( 'business_one_page_pro_client_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $ig_client_title_font = business_one_page_pro_is_google_font( $client_title_font['font-family'] );
    
    $service_st_font    = get_theme_mod( 'business_one_page_pro_s_section_title_font', array('font-family'=>'Oxygen', 'variant'=>'regular') );
    $ig_service_st_font = business_one_page_pro_is_google_font( $service_st_font['font-family'] );
    
    $h1_font         = get_theme_mod( 'business_one_page_pro_h1_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_h1_font      = business_one_page_pro_is_google_font( $h1_font['font-family'] );
    $h2_font         = get_theme_mod( 'business_one_page_pro_h2_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_h2_font      = business_one_page_pro_is_google_font( $h2_font['font-family'] );
    $h3_font         = get_theme_mod( 'business_one_page_pro_h3_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_h3_font      = business_one_page_pro_is_google_font( $h3_font['font-family'] );
    $h4_font         = get_theme_mod( 'business_one_page_pro_h4_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_h4_font      = business_one_page_pro_is_google_font( $h4_font['font-family'] );
    $h5_font         = get_theme_mod( 'business_one_page_pro_h5_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_h5_font      = business_one_page_pro_is_google_font( $h5_font['font-family'] );
    $h6_font         = get_theme_mod( 'business_one_page_pro_h6_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_h6_font      = business_one_page_pro_is_google_font( $h6_font['font-family'] );
    
    $wg_title_font   = get_theme_mod( 'business_one_page_pro_widget_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_wgtitle_font = business_one_page_pro_is_google_font( $wg_title_font['font-family'] );
    
    $wg_p_title_font = get_theme_mod( 'business_one_page_pro_widget_post_title_font', array('font-family'=>'Oxygen', 'variant'=>'700') );
    $ig_wptitle_font = business_one_page_pro_is_google_font( $wg_p_title_font['font-family'] );
    
    $subsets = array();
    $body_subsets              = ( ! empty( $body_font['subset'] ) && $ig_body_font ) ? $body_font['subset'] : array();
    $home_section_subsets      = ( ! empty( $home_section_font['subset'] ) && $ig_home_section_font ) ? $home_section_font['subset'] : array();
    $home_p_title_subsets      = ( ! empty( $home_p_title_font['subset'] ) && $ig_home_p_title_font ) ? $home_p_title_font['subset'] : array();
    $home_t_title_subsets      = ( ! empty( $home_t_title_font['subset'] ) && $ig_home_t_title_font ) ? $home_t_title_font['subset'] : array();
    $blog_title_subsets        = ( ! empty( $blog_title_font['subset'] ) && $ig_blog_title_font ) ? $blog_title_font['subset'] : array();
    $page_title_subsets        = ( ! empty( $page_title_font['subset'] ) && $ig_page_title_font ) ? $page_title_font['subset'] : array();    
    $post_title_subsets        = ( ! empty ( $post_title_font['subset'] ) && $ig_post_title_font ) ? $post_title_font['subset'] : array();    
    $contact_title_subsets     = ( ! empty ( $contact_title_font['subset'] ) && $ig_contact_title_font ) ? $contact_title_font['subset'] : array();
    $testimonail_title_subsets = ( ! empty ( $testimonial_title_font['subset'] ) && $ig_testimonial_title_font ) ? $testimonial_title_font['subset'] : array();
    $team_title_subsets        = ( ! empty ( $team_title_font['subset'] ) && $ig_team_title_font ) ? $team_title_font['subset'] : array();
    $portfolio_title_subsets   = ( ! empty ( $portfolio_title_font['subset'] ) && $ig_portfolio_title_font ) ? $portfolio_title_font['subset'] : array();
    $mcv_title_subsets         = ( ! empty ( $mcv_title_font['subset'] ) && $ig_mcv_title_font ) ? $mcv_title_font['subset'] : array();
    $client_title_subsets      = ( ! empty ( $client_title_font['subset'] ) && $ig_client_title_font ) ? $client_title_font['subset'] : array();
    $service_st_subsets        = ( ! empty ( $service_st_font['subset'] ) && $ig_service_st_font ) ? $service_st_font['subset'] : array();
    
    $h1_subsets         = ( ! empty( $h1_font['subset'] ) && $ig_h1_font ) ? $h1_font['subset'] : array();
    $h2_subsets         = ( ! empty( $h2_font['subset'] ) && $ig_h2_font ) ? $h2_font['subset'] : array();
    $h3_subsets         = ( ! empty( $h3_font['subset'] ) && $ig_h3_font ) ? $h3_font['subset'] : array();
    $h4_subsets         = ( ! empty( $h4_font['subset'] ) && $ig_h4_font ) ? $h4_font['subset'] : array();
    $h5_subsets         = ( ! empty( $h5_font['subset'] ) && $ig_h5_font ) ? $h5_font['subset'] : array();
    $h6_subsets         = ( ! empty( $h6_font['subset'] ) && $ig_h6_font ) ? $h6_font['subset'] : array();
    $wg_title_subsets   = ( ! empty( $wg_title_font['subset'] ) && $ig_wgtitle_font ) ? $wg_title_font['subset'] : array();
    $wg_ptitle_subsets  = ( ! empty( $wg_p_title_font['subset'] ) && $ig_wptitle_font ) ? $wg_p_title_font['subset'] : array();
    
    $subsets = array_unique( array_merge( $body_subsets, $home_section_subsets, $home_p_title_subsets, $home_t_title_subsets, $blog_title_subsets, $page_title_subsets, $post_title_subsets, $contact_title_subsets, $testimonail_title_subsets, $team_title_subsets, $portfolio_title_subsets, $mcv_title_subsets, $client_title_subsets, $service_st_subsets, $h1_subsets, $h2_subsets, $h3_subsets, $h4_subsets, $h5_subsets, $h6_subsets, $wg_title_subsets, $wg_ptitle_subsets ) );
    $subsets = implode( ',', $subsets );
    
    /* Translators: If there are characters in your language that are not
    * supported by respective fonts, translate this to 'off'. Do not translate
    * into your own language.
    */
    $body              = _x( 'on', 'Body Font: on or off', 'business-one-page-pro' );
    $home_section      = _x( 'on', 'Home Section Title Font: on or off', 'business-one-page-pro' );
    $home_p_title      = _x( 'on', 'Home Section Portfolio Title Font: on or off', 'business-one-page-pro' );
    $home_t_title      = _x( 'on', 'Home Section Team Title Font: on or off', 'business-one-page-pro' );
    $blog_title        = _x( 'on', 'Home Section Blog Title Font: on or off', 'business-one-page-pro' );
    $page_title        = _x( 'on', 'Page Title above breadcrumb Font: on or off', 'business-one-page-pro' );
    $post_title        = _x( 'on', 'Archive page Post Title Font: on or off', 'business-one-page-pro' );    
    $contact_title     = _x( 'on', 'Contact Title Font of Contact Section and Contact Page Template: on or off', 'business-one-page-pro' );
    $testimonial_title = _x( 'on', 'Testimonial Title Font of Testimonial Page Template: on or off', 'business-one-page-pro' );
    $team_title        = _x( 'on', 'Team Title Font of Team Page Template: on or off', 'business-one-page-pro' );
    $portfolio_title   = _x( 'on', 'Portfolio Title Font of Portfolio Page Template: on or off', 'business-one-page-pro' );
    $mcv_title         = _x( 'on', 'Our Mission & Our Core Value Title Font of About Page Template: on or off', 'business-one-page-pro' );
    $client_title      = _x( 'on', 'Our Client Title Font of Home page & About page Template: on or off', 'business-one-page-pro' );
    $st_title          = _x( 'on', 'Section Title Font of Service page Template: on or off', 'business-one-page-pro' );
    $h1                = _x( 'on', 'H1 Content Font: on or off', 'business-one-page-pro' );
    $h2                = _x( 'on', 'H2 Content Font: on or off', 'business-one-page-pro' );
    $h3                = _x( 'on', 'H3 Content Font: on or off', 'business-one-page-pro' );
    $h4                = _x( 'on', 'H4 Content Font: on or off', 'business-one-page-pro' );
    $h5                = _x( 'on', 'H5 Content Font: on or off', 'business-one-page-pro' );
    $h6                = _x( 'on', 'H6 Content Font: on or off', 'business-one-page-pro' );
    $wg_title          = _x( 'on', 'Widget Title Font: on or off', 'business-one-page-pro' );
    $wg_p_title        = _x( 'on', 'Widget Post Title Font: on or off', 'business-one-page-pro' );
    
    if ( 'off' !== $body || 'off' !== $home_section || 'off' !== $home_p_title || 'off' !== $home_t_title || 'off' !== $blog_title || 'off' !== $page_title || 'off' !== $post_title || 'off' !== $contact_title || 'off' !== $testimonial_title || 'off' !== $team_title  || 'off' !== $portfolio_title || 'off' !== $mcv_title || 'off' !== $client_title || 'off' !== $st_title || 'off' !== $h1 || 'off' !== $h2 || 'off' !== $h3 || 'off' !== $h4 || 'off' !== $h5 || 'off' !== $h6 || 'off' !== $wg_title || 'off' !== $wg_p_title ) {
        
        $font_families = array();
     
        if ( 'off' !== $body && $ig_body_font ) {
            if( ! empty( $body_font['variant'] ) ){
                $b_var = ':' . business_one_page_pro_check_varient( $body_font['font-family'], $body_font['variant'] );
            }else{
                $b_var = '';    
            }            
            $font_families[] = $body_font['font-family'] . $b_var;
        }
         
        if ( 'off' !== $home_section && $ig_home_section_font ) {
            if( ! empty( $home_section_font['variant'] ) ){
                $home_section_var = ':' . business_one_page_pro_check_varient( $home_section_font['font-family'], $home_section_font['variant'] );    
            }else{
                $home_section_var = '';
            }
            $font_families[] = $home_section_font['font-family'] . $home_section_var;
        }
        
        if ( 'off' !== $home_p_title && $ig_home_p_title_font ) {
            if( ! empty( $home_p_title_font['variant'] ) ){
                $home_p_title_var = ':' . business_one_page_pro_check_varient( $home_p_title_font['font-family'], $home_p_title_font['variant'] );    
            }else{
                $home_p_title_var = '';
            }
            $font_families[] = $home_p_title_font['font-family'] . $home_p_title_var;
        }
        
        if ( 'off' !== $home_t_title && $ig_home_t_title_font ) {
            if( ! empty( $home_t_title_font['variant'] ) ){
                $home_t_title_var = ':' . business_one_page_pro_check_varient( $home_t_title_font['font-family'], $home_t_title_font['variant'] );    
            }else{
                $home_t_title_var = '';
            }
            $font_families[] = $home_t_title_font['font-family'] . $home_t_title_var;
        }
        
        if ( 'off' !== $blog_title && $ig_blog_title_font ) {
            if( ! empty( $blog_title_font['variant'] ) ){
                $blog_title_var = ':' . business_one_page_pro_check_varient( $blog_title_font['font-family'], $blog_title_font['variant'] );    
            }else{
                $blog_title_var = '';
            }
            $font_families[] = $blog_title_font['font-family'] . $blog_title_var;
        }
        
        if ( 'off' !== $page_title && $ig_page_title_font ) {
            if( ! empty( $page_title_font['variant'] ) ){
                $page_title_var = ':' . business_one_page_pro_check_varient( $page_title_font['font-family'], $page_title_font['variant'] );    
            }else{
                $page_title_var = '';
            }
            $font_families[] = $page_title_font['font-family'] . $page_title_var;
        }
        
        if ( 'off' !== $post_title && $ig_post_title_font ) {
            if( ! empty( $post_title_font['variant'] ) ){
                $post_title_var = ':' . business_one_page_pro_check_varient( $post_title_font['font-family'], $post_title_font['variant'] );    
            }else{
                $post_title_var = '';
            }
            $font_families[] = $post_title_font['font-family'] . $post_title_var;
        }
        
        if ( 'off' !== $contact_title && $ig_contact_title_font ) {
            if( ! empty( $contact_title_font['variant'] ) ){
                $contact_title_var = ':' . business_one_page_pro_check_varient( $contact_title_font['font-family'], $contact_title_font['variant'] );    
            }else{
                $contact_title_var = '';
            }
            $font_families[] = $contact_title_font['font-family'] . $contact_title_var;
        }
        
        if ( 'off' !== $testimonial_title && $ig_testimonial_title_font ) {
            if( ! empty( $testimonial_title_font['variant'] ) ){
                $testimonial_title_var = ':' . business_one_page_pro_check_varient( $testimonial_title_font['font-family'], $testimonial_title_font['variant'] );    
            }else{
                $testimonial_title_var = '';
            }
            $font_families[] = $testimonial_title_font['font-family'] . $testimonial_title_var;
        }
        
        if ( 'off' !== $team_title && $ig_team_title_font ) {
            if( ! empty( $team_title_font['variant'] ) ){
                $team_title_var = ':' . business_one_page_pro_check_varient( $team_title_font['font-family'], $team_title_font['variant'] );    
            }else{
                $team_title_var = '';
            }
            $font_families[] = $team_title_font['font-family'] . $team_title_var;
        }
        
        if ( 'off' !== $portfolio_title && $ig_portfolio_title_font ) {
            if( ! empty( $portfolio_title_font['variant'] ) ){
                $portfolio_title_var = ':' . business_one_page_pro_check_varient( $portfolio_title_font['font-family'], $portfolio_title_font['variant'] );    
            }else{
                $portfolio_title_var = '';
            }
            $font_families[] = $portfolio_title_font['font-family'] . $portfolio_title_var;
        }
        
        if ( 'off' !== $mcv_title && $ig_mcv_title_font ) {
            if( ! empty( $mcv_title_font['variant'] ) ){
                $mcv_title_var = ':' . business_one_page_pro_check_varient( $mcv_title_font['font-family'], $mcv_title_font['variant'] );    
            }else{
                $mcv_title_var = '';
            }
            $font_families[] = $mcv_title_font['font-family'] . $mcv_title_var;
        }
        
        if ( 'off' !== $client_title && $ig_client_title_font ) {
            if( ! empty( $client_title_font['variant'] ) ){
                $client_title_var = ':' . business_one_page_pro_check_varient( $client_title_font['font-family'], $client_title_font['variant'] );    
            }else{
                $client_title_var = '';
            }
            $font_families[] = $client_title_font['font-family'] . $client_title_var;
        }        
        
        if ( 'off' !== $st_title && $ig_service_st_font ) {
            if( ! empty( $service_st_font['variant'] ) ){
                $st_title_var = ':' . business_one_page_pro_check_varient( $service_st_font['font-family'], $service_st_font['variant'] );    
            }else{
                $st_title_var = '';
            }
            $font_families[] = $service_st_font['font-family'] . $st_title_var;
        }
        
        if ( 'off' !== $h1 && $ig_h1_font ) {
            if( ! empty( $h1_font['variant'] ) ){
                $h1_var = ':' . business_one_page_pro_check_varient( $h1_font['font-family'], $h1_font['variant'] );    
            }else{
                $h1_var = '';
            }
            $font_families[] = $h1_font['font-family'] . $h1_var;
        }
        
        if ( 'off' !== $h2 && $ig_h2_font ) {
            if( ! empty( $h2_font['variant'] ) ){
                $h2_var = ':' . business_one_page_pro_check_varient( $h2_font['font-family'], $h2_font['variant'] );    
            }else{
                $h2_var = '';
            }
            $font_families[] = $h2_font['font-family'] . $h2_var;
        }
        
        if ( 'off' !== $h3 && $ig_h3_font ) {
            if( ! empty( $h3_font['variant'] ) ){
                $h3_var = ':' . business_one_page_pro_check_varient( $h3_font['font-family'], $h3_font['variant'] );    
            }else{
                $h3_var = '';
            }
            $font_families[] = $h3_font['font-family'] . $h3_var;
        }
        
        if ( 'off' !== $h4 && $ig_h4_font ) {
            if( ! empty( $h4_font['variant'] ) ){
                $h4_var = ':' . business_one_page_pro_check_varient( $h4_font['font-family'], $h4_font['variant'] );    
            }else{
                $h4_var = '';
            }
            $font_families[] = $h4_font['font-family'] . $h4_var;
        }
        
        if ( 'off' !== $h5 && $ig_h5_font ) {
            if( ! empty( $h5_font['variant'] ) ){
                $h5_var = ':' . business_one_page_pro_check_varient( $h5_font['font-family'], $h5_font['variant'] );    
            }else{
                $h5_var = '';
            }
            $font_families[] = $h5_font['font-family'] . $h5_var;
        }
        
        if ( 'off' !== $h6 && $ig_h6_font ) {
            if( ! empty( $h6_font['variant'] ) ){
                $h6_var = ':' . business_one_page_pro_check_varient( $h6_font['font-family'], $h6_font['variant'] );    
            }else{
                $h6_var = '';
            }
            $font_families[] = $h6_font['font-family'] . $h6_var;
        }
        
        if ( 'off' !== $wg_title && $ig_wgtitle_font ) {
            if( ! empty( $wg_title_font['variant'] ) ){
                $wg_title_var = ':' . business_one_page_pro_check_varient( $wg_title_font['font-family'], $wg_title_font['variant'] );    
            }else{
                $wg_title_var = '';
            }
            $font_families[] = $wg_title_font['font-family'] . $wg_title_var;
        }
        
        if ( 'off' !== $wg_p_title && $ig_wptitle_font ) {
            if( ! empty( $wg_p_title_font['variant'] ) ){
                $wg_p_title_var = ':' . business_one_page_pro_check_varient( $wg_p_title_font['font-family'], $wg_p_title_font['variant'] );    
            }else{
                $wg_p_title_var = '';
            }
            $font_families[] = $wg_p_title_font['font-family'] . $wg_p_title_var;
        }
       
        $font_families = array_diff( array_unique( $font_families ), array('') );
        
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( $subsets ),
        );
        
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
     
    return esc_url_raw( $fonts_url );
}

/**
 * Get Google Fonts from Kirki 
*/
function business_one_page_pro_get_google_fonts(){
    $fonts = include wp_normalize_path( get_template_directory() . '/inc/kirki/modules/webfonts/webfonts.php' );
    $google_fonts = array();
    if ( is_array( $fonts ) ) {
		foreach ( $fonts['items'] as $font ) {
            $google_fonts[ $font['family'] ] = array(
				'variants' => $font['variants'],
			);
		}
	}    
    return $google_fonts;
}

/**
 * Checks for matched varients in google fonts for typography fields
*/
function business_one_page_pro_check_varient( $font_family = 'serif' , $font_variants = 'regular' ){
    $variant = '';
    $google_fonts  = business_one_page_pro_get_google_fonts(); //Google Fonts
    $websafe_fonts = business_one_page_pro_get_websafe_font(); //Standard Web Safe Fonts
    
    if( array_key_exists( $font_family, $google_fonts ) ){
        $variants = $google_fonts[ $font_family ][ 'variants' ];
    
        if( in_array( $font_variants, $variants ) ){
            $variant = $font_variants;
        }else{
            $variant = 'regular';
        }
        
    }else{ //Standard Web Safe Fonts
        if( array_key_exists( $font_family, $websafe_fonts ) ){
            $variants = $websafe_fonts[ $font_family ][ 'variants' ];
            if( in_array( $font_variants, $variants ) ){
                $variant = $font_variants;
            }else{
                $variant = 'regular';
            }    
        }
    }
    return $variant;
}

/**
 * Returns font weight and font style to use in dynamic styles.
*/
function business_one_page_pro_get_css_variant( $font_variant ){
    $v_array = array(
		'100'       => array(
            'weight'    => '100',
            'style'     => 'normal'
            ),
		'100italic' => array(
            'weight'    => '100',
            'style'     => 'italic'
            ),
		'200'       => array(
            'weight'    => '200',
            'style'     => 'normal'
            ),
		'200italic' => array(
            'weight'    => '200',
            'style'     => 'italic'
            ),
		'300'       => array(
            'weight'    => '300',
            'style'     => 'normal'
            ),
		'300italic' => array(
            'weight'    => '300',
            'style'     => 'italic'
            ),
		'regular'   => array(
            'weight'    => '400',
            'style'     => 'normal'
            ),
		'italic'    => array(
            'weight'    => '400',
            'style'     => 'italic'
            ),
		'500'       => array(
            'weight'    => '500',
            'style'     => 'normal'
            ),
		'500italic' => array(
            'weight'    => '500',
            'style'     => 'italic'
            ),
		'600'       => array(
            'weight'    => '600',
            'style'     => 'normal'
            ),
		'600italic' => array(
            'weight'    => '600',
            'style'     => 'italic'
            ),
		'700'       => array(
            'weight'    => '700',
            'style'     => 'normal'
            ),
		'700italic' => array(
            'weight'    => '700',
            'style'     => 'italic'
            ),
		'800'       => array(
            'weight'    => '800',
            'style'     => 'normal'
            ),
		'800italic' => array(
            'weight'    => '800',
            'style'     => 'italic'
            ),
		'900'       => array(
            'weight'    => '900',
            'style'     => 'normal'
            ),
		'900italic' => array(
            'weight'    => '900',
            'style'     => 'italic'
            ),
	);
    
    if( array_key_exists( $font_variant, $v_array ) ){
        return $v_array[ $font_variant ];
    }
} 

/**
 * Filter function to change the value of Standard Web safe Fonts
*/
function business_one_page_pro_filter_websafe_font(){
    $standard_fonts = array(
		'serif' => array(
			'label' => _x( 'Serif', 'font style', 'business-one-page-pro' ),
			'stack' => 'serif',
		),
		'sans-serif' => array(
			'label'  => _x( 'Sans Serif', 'font style', 'business-one-page-pro' ),
			'stack'  => 'sans-serif',
		),
		'monospace' => array(
			'label' => _x( 'Monospace', 'font style', 'business-one-page-pro' ),
			'stack' => 'monospace',
		),
    );
    return $standard_fonts;
}
add_filter( 'kirki/fonts/standard_fonts', 'business_one_page_pro_filter_websafe_font' );

/**
 * Function listing WebSafe Fonts and its attributes
*/
function business_one_page_pro_get_websafe_font(){
    $standard_fonts = array(
		'serif' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'fonts' => '"Times New Roman", Times, serif',
		),
		'sans-serif' => array(
			'variants'  => array( 'regular', 'italic', '700', '700italic' ),
			'fonts'  => 'Arial, Helvetica, sans-serif',
		),
		'monospace' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'fonts' => '"Courier New", Courier, monospace',
		),
    );
    return $standard_fonts;
}

/**
 * Function to check if it's a google font
*/
function business_one_page_pro_is_google_font( $font ){
    $return = false;
    $websafe_fonts = business_one_page_pro_get_websafe_font();
    if( $font ){
        if( array_key_exists( $font, $websafe_fonts ) ){
            //Web Safe Font
            $return = false;
        }else{
            //Google Font
            $return = true;
        }
    }
    return $return; 
}

/**
 * Function to get valid font, weight and style
*/
function business_one_page_pro_get_fonts( $font_family, $font_variant ){
    
    $fonts = array();
    $websafe_fonts = business_one_page_pro_get_websafe_font(); //Web Safe Font
    
    if( $font_family ){
        if( business_one_page_pro_is_google_font( $font_family ) ){
            $fonts['font'] = esc_attr( $font_family ); //Google Font
            if( $font_variant ){
                $weight_style    = business_one_page_pro_get_css_variant( business_one_page_pro_check_varient( $font_family, $font_variant ) );
                $fonts['weight'] = $weight_style['weight'];
                $fonts['style']  = $weight_style['style'];
            }else{
                $fonts['weight'] = '400';
                $fonts['style']  = 'normal';
            }
        }else{
            if( array_key_exists( $font_family, $websafe_fonts ) ){
                $fonts['font'] = $websafe_fonts[ $font_family ]['fonts']; //Web Safe Font
                if( $font_variant ){
                    $weight_style    = business_one_page_pro_get_css_variant( business_one_page_pro_check_varient( $font_family, $font_variant ) );
                    $fonts['weight'] = $weight_style['weight'];
                    $fonts['style']  = $weight_style['style'];
                }else{
                    $fonts['weight'] = '400';
                    $fonts['style']  = 'normal';
                }
            }
        }   
    }else{
        $fonts['font']   = '"Times New Roman", Times, serif';
        $fonts['weight'] = '400';
        $fonts['style']  = 'normal';
    }
    
    return $fonts;
}