jQuery(document).ready(function($) {
	/* Move widgets to their respective sections */
	wp.customize.section( 'sidebar-widgets-about-section' ).panel( 'business_one_page_pro_home_page_settings' );
	wp.customize.section( 'sidebar-widgets-about-section' ).priority( '21' );
    wp.customize.section( 'sidebar-widgets-service-section' ).panel( 'business_one_page_pro_home_page_settings' );
	wp.customize.section( 'sidebar-widgets-service-section' ).priority( '23' );
    wp.customize.section( 'sidebar-widgets-cta-one' ).panel( 'business_one_page_pro_home_page_settings' );
	wp.customize.section( 'sidebar-widgets-cta-one' ).priority( '24' );
    wp.customize.section( 'sidebar-widgets-cta-two' ).panel( 'business_one_page_pro_home_page_settings' );
	wp.customize.section( 'sidebar-widgets-cta-two' ).priority( '30' );
    
    wp.customize.section( 'sidebar-widgets-about-counter' ).panel( 'business_one_page_pro_about_page_settings' );
	wp.customize.section( 'sidebar-widgets-about-counter' ).priority( '20' );
    wp.customize.section( 'sidebar-widgets-about-second' ).panel( 'business_one_page_pro_about_page_settings' );
	wp.customize.section( 'sidebar-widgets-about-second' ).priority( '23' );
    
    wp.customize.section( 'sidebar-widgets-service-first' ).panel( 'business_one_page_pro_service_page_settings' );
	wp.customize.section( 'sidebar-widgets-service-first' ).priority( '20' );
    wp.customize.section( 'sidebar-widgets-service-second' ).panel( 'business_one_page_pro_service_page_settings' );
	wp.customize.section( 'sidebar-widgets-service-second' ).priority( '23' );
    wp.customize.section( 'sidebar-widgets-service-third' ).panel( 'business_one_page_pro_service_page_settings' );
	wp.customize.section( 'sidebar-widgets-service-third' ).priority( '24' );

	/* Home page preview url */
    wp.customize.panel( 'business_one_page_pro_home_page_settings', function( section ){
        section.expanded.bind( function( isExpanded ) {
            if( isExpanded ){
                wp.customize.previewer.previewUrl.set( bopp_cdata.home );
            }
        });
    });

    /* Blog page preview url */
    wp.customize.section( 'business_one_page_pro_blog_page_settings', function( section ){
        section.expanded.bind( function( isExpanded ) {
            if( isExpanded ){
                wp.customize.previewer.previewUrl.set( bopp_cdata.blog );
            }
        });
    });
    
    /* About Page preview url */
    wp.customize.panel( 'business_one_page_pro_about_page_settings', function( section ){
        section.expanded.bind( function( isExpanded ){
            if( isExpanded ){
                wp.customize.previewer.previewUrl.set( bopp_cdata.about );
            }
        });
    });

    /* Services Page preview url */
    wp.customize.panel( 'business_one_page_pro_service_page_settings', function( section ){
        section.expanded.bind( function( isExpanded ){
            if( isExpanded ){
                wp.customize.previewer.previewUrl.set( bopp_cdata.services );
            }
        });
    });

    /* Contact Page preview url */
    wp.customize.panel( 'business_one_page_pro_contact_page_settings', function( section ){
        section.expanded.bind( function( isExpanded ){
            if( isExpanded ){
                wp.customize.previewer.previewUrl.set( bopp_cdata.contact );
            }
        });
    });

    // Scroll to front page sections
    $('body').on('click', '#sub-accordion-panel-business_one_page_pro_home_page_settings .control-subsection .accordion-section-title', function(event) {
        var section_id = $(this).parent('.control-subsection').attr('id');
        scroll_to_homepage_section( section_id );
    }); 

    // Scroll to about page sections
    $('body').on('click', '#sub-accordion-panel-business_one_page_pro_about_page_settings .control-subsection .accordion-section-title', function(event) {
        var section_id = $(this).parent('.control-subsection').attr('id');
        scroll_to_about_template_section( section_id );
    });

    //Scroll to services page sections
    $('body').on('click', '#sub-accordion-panel-business_one_page_pro_service_page_settings .control-subsection .accordion-section-title', function(event) {
        var section_id = $(this).parent('.control-subsection').attr('id');
        scroll_to_services_template_section( section_id );
    }); 
    
});

function scroll_to_homepage_section( section_id ){
    var preview_section_id = "banner-slider";

    var $contents = jQuery('#customize-preview iframe').contents();

    switch ( section_id ) {

        case 'accordion-section-business_one_page_pro_about_section':
        case 'accordion-section-sidebar-widgets-about-section':
        preview_section_id = "about";
        break;
        
        case 'accordion-section-business_one_page_pro_services_section':
        case 'accordion-section-sidebar-widgets-service-section':
        preview_section_id = "services";
        break;

        case 'accordion-section-sidebar-widgets-cta-one':
        preview_section_id = "cta1";
        break;
        
        case 'accordion-section-business_one_page_pro_portfolio_section':
        preview_section_id = "portfolio";
        break;

        case 'accordion-section-business_one_page_pro_team_section':
        preview_section_id = "team";
        break;

        case 'accordion-section-business_one_page_pro_clients_section':
        preview_section_id = "clients";
        break;
        
        case 'accordion-section-business_one_page_pro_blog_section':
        preview_section_id = "blog";
        break;

        case 'accordion-section-business_one_page_pro_testimonial_section':
        preview_section_id = "testimonial";
        break;
        
        case 'accordion-section-sidebar-widgets-cta-two':
        preview_section_id = "cta2";
        break;

        case 'accordion-section-business_one_page_pro_contact_section':
        preview_section_id = "contact";
        break;

        case 'accordion-section-business_one_page_pro_sort_home_section':
        preview_section_id = "banner-slider";
        break;
    }

    if( $contents.find('#'+preview_section_id).length > 0 && $contents.find('.home').length > 0 ){
        $contents.find("html, body").animate({
        scrollTop: $contents.find( "#" + preview_section_id ).offset().top
        }, 1000);
    }
}

function scroll_to_about_template_section( section_id ){
    var preview_section_id = "about-intro";

    var $contents = jQuery('#customize-preview iframe').contents();

    switch ( section_id ) {
        
        case 'accordion-section-sidebar-widgets-about-counter':
        preview_section_id = "about-stat";
        break;
        
        case 'accordion-section-business_one_page_pro_mission_section':
        preview_section_id = "about-mission";
        break;
        
        case 'accordion-section-business_one_page_pro_core_value_section':
        case 'accordion-section-sidebar-widgets-about-second':
        preview_section_id = "about-core";
        break;
        
        case 'accordion-section-business_one_page_pro_our_client_section':
        preview_section_id = "clients";
        break;
        
        case 'accordion-section-business_one_page_pro_sort_about_section':
        preview_section_id = "about-intro";
        break;
    }

    if( $contents.find('#'+preview_section_id).length > 0 && $contents.find('.page-template-template-about').length > 0 ){
        $contents.find("html, body").animate({
        scrollTop: $contents.find( "#" + preview_section_id ).offset().top
        }, 1000);
    }
}

function scroll_to_services_template_section( section_id ){
    var preview_section_id = "service-intro";

    var $contents = jQuery('#customize-preview iframe').contents();

    switch ( section_id ) {
        
        case 'accordion-section-sidebar-widgets-service-first':
        preview_section_id = "service-intro";
        break;
        
        case 'accordion-section-business_one_page_pro_iframe_section':
        preview_section_id = "service-iframe";
        break;

        case 'accordion-section-business_one_page_pro_feature_section':
        case 'accordion-section-sidebar-widgets-service-second':
        preview_section_id = "service-feature";
        break;

        case 'accordion-section-sidebar-widgets-service-third':
        preview_section_id = "service-cta";
        break;

        case 'accordion-section-business_one_page_pro_moreinfo_section':
        preview_section_id = "service-more";
        break;

        case 'accordion-section-business_one_page_pro_sort_service_section':
        preview_section_id = "service-intro";
        break;
    }

    if( $contents.find('#'+preview_section_id).length > 0 && $contents.find('.page-template-template-services').length > 0 ){
        $contents.find("html, body").animate({
        scrollTop: $contents.find( "#" + preview_section_id ).offset().top
        }, 1000);
    }
}