<?php
/**
 * Business One Page Pro Import Hooks.
 *
 * @package Business_One_Page_Pro 
 */
 
/** Import content data*/
if ( ! function_exists( 'business_one_page_pro_import_files' ) ) :
function business_one_page_pro_import_files() {
    return array(
        array(
            'import_file_name'             => 'Default Demo',
            'import_file_url'              => 'https://rarathemes.com/wp-content/uploads/2018/08/businessonepagepro.xml',
            'import_widget_file_url'       => 'https://rarathemes.com/wp-content/uploads/2018/08/businessonepagepro.wie',
            'import_customizer_file_url'   => 'https://rarathemes.com/wp-content/uploads/2018/08/businessonepagepro.dat',
            'import_preview_image_url'     => get_template_directory() .'/screenshot.png',
            'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'business-one-page-pro' ),
        ),
    );       
}
add_filter( 'rrdi/import_files', 'business_one_page_pro_import_files' );
endif;

/** Programmatically set the front page and menu */
if ( ! function_exists( 'business_one_page_pro_after_import' ) ) :
function business_one_page_pro_after_import( $selected_import ) {
 
    if ( 'Default Demo' === $selected_import['import_file_name'] ) {
        //Set Menu
        $top = get_term_by('name', 'Top Header Menu', 'nav_menu');
        set_theme_mod( 'nav_menu_locations' , array( 
              'top' => $top->term_id 
             ) 
        );
 
       /** Set Front page */
       $page = get_page_by_path('homepage'); /** This need to be slug of the page that is assigned as Front page */
       if ( isset( $page->ID ) ) {
        update_option( 'page_on_front', $page->ID );
        update_option( 'show_on_front', 'page' );
       }
       
       /** Blog Page */
        $postpage = get_page_by_path('blog'); /** This need to be slug of the page that is assigned as Posts page */
        if( $postpage ){
            $post_pgid = $postpage->ID;
            
            update_option( 'page_for_posts', $post_pgid );
        }
        
    }
     
}
add_action( 'rrdi/after_import', 'business_one_page_pro_after_import' );
endif;

function business_one_page_pro_import_msg(){
    return __( 'Before you begin, make sure all the recommended plugins are activated.', 'business-one-page-pro' );
}
add_filter( 'rrdi_before_import_msg', 'business_one_page_pro_import_msg' );