<?php
/**
 * Customizer Post Meta Section 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_postmeta(){
    
    Kirki::add_section( 'business_one_page_pro_post_meta_settings', array(
        'title' => __( 'Post Meta Settings', 'business-one-page-pro' ),
        'priority' => 29,
        'capability' => 'edit_theme_options',
    ));
    
    /** No. of Character */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'No. of Character of Post Excerpt', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_post_meta_settings',
        'settings'  => 'business_one_page_pro_post_no_of_char',
        'type'      => 'slider',
        'default'   => 200,
        'choices'   => array(
            'min'   => 50,
            'max'   => 500,
            'step'  => 10
        ),
    ) );
    
    /** Read More Text */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Post Read More Text', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_post_meta_settings',
        'settings'  => 'business_one_page_pro_post_read_more',
        'type'      => 'text',
        'default'   => __( 'Read More', 'business-one-page-pro' ),
    ) );
    
}
add_action( 'init', 'business_one_page_pro_customize_register_postmeta' );

function business_one_page_pro_customize_postmeta( $wp_customize ){
    
    /** Post Meta in Blog Section */
    $wp_customize->add_setting( 
        'business_one_page_pro_post_meta_blog_section', 
        array(
            'default'           => array( 'date', 'comment_count' ),
            'sanitize_callback' => 'business_one_page_pro_sanitize_select'
        )    
    );
    
    $wp_customize->add_control(
		new Rara_Controls_Select_Control(
			$wp_customize,
			'business_one_page_pro_post_meta_blog_section',
			array(
				'section'		=> 'business_one_page_pro_post_meta_settings',				
				'label'			=> __( 'Post Meta in Blog Section', 'business-one-page-pro' ),
                'description'   => __( 'You can rearrange the order you want.', 'business-one-page-pro' ),
				'choices'   => array(
                    'date'          => __( 'Date', 'business-one-page-pro' ),
                    'comment_count' => __( 'Comment Count', 'business-one-page-pro' ),
                ),
                'multiple'      => 2
			)
		)
	);
    
    /** Post Meta in Inner page*/
    $wp_customize->add_setting( 
        'business_one_page_pro_post_meta_blog_page', 
        array(
            'default'           => array( 'date', 'author' ),
            'sanitize_callback' => 'business_one_page_pro_sanitize_select'
        )    
    );
    
    $wp_customize->add_control(
		new Rara_Controls_Select_Control(
			$wp_customize,
			'business_one_page_pro_post_meta_blog_page',
			array(
				'section'		=> 'business_one_page_pro_post_meta_settings',				
				'label'			=> __( 'Post Meta in Inner Page', 'business-one-page-pro' ),
                'description'   => __( 'You can rearrange the order you want.', 'business-one-page-pro' ),
				'choices'   => array(
                    'date'  => __( 'Date', 'business-one-page-pro' ),
                    'author'=> __( 'Author', 'business-one-page-pro' ),
                ),
                'multiple'      => 2
			)
		)
	);
    
    /** Categories and Tags */
    $wp_customize->add_setting( 
        'business_one_page_pro_cat_tag', 
        array(
            'default'           => array( 'cat', 'tag' ),
            'sanitize_callback' => 'business_one_page_pro_sanitize_select'
        )    
    );
    
    $wp_customize->add_control(
		new Rara_Controls_Select_Control(
			$wp_customize,
			'business_one_page_pro_cat_tag',
			array(
				'section'		=> 'business_one_page_pro_post_meta_settings',				
				'label'			=> __( 'Categories and Tags', 'business-one-page-pro' ),
                'description'   => __( 'You can rearrange the order you want.', 'business-one-page-pro' ),
				'choices'   => array(
                    'cat'   => __( 'Categories', 'business-one-page-pro' ),
                    'tag'   => __( 'Tags', 'business-one-page-pro' ),
                ),
                'multiple'      => 2
			)
		)
	);
    
}
add_action( 'customize_register', 'business_one_page_pro_customize_postmeta' );