<?php
/**
 * Performance Settings
 *
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_general_performance() {
     

    /** Performance Settings */
    Kirki::add_section( 'business_one_page_pro_performance_settings', array(
        'title' => __( 'Performance Settings', 'business-one-page-pro' ),
        'priority' => 70,
        'capability' => 'edit_theme_options',
    ) );
    
    /** Lazy Load */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Lazy Load', 'business-one-page-pro' ),
        'description'   => __( 'Enable lazy loading of featured images.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_performance_settings',
        'settings'  => 'ed_lazy_load',
        'type'      => 'toggle',
        'default'   => '0',
    ) );

    /** Lazy Load Content Images */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Lazy Load Content Images', 'business-one-page-pro' ),
        'description'   => __( 'Enable lazy loading of images inside page/post content.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_performance_settings',
        'settings'  => 'ed_lazy_load_cimage',
        'type'      => 'toggle',
        'default'   => '0',
    ) );

    /** Defer JavaScript */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Defer JavaScript', 'business-one-page-pro' ),
        'description'   => __( 'Adds "defer" attribute to sript tags to improve page download speed.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_performance_settings',
        'settings'  => 'ed_defer',
        'type'      => 'toggle',
        'default'   => '0',
    ) );

    /** Remove ver parameters */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'     => __( 'Remove ver parameters', 'business-one-page-pro' ),
        'description'   => __( 'Enable to remove "ver" parameter from CSS and JS file calls.', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_performance_settings',
        'settings'  => 'ed_ver',
        'type'      => 'toggle',
        'default'   => '0',
    ) );
    
}
add_action( 'init', 'business_one_page_pro_customize_register_general_performance' );