<?php
/**
 * Business One Page Pro Theme Info
 *
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customizer_theme_info( $wp_customize ) {
	
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    
    if ( version_compare( $GLOBALS['wp_version'], '4.7', '>=' ) ) {
        $wp_customize->get_section( 'custom_css' )->panel = 'business_one_page_pro_custom_code_panel';  
    }
    
    if ( version_compare( $GLOBALS['wp_version'], '4.9', '>=' ) ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'business-one-page-pro' );    
    }
    
    $wp_customize->add_section( 'theme_info', 
        array(
            'title'    => __( 'Information Links' , 'business-one-page-pro' ),
            'priority' => 5,
		)
    );

	/** Important Links */
	$wp_customize->add_setting( 'theme_info_theme',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    $theme_info = '<ul>';
	$theme_info .= sprintf( __( '<li>View demo: %1$sClick here.%2$s</li>', 'business-one-page-pro' ),  '<a href="' . esc_url( 'https://demo.rarathemes.com/business-one-page-pro/' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( __( '<li>View documentation: %1$sClick here.%2$s</li>', 'business-one-page-pro' ),  '<a href="' . esc_url( 'https://docs.rarathemes.com/docs/business-one-page-pro/' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( __( '<li>Theme info: %1$sClick here.%2$s</li>', 'business-one-page-pro' ),  '<a href="' . esc_url( 'https://rarathemes.com/wordpress-themes/business-one-page-pro/' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( __( '<li>Support ticket: %1$sClick here.%2$s</li>', 'business-one-page-pro' ),  '<a href="' . esc_url( 'https://rarathemes.com/support-ticket/' ) . '" target="_blank">', '</a>' );
    $theme_info .= sprintf( __( '<li>More WordPress Themes: %1$sClick here.%2$s</li>', 'business-one-page-pro' ),  '<a href="' . esc_url( 'https://rarathemes.com/wordpress-themes/' ) . '" target="_blank">', '</a>' );
    $theme_info .= '</ul>';

	$wp_customize->add_control( new Business_One_Page_Pro_Theme_Info( $wp_customize,
        'theme_info_theme',
            array(
                'label'       => __( 'Important Links' , 'business-one-page-pro' ),
                'section'     => 'theme_info',
                'description' => $theme_info
    		)
        )
    );

}
add_action( 'customize_register', 'business_one_page_pro_customizer_theme_info' );


if( class_exists( 'WP_Customize_control' ) ){

	class Business_One_Page_Pro_Theme_Info extends WP_Customize_Control
	{
    	public function render_content(){ ?>
    	    <span class="customize-control-title">
    			<?php echo esc_html( $this->label ); ?>
    		</span>
    
    		<?php if( $this->description ){ ?>
    			<span class="description customize-control-description">
    			<?php echo wp_kses_post($this->description); ?>
    			</span>
    		<?php }
        }
    }//editor close
    
}//class close