<?php
/**
 * Customizer General Section 
 * 
 * @package Business_One_Page_Pro
 */
 
    
function business_one_page_pro_customize_register_general(){  
    
    Kirki::add_config( 'business_one_page_pro', array(
        'capability'    => 'edit_theme_options',
        'option_type'   => 'theme_mod',
        'disable_output'=> true,
    ) );
    
    Kirki::add_section( 'business_one_page_pro_general_settings', array(
        'priority'   => 22,
        'capability' => 'edit_theme_options',
        'title'      => __( 'General Settings', 'business-one-page-pro' ),
    ) );
    
    /** Admin Bar */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_adminbar',
        'label'       => __( 'Enable/Disable Admin Bar', 'business-one-page-pro' ),
        'tooltip'        => __( 'Enable/Disable Admin Bar in frontend when logged in.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_general_settings',
        'default'     => '',
    ) );
        
    /** Lightbox */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_lightbox',
        'label'       => __( 'Enable/Disable Lightbox', 'business-one-page-pro' ),
        'tooltip'        => __( 'A lightbox is a stylized pop-up that allows your visitors to view larger versions of images without leaving the current page. You can enable or disable the lightbox here.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_general_settings',
        'default'     => '',
    ) );
    
    /** Ajax Quick Search */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_ajax_search',
        'label'       => __( 'Enable/Disable Ajax Quick Search', 'business-one-page-pro' ),
        'tooltip'        => __( 'Enable or disable search results appearing instantly below the search form.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_general_settings',
        'default'     => '',
    ) );
    
    /** Pagination Type */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'radio',
        'settings'    => 'business_one_page_pro_pagination_type',
        'label'       => __( 'Pagination Type', 'business-one-page-pro' ),
        'tooltip'        => __( 'Select pagination type.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_general_settings',
        'default'     => 'default',
        'choices'     => array(
            'default'         => __( 'Default (Next / Previous)', 'business-one-page-pro' ),
            'numbered'        => __( 'Numbered (1 2 3 4...)', 'business-one-page-pro' ),
            'load_more'       => __( 'AJAX (Load More Button)', 'business-one-page-pro' ),
            'infinite_scroll' => __( 'AJAX (Auto Infinite Scroll)', 'business-one-page-pro' ),
        )  
    ) );
    
    /** Load More Label*/
    Kirki::add_field( 'business_one_page_pro', array(
        'type'     => 'text',
        'settings' => 'business_one_page_pro_load_more_label',
        'label'    => __( 'Load More Label', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_general_settings',
        'default'  => __( 'Load More Posts', 'business-one-page-pro' ),
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_pagination_type',
                'operator' => '==',
                'value'    => 'load_more',
            )            
        )
    ) );
    
    /** Loading Label*/
    Kirki::add_field( 'business_one_page_pro', array(
        'type'     => 'text',
        'settings' => 'business_one_page_pro_loading_label',
        'label'    => __( 'Loading Label', 'business-one-page-pro' ),
        'section'  => 'business_one_page_pro_general_settings',
        'default'  => __( 'Loading...', 'business-one-page-pro' ),
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_pagination_type',
                'operator' => '==',
                'value'    => 'load_more',
            )            
        )
    ) );
    
}
add_action( 'init', 'business_one_page_pro_customize_register_general' );