<?php
/**
 * Customizer Footer Section 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_footer(){ 
    
    Kirki::add_section( 'business_one_page_pro_footer_settings', array(
        'title' => __( 'Footer Settings', 'business-one-page-pro' ),
        'priority' => 122,
        'capability' => 'edit_theme_options',
    ) );
    
    /** Footer Copyright*/
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'textarea',
        'settings'    => 'business_one_page_pro_footer_copyright',
        'label'       => __( 'Footer Copyright', 'business-one-page-pro' ),
        'tooltip'        => __( 'You can change footer copyright and use your own custom text from here. Added "[the-year]", "[the-site-link]" shortcode.', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_footer_settings',
        'default'     => '',
        'sanitize_callback' => 'business_one_page_pro_sanitize_text',
    ) );
    
    /** Hide Author Link */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_author_link',
        'label'       => __( 'Hide Author Link', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_footer_settings',
        'default'     => '',
    ) );
    
    /** Hide WordPress Link */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_wp_link',
        'label'       => __( 'Hide WordPress Link', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_footer_settings',
        'default'     => '',
    ) );
    
}
add_action( 'init', 'business_one_page_pro_customize_register_footer' );