<?php 
/**
 * Elementor Page Options
 *
 * @package business_one_page_pro
 */

function business_one_page_pro_customize_register_elementor() {

    /** Elementor Settings */
    Kirki::add_section( 'business_one_page_pro_elementor_settings', array(
        'title'      => __( 'Elementor Settings', 'business-one-page-pro' ),
        'priority'   => 80,
        'capability' => 'edit_theme_options',
    ) );
    
    /** Enable/Disable Elementor in the Front Page */
    Kirki::add_field( 'business_one_page_pro', array(
        'label'           => __( 'Enable Elementor Page Builder in FrontPage', 'business-one-page-pro' ),
        'description'     => __( 'You can override your Homepage Contents from this Elementor Page Builder', 'business-one-page-pro' ),
        'section'         => 'business_one_page_pro_elementor_settings',
        'settings'        => 'ed_elementor',
        'type'            => 'toggle',
        'active_callback' => 'is_elementor_activated',
        'default'         => '0',
    ) );

}
add_action( 'init', 'business_one_page_pro_customize_register_elementor' );