<?php
/**
 * Demo Import Section
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_demo( $wp_customize ) {

    $wp_customize->add_section(
        'demo_data_import_setting',
        array(
            'title'       => __('Demo Import', 'business-one-page-pro' ),
            'capability'  => 'edit_theme_options',
            'priority'    => '6',
        )
    );

    $wp_customize->add_setting(
        'demo_data_import',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
    if( is_rocdi_activated() ){
        $descritpion = sprintf( __( 'Demo Import setting is moved to addon plugin, "Rara One Click Demo Import". Please use lastest plugin to import demo content from %1$shere%2$s.', 'business-one-page-pro' ), '<a href="' . admin_url( 'themes.php?page=rara-demo-import' ) . '" target="_blank">', '</a>' );
    }else{
        $descritpion = sprintf( __( 'Demo Import setting is moved to addon plugin, "Rara One Click Demo Import". Please install the latest plugin via %1$sinstaller%2$s and import demo content.', 'business-one-page-pro' ), '<a href="' . admin_url( 'themes.php?page=tgmpa-install-plugins' ) . '" target="_blank">', '</a>' );
    }
    
    $wp_customize->add_control( new Business_One_Page_Pro_Theme_Info(
        $wp_customize,
            'demo_data_import',
        array(
            'section'     => 'demo_data_import_setting',
            'label'       => __( 'Demo Import', 'business-one-page-pro' ),
            'description' => $descritpion
        ))
    );
    /** Demo Import Ends */
}
add_action( 'customize_register', 'business_one_page_pro_customize_register_demo' );