<?php
/**
 * Customizer Custom Code Section 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_custom(){
    
    if ( version_compare( $GLOBALS['wp_version'], '4.7', '<' ) ) {
        
        Kirki::add_section( 'business_one_page_pro_custom_settings', array(
            'title'      => __( 'Custom Codes', 'business-one-page-pro' ),
            'priority'   => 121,
            'capability' => 'edit_theme_options',
        ) );
        
        /** Custom Script */
        Kirki::add_field( 'business_one_page_pro', array(
            'type'        => 'code',
            'settings'    => 'business_one_page_pro_custom_script',
            'label'       => __( 'Custom Script', 'business-one-page-pro' ),
            'tooltip'        => __( 'Put the script like anlytics or any other here.', 'business-one-page-pro' ),
            'section'     => 'business_one_page_pro_custom_settings',
            'choices'     => array(
                'language' => 'javascript',
                'theme'    => 'monokai',
                'height'   => 250,
            ),
        ) );
        
        /** Custom CSS */
        Kirki::add_field( 'business_one_page_pro', array(
            'type'        => 'code',
            'settings'    => 'business_one_page_pro_custom_css',
            'label'       => __( 'Custom CSS', 'business-one-page-pro' ),
            'tooltip'        => __( 'Put your custom css here.', 'business-one-page-pro' ),
            'section'     => 'business_one_page_pro_custom_settings',
            'choices'     => array(
                'language' => 'css',
                'theme'    => 'monokai',
                'height'   => 250,
            ),
        ) );
    
    }
}
add_action( 'init', 'business_one_page_pro_customize_register_custom' );