<?php
/**
 * Sanitaztion Functions 
*/

function business_one_page_pro_sanitize_text( $text ){
    return wp_kses_post( $text );
}

function business_one_page_pro_sanitize_email( $email, $setting ){
    // Sanitize $input as a hex value without the hash prefix.
	$email = sanitize_email( $email );    	
	// If $email is a valid email, return it; otherwise, return the default.
	return ( !empty( $email ) ? $email : $setting->default );    
}

function business_one_page_pro_sanitize_iframe( $iframe ){
    $allow_tag = array(
                    'iframe'=>array(
                        'src'=>array(),
                        'width'=>array(),
                        'height'=>array()
                    )
                );
    return wp_kses( $iframe, $allow_tag );
}

/**
 * Sanitize Multi select
*/
function business_one_page_pro_sanitize_select( $value ){
	if ( is_array( $value ) ){
		foreach ( $value as $key => $subvalue ) {
			$value[ $key ] = esc_attr( $subvalue );
		}
		return $value;
	}
	return esc_attr( $value );
}

/**
 * Sanitize Absint
*/
function business_one_page_pro_sanitize_number_absint( $number, $setting ) {
    // Ensure $number is an absolute integer (whole number, zero or greater).
    $number = absint( $number );                                                            
    // If the input is an absolute integer, return it; otherwise, return the default
    return ( $number ? $number : $setting->default );
}
/**
 * Sanitize Floatval
*/
function business_one_page_pro_sanitize_number_floatval( $number, $setting ) {
    // Ensure $number is an floatval.
    $number = floatval( $number );                                                          
    // If the input is an absolute integer, return it; otherwise, return the default
    return ( $number ? $number : $setting->default );
}

/**
 * Sanitize funtion for link in repeater field
*/
function business_one_page_pro_sanitize_customizer( $value ) {

    if ( !is_array( $value ) ) {
        $value = array();
    }
    
    if( ! empty( $value['business_one_page_pro_slider_slides'] ) ){
        /** For slider url */
        foreach ( $value['business_one_page_pro_slider_slides'] as $key => $subvalue ) {

            if ( isset( $value['business_one_page_pro_slider_slides'][ $key ]['link'] ) ) {
                $value['business_one_page_pro_slider_slides'][ $key ]['link'] = esc_url_raw( $value['business_one_page_pro_slider_slides'][ $key ]['link'] );
            }

        }
    }
    
    if( ! empty( $value['business_one_page_pro_social'] ) ){
        /** For Social links */
        foreach ( $value['business_one_page_pro_social'] as $key => $subvalue ) {

            if ( isset( $value['business_one_page_pro_social'][ $key ]['link'] ) ) {
                $value['business_one_page_pro_social'][ $key ]['link'] = esc_url_raw( $value['business_one_page_pro_social'][ $key ]['link'] );
            }

        }
    }
    
    if( ! empty( $value['business_one_page_pro_sidebar'] ) ){
        /** For sidebar id */
        foreach ( $value['business_one_page_pro_sidebar'] as $key => $subvalue ) {

            if ( isset( $value['business_one_page_pro_sidebar'][ $key ]['id'] ) ) {
                $value['business_one_page_pro_sidebar'][ $key ]['id'] = sanitize_title( $value['business_one_page_pro_sidebar'][ $key ]['id'] );
            }

        }
    }

    return $value;

}
add_action( 'sanitize_option_theme_mods_business-one-page-pro', 'business_one_page_pro_sanitize_customizer' );


/**
 * Input field with allowed google map iframe callback example.
 *
 */
function business_one_page_pro_sanitize_google_map_iframe( $input, $setting ) {
    $allowedtags = array(
        'iframe' => array(
            'src' => array(),
            'width' => array(),
            'height' => array(),
            'frameborder' => array(),
            'style'     => array(),
            'marginwidth' => array(),
            'marginheight' => array(),
        )
    );

    $input = wp_kses( $input, $allowedtags );

    return $input;
}