<?php
/**
 * Customizer Slider Panel 
 * 
 * @package Business_One_Page_Pro
 */
 
function business_one_page_pro_customize_register_slider(){

    /* Option list of all categories */
    $args = array(
	   'type'         => 'post',
	   'orderby'      => 'name',
	   'order'        => 'ASC',
	   'hide_empty'   => 1,
	   'hierarchical' => 1,
	   'taxonomy'     => 'category'
    ); 
    $option_categories = array();
    $category_lists = get_categories( $args );
    $option_categories[''] = __( 'Choose Category', 'business-one-page-pro' );
    foreach( $category_lists as $category ){
        $option_categories[$category->term_id] = $category->name;
    }
    
    /* Option list of all post */	
    $options_posts = array();
    $arg = array( 'posts_per_page' => -1, 'post_type' => array( 'post', 'page' ) );
    $options_posts_obj = get_posts( $arg );
    $options_posts[''] = __( 'Choose Post/Page', 'business-one-page-pro' );
    foreach ( $options_posts_obj as $posts ) {
    	$options_posts[$posts->ID] = $posts->post_title;
    }
    
    Kirki::add_panel( 'business_one_page_pro_slider_settings', array(
        'title'          => __( 'Slider Settings', 'business-one-page-pro' ),
        'priority'       => 23,
        'capability'     => 'edit_theme_options',
    ) );
    
    /** Slider Options */
    Kirki::add_section( 'business_one_page_pro_slider_options', array(
        'title' => __( 'Slider Options', 'business-one-page-pro' ),
        'priority' => 20,
        'panel' => 'business_one_page_pro_slider_settings',
    ) );
    
    /** Enable/Disable Slider */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_ed_slider',
        'label'       => __( 'Enable Home Page Slider', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => '',
    ) );
    
    /** Enable/Disable Slider Auto Transition */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_slider_auto',
        'label'       => __( 'Enable Slider Auto Transition', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => '1',
    ) );
    
    /** Enable/Disable Slider Loop */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_slider_loop',
        'label'       => __( 'Enable Slider Loop', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => '1',
    ) );
    
    /** Enable/Disable Slider Pager */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_slider_pager',
        'label'       => __( 'Enable Slider Pager', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => '1',
    ) );
    
    /** Enable/Disable Slider Caption */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_slider_caption',
        'label'       => __( 'Enable Slider Caption', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => '1',
    ) );
    
    /** Use Full Size Image */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'toggle',
        'settings'    => 'business_one_page_pro_slider_full_image',
        'label'       => __( 'Use Full Size Image', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => '',
    ) );
    
    /** Slider Animation */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_animation',
        'label'       => __( 'Choose Slider Animation', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => 'slide',
        'choices'     => business_one_page_pro_slider_animation_options(),
    ) );
    
    /** Slider Speed */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'slider',
        'settings'    => 'business_one_page_pro_slider_speed',
        'label'       => __( 'Slider Speed', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => 400,
        'choices' => array(
                'min' => 100,
                'max' => 1000,
                'step'=> 100
            )
    ) );
    
    /** Slider Pause */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'slider',
        'settings'    => 'business_one_page_pro_slider_pause',
        'label'       => __( 'Slider Pause', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_options',
        'default'     => 6000,
        'choices' => array(
                'min' => 1000,
                'max' => 10000,
                'step'=> 500
            )
    ) );
    
    /** Slider Contents */
    Kirki::add_section( 'business_one_page_pro_slider_contents', array(
        'title' => __( 'Slider Contents', 'business-one-page-pro' ),
        'priority' => 30,
        'panel' => 'business_one_page_pro_slider_settings',
    ) );
    
    /** Select Slider Type */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_type',
        'label'       => __( 'Choose Slider Type', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => 'post',
        'choices'     => array(
                'post' => __( 'Post/Page', 'business-one-page-pro' ),
                'cat' => __( 'Category', 'business-one-page-pro' ),
                'custom' => __( 'Custom', 'business-one-page-pro' ),
            )
    ) );
    
    /** Select Post One */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_post_one',
        'label'       => __( 'Choose Post One', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'choices'     => $options_posts,
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'post',
            )            
        )
    ) );
    
    /** Select Post Two */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_post_two',
        'label'       => __( 'Choose Post Two', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'choices'     => $options_posts,
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'post',
            )            
        )
    ) );
    /** Select Post Three */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_post_three',
        'label'       => __( 'Choose Post Three', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'choices'     => $options_posts,
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'post',
            )            
        )
    ) );
    
    /** Select Post Four */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_post_four',
        'label'       => __( 'Choose Post Four', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'choices'     => $options_posts,
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'post',
            )            
        )
    ) );
    
    /** Select Post Five */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_post_five',
        'label'       => __( 'Choose Post Five', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'choices'     => $options_posts,
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'post',
            )            
        )
    ) );
    
    /** Select Category */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'select',
        'settings'    => 'business_one_page_pro_slider_cat',
        'label'       => __( 'Choose Slider Category', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'choices'     => $option_categories,
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'cat',
            )            
        )
    ) );
    
    /** Add Slides */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'        => 'repeater',
        'settings'    => 'business_one_page_pro_slider_slides',
        'label'       => __( 'Add Sliders', 'business-one-page-pro' ),
        'section'     => 'business_one_page_pro_slider_contents',
        'default'     => '',
        'fields'     => array(
            'thumbnail' => array(
                'type'  => 'image', 
                'label' => __( 'Add Image', 'business-one-page-pro' ),                
            ),
            'title'     => array(
                'type'  => 'text',
                'label' => __( 'Title', 'business-one-page-pro' ),
            ),
            'link'     => array(
                'type'  => 'text',
                'label' => __( 'Link', 'business-one-page-pro' ),
                
            )
        ),
        'required'  => array(
            array(
                'setting'  => 'business_one_page_pro_slider_type',
                'operator' => '==',
                'value'    => 'custom',
            )            
        ),
        'row_label' => array(
            'type' => 'field', // [default 'text']
            'value' => __( 'slides', 'business-one-page-pro' ),
            'field' => 'title',// [only used if type = field, the field-id must exist in fields and be a text field]
        ),  
    ) );
    
    /** Slider Readmore */
    Kirki::add_field( 'business_one_page_pro', array(
        'type'      => 'text',
        'settings'  => 'business_one_page_pro_slider_readmore',
        'label'     => __( 'Readmore Text', 'business-one-page-pro' ),
        'section'   => 'business_one_page_pro_slider_contents',
        'default'   => __( 'Learn More', 'business-one-page-pro' ),
    ) );
    
}
add_action( 'init', 'business_one_page_pro_customize_register_slider' );