<?php
/**
 * Customizer Custom Code Section 
 * 
 * @package Business_One_Page_Pro
 */

function business_one_page_pro_customize_register_custom_panel(){
    
    if ( version_compare( $GLOBALS['wp_version'], '4.7', '>=' ) ) {
        
        /** Custom Codes */
        Kirki::add_panel( 'business_one_page_pro_custom_code_panel', array(
            'title' => __( 'Custom Codes', 'business-one-page-pro' ),
            'priority' => 121,
            'capability' => 'edit_theme_options',
        ) );
        
        Kirki::add_section( 'business_one_page_pro_custom_settings', array(
            'title'    => __( 'Custom Script', 'business-one-page-pro' ),
            'priority' => 10,
            'panel'    => 'business_one_page_pro_custom_code_panel',
        ) );
        
        /** Custom Script */
        Kirki::add_field( 'business_one_page_pro', array(
            'type'        => 'code',
            'settings'    => 'business_one_page_pro_custom_script',
            'label'       => __( 'Custom Script', 'business-one-page-pro' ),
            'help'        => __( 'Put the script like anlytics or any other here.', 'business-one-page-pro' ),
            'section'     => 'business_one_page_pro_custom_settings',
            'choices'     => array(
                'language' => 'javascript',
                'theme'    => 'monokai',
                'height'   => 250,
            ),
        ) );
        
    }
}
add_action( 'init', 'business_one_page_pro_customize_register_custom_panel' );