<?php
/**
 * Business_One_Page_Pro Theme Customizer.
 * 
 * @package Business_One_Page_Pro
 */

$panels   = array( 'slider', 'home', 'about', 'service', 'contact', 'typography', 'custom' );
$sections = array( 'info', 'demo', 'header', 'general', 'blog', 'post-page', 'post-meta', 'breadcrumb', 'styling', 'sidebar', 'social', 'custom', 'performance','elementor', 'footer' );

foreach( $panels as $p ){
    require get_template_directory() . '/inc/customizer/panels/' . $p . '.php';
}

foreach( $sections as $s ){
    require get_template_directory() . '/inc/customizer/sections/' . $s . '.php';
}

/**
 * Sanitization Functions
*/
require get_template_directory() . '/inc/customizer/sanitization-functions.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function business_one_page_pro_customize_preview_js() {
	$build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
    
	wp_enqueue_script( 'business_one_page_pro_customizer', get_template_directory_uri() . '/js' . $build . '/customizer' . $suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'business_one_page_pro_customize_preview_js' );

/**
 * Configuration sample for the Kirki Customizer
 */
function business_one_page_pro_configuration_sample_styling( $config ) {

    $config['logo_image']   = get_template_directory_uri() . '/images/logo.png';
    $config['description']  = __( 'Business One Page Pro : A Pro theme of Business One Page.', 'business-one-page-pro');
    $config['color_accent'] = '#0B578E';
    $config['color_back']   = '#EFEFEF';
    $config['disable_loader'] = true;

    return $config;

}
add_filter( 'kirki/config', 'business_one_page_pro_configuration_sample_styling' );

/**
 * If you need to include Kirki in your theme,
 * then you may want to consider adding the translations here
 * using your textdomain.
 * 
 * If you're using Kirki as a plugin this is not needed.
 */
add_filter( 'kirki/my_config/l10n', function( $l10n ) {

	$l10n['background-color']      = esc_attr__( 'Background Color', 'business-one-page-pro' );
	$l10n['background-image']      = esc_attr__( 'Background Image', 'business-one-page-pro' );
	$l10n['no-repeat']             = esc_attr__( 'No Repeat', 'business-one-page-pro' );
	$l10n['repeat-all']            = esc_attr__( 'Repeat All', 'business-one-page-pro' );
	$l10n['repeat-x']              = esc_attr__( 'Repeat Horizontally', 'business-one-page-pro' );
	$l10n['repeat-y']              = esc_attr__( 'Repeat Vertically', 'business-one-page-pro' );
	$l10n['inherit']               = esc_attr__( 'Inherit', 'business-one-page-pro' );
	$l10n['background-repeat']     = esc_attr__( 'Background Repeat', 'business-one-page-pro' );
	$l10n['cover']                 = esc_attr__( 'Cover', 'business-one-page-pro' );
	$l10n['contain']               = esc_attr__( 'Contain', 'business-one-page-pro' );
	$l10n['background-size']       = esc_attr__( 'Background Size', 'business-one-page-pro' );
	$l10n['fixed']                 = esc_attr__( 'Fixed', 'business-one-page-pro' );
	$l10n['scroll']                = esc_attr__( 'Scroll', 'business-one-page-pro' );
	$l10n['background-attachment'] = esc_attr__( 'Background Attachment', 'business-one-page-pro' );
	$l10n['left-top']              = esc_attr__( 'Left Top', 'business-one-page-pro' );
	$l10n['left-center']           = esc_attr__( 'Left Center', 'business-one-page-pro' );
	$l10n['left-bottom']           = esc_attr__( 'Left Bottom', 'business-one-page-pro' );
	$l10n['right-top']             = esc_attr__( 'Right Top', 'business-one-page-pro' );
	$l10n['right-center']          = esc_attr__( 'Right Center', 'business-one-page-pro' );
	$l10n['right-bottom']          = esc_attr__( 'Right Bottom', 'business-one-page-pro' );
	$l10n['center-top']            = esc_attr__( 'Center Top', 'business-one-page-pro' );
	$l10n['center-center']         = esc_attr__( 'Center Center', 'business-one-page-pro' );
	$l10n['center-bottom']         = esc_attr__( 'Center Bottom', 'business-one-page-pro' );
	$l10n['background-position']   = esc_attr__( 'Background Position', 'business-one-page-pro' );
	$l10n['background-opacity']    = esc_attr__( 'Background Opacity', 'business-one-page-pro' );
	$l10n['on']                    = esc_attr__( 'ON', 'business-one-page-pro' );
	$l10n['off']                   = esc_attr__( 'OFF', 'business-one-page-pro' );
	$l10n['all']                   = esc_attr__( 'All', 'business-one-page-pro' );
	$l10n['cyrillic']              = esc_attr__( 'Cyrillic', 'business-one-page-pro' );
	$l10n['cyrillic-ext']          = esc_attr__( 'Cyrillic Extended', 'business-one-page-pro' );
	$l10n['devanagari']            = esc_attr__( 'Devanagari', 'business-one-page-pro' );
	$l10n['greek']                 = esc_attr__( 'Greek', 'business-one-page-pro' );
	$l10n['greek-ext']             = esc_attr__( 'Greek Extended', 'business-one-page-pro' );
	$l10n['khmer']                 = esc_attr__( 'Khmer', 'business-one-page-pro' );
	$l10n['latin']                 = esc_attr__( 'Latin', 'business-one-page-pro' );
	$l10n['latin-ext']             = esc_attr__( 'Latin Extended', 'business-one-page-pro' );
	$l10n['vietnamese']            = esc_attr__( 'Vietnamese', 'business-one-page-pro' );
	$l10n['hebrew']                = esc_attr__( 'Hebrew', 'business-one-page-pro' );
	$l10n['arabic']                = esc_attr__( 'Arabic', 'business-one-page-pro' );
	$l10n['bengali']               = esc_attr__( 'Bengali', 'business-one-page-pro' );
	$l10n['gujarati']              = esc_attr__( 'Gujarati', 'business-one-page-pro' );
	$l10n['tamil']                 = esc_attr__( 'Tamil', 'business-one-page-pro' );
	$l10n['telugu']                = esc_attr__( 'Telugu', 'business-one-page-pro' );
	$l10n['thai']                  = esc_attr__( 'Thai', 'business-one-page-pro' );
	$l10n['serif']                 = _x( 'Serif', 'font style', 'business-one-page-pro' );
	$l10n['sans-serif']            = _x( 'Sans Serif', 'font style', 'business-one-page-pro' );
	$l10n['monospace']             = _x( 'Monospace', 'font style', 'business-one-page-pro' );
	$l10n['font-family']           = esc_attr__( 'Font Family', 'business-one-page-pro' );
	$l10n['font-size']             = esc_attr__( 'Font Size', 'business-one-page-pro' );
	$l10n['font-weight']           = esc_attr__( 'Font Weight', 'business-one-page-pro' );
	$l10n['line-height']           = esc_attr__( 'Line Height', 'business-one-page-pro' );
	$l10n['font-style']            = esc_attr__( 'Font Style', 'business-one-page-pro' );
	$l10n['letter-spacing']        = esc_attr__( 'Letter Spacing', 'business-one-page-pro' );
	$l10n['top']                   = esc_attr__( 'Top', 'business-one-page-pro' );
	$l10n['bottom']                = esc_attr__( 'Bottom', 'business-one-page-pro' );
	$l10n['left']                  = esc_attr__( 'Left', 'business-one-page-pro' );
	$l10n['right']                 = esc_attr__( 'Right', 'business-one-page-pro' );
	$l10n['color']                 = esc_attr__( 'Color', 'business-one-page-pro' );
	$l10n['add-image']             = esc_attr__( 'Add Image', 'business-one-page-pro' );
	$l10n['change-image']          = esc_attr__( 'Change Image', 'business-one-page-pro' );
	$l10n['remove']                = esc_attr__( 'Remove', 'business-one-page-pro' );
	$l10n['no-image-selected']     = esc_attr__( 'No Image Selected', 'business-one-page-pro' );
	$l10n['select-font-family']    = esc_attr__( 'Select a font-family', 'business-one-page-pro' );
	$l10n['variant']               = esc_attr__( 'Variant', 'business-one-page-pro' );
	$l10n['subsets']               = esc_attr__( 'Subset', 'business-one-page-pro' );
	$l10n['size']                  = esc_attr__( 'Size', 'business-one-page-pro' );
	$l10n['height']                = esc_attr__( 'Height', 'business-one-page-pro' );
	$l10n['spacing']               = esc_attr__( 'Spacing', 'business-one-page-pro' );
	$l10n['ultra-light']           = esc_attr__( 'Ultra-Light 100', 'business-one-page-pro' );
	$l10n['ultra-light-italic']    = esc_attr__( 'Ultra-Light 100 Italic', 'business-one-page-pro' );
	$l10n['light']                 = esc_attr__( 'Light 200', 'business-one-page-pro' );
	$l10n['light-italic']          = esc_attr__( 'Light 200 Italic', 'business-one-page-pro' );
	$l10n['book']                  = esc_attr__( 'Book 300', 'business-one-page-pro' );
	$l10n['book-italic']           = esc_attr__( 'Book 300 Italic', 'business-one-page-pro' );
	$l10n['regular']               = esc_attr__( 'Normal 400', 'business-one-page-pro' );
	$l10n['italic']                = esc_attr__( 'Normal 400 Italic', 'business-one-page-pro' );
	$l10n['medium']                = esc_attr__( 'Medium 500', 'business-one-page-pro' );
	$l10n['medium-italic']         = esc_attr__( 'Medium 500 Italic', 'business-one-page-pro' );
	$l10n['semi-bold']             = esc_attr__( 'Semi-Bold 600', 'business-one-page-pro' );
	$l10n['semi-bold-italic']      = esc_attr__( 'Semi-Bold 600 Italic', 'business-one-page-pro' );
	$l10n['bold']                  = esc_attr__( 'Bold 700', 'business-one-page-pro' );
	$l10n['bold-italic']           = esc_attr__( 'Bold 700 Italic', 'business-one-page-pro' );
	$l10n['extra-bold']            = esc_attr__( 'Extra-Bold 800', 'business-one-page-pro' );
	$l10n['extra-bold-italic']     = esc_attr__( 'Extra-Bold 800 Italic', 'business-one-page-pro' );
	$l10n['ultra-bold']            = esc_attr__( 'Ultra-Bold 900', 'business-one-page-pro' );
	$l10n['ultra-bold-italic']     = esc_attr__( 'Ultra-Bold 900 Italic', 'business-one-page-pro' );
	$l10n['invalid-value']         = esc_attr__( 'Invalid Value', 'business-one-page-pro' );

	return $l10n;

} );

/**
 * Change the URL that will be used by Kirki
 * to load its assets in the customizer.
 */
if ( ! function_exists( 'business_one_page_pro_kirki_update_url' ) ) {
    function business_one_page_pro_kirki_update_url( $config ) {
        $config['url_path'] = get_template_directory_uri() . '/inc/kirki/';
        return $config;
    }
}
add_filter( 'kirki/config', 'business_one_page_pro_kirki_update_url' );