<?php
/**
 * Business_One_Page_Pro metabox.
 *
 *
 * @package Business_One_Page_Pro
 */

add_action('add_meta_boxes', 'business_one_page_pro_add_sidebar_layout_box');

function business_one_page_pro_add_sidebar_layout_box(){    
    $screens = array( 'post', 'page' );
    foreach ( $screens as $screen ){
        add_meta_box(
                 'business_one_page_pro_sidebar_layout', // $id
                 __( 'Sidebar Layout', 'business-one-page-pro' ), // $title
                 'business_one_page_pro_sidebar_layout_callback', // $callback
                 $screen, // $page
                 'normal', // $context
                 'high' // $priority
        );
    }
    
    // Meta box to add logo link for "Logo"
    add_meta_box(
                 'business_one_page_pro_logo_link', // $id
                 __( 'Logo Link', 'business-one-page-pro' ), // $title
                 'business_one_page_pro_logo_link_callback', // $callback
                 'logo', // $post_type
                 'normal', // $context
                 'low'// $priority
    );  
    
    // Meta box to add designation for "Testimonial"
    add_meta_box(
                 'business_one_page_pro_testimonial_designation', // $id
                 __( 'Designation', 'business-one-page-pro' ), // $title
                 'business_one_page_pro_testimonial_designation_callback', // $callback
                 'testimonial', // $post_type
                 'normal', // $context
                 'high'// $priority
    );
    
    // Meta box to add additional details for "Team"
    add_meta_box(
                 'business_one_page_pro_team_details', // $id
                 __( 'Additional Info', 'business-one-page-pro' ), // $title
                 'business_one_page_pro_team_details_callback', // $callback
                 'team', // $post_type
                 'normal', // $context
                 'high'// $priority
    );
}

$business_one_page_pro_sidebar_layout = array(         
        'default-sidebar' => array(
                                'value' => 'default-sidebar',
                                'thumbnail' => get_template_directory_uri() . '/images/default-sidebar.png'
                            ),
        'left-sidebar' => array(
                                'value' => 'left-sidebar',
                                'thumbnail' => get_template_directory_uri() . '/images/left-sidebar.png'
                            ),
        'right-sidebar' => array(
                                'value' => 'right-sidebar',
                                'thumbnail' => get_template_directory_uri() . '/images/right-sidebar.png'
                            ),
);

function business_one_page_pro_sidebar_layout_callback(){
    global $post, $business_one_page_pro_sidebar_layout;
    wp_nonce_field( basename( __FILE__ ), 'business_one_page_pro_sidebar_layout_nonce' ); 
    $sidebars = business_one_page_pro_get_dynamnic_sidebar( true, true, true );
    $sidebar  = get_post_meta( $post->ID, '_business_one_page_pro_sidebar', true );
?>
<table class="form-table page-meta-box">
    <tr>
        <td colspan="4"><em class="f13"><?php _e( 'Choose Sidebar Template', 'business-one-page-pro' ); ?></em></td>
    </tr>

    <tr>
        <td>
        <?php  
            foreach( $business_one_page_pro_sidebar_layout as $field ){  
                $layout = get_post_meta( $post->ID, '_business_one_page_pro_sidebar_layout', true ); ?>

            <div class="hide-radio radio-image-wrapper" style="float:left; margin-right:30px;">
                <input id="<?php echo esc_attr( $field['value'] ); ?>" type="radio" name="business_one_page_pro_sidebar_layout" value="<?php echo esc_attr( $field['value'] ); ?>" <?php checked( $field['value'], $layout ); if( empty( $layout ) ){ checked( $field['value'], 'default-sidebar' ); }?>/>
                <label class="description" for="<?php echo esc_attr( $field['value'] ); ?>">
                    <img src="<?php echo esc_url( $field['thumbnail'] ); ?>" alt="<?php echo esc_attr( $field['value'] ); ?>" />
                </label>
            </div>
            <?php } // end foreach 
            ?>
            <div class="clear"></div>
        </td>
    </tr>
    
    <tr>
        <td colspan="3"><em class="f13"><?php esc_html_e('Choose Sidebar', 'business-one-page-pro'); ?></em></td>
    </tr>
    
    <tr>
        <td>
            <select name="business_one_page_pro_sidebar">
            <?php 
                foreach( $sidebars as $k => $v ){ ?>
                    <option value="<?php echo esc_attr( $k ); ?>" <?php selected( $sidebar, $k ); if( empty( $sidebar ) && $k == 'default-sidebar' ){ echo "selected='selected'";}?> ><?php echo esc_html( $v ); ?></option>
                <?php }
            ?>
            </select>
        </td>    
    </tr>
    
    <tr>
        <td><em class="f13"><?php printf( esc_html__( 'You can set up the sidebar content from %s', 'business-one-page-pro' ), '<a href="'. esc_url( admin_url( 'widgets.php' ) ) .'">here</a>' ); ?></em></td>
    </tr>
    
</table>
<?php        
}

/**
 * save the custom metabox data
 * @hooked to save_post hook
 */
function business_one_page_pro_save_sidebar_layout( $post_id ) { 
    global $business_one_page_pro_sidebar_layout, $post; 

    // Verify the nonce before proceeding.
    if ( !isset( $_POST[ 'business_one_page_pro_sidebar_layout_nonce' ] ) || !wp_verify_nonce( $_POST[ 'business_one_page_pro_sidebar_layout_nonce' ], basename( __FILE__ ) ) )
        return;

    // Stop WP from clearing custom fields on autosave
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )  
        return;
        
    if ('page' == $_POST['post_type']) {  
        if ( !current_user_can( 'edit_page', $post_id ) )  
            return $post_id;  
    } elseif ( !current_user_can( 'edit_post', $post_id ) ) {  
            return $post_id;  
    }  
    
    // Make sure that it is set.
	if ( ! isset( $_POST['business_one_page_pro_sidebar'] ) ) {
		return;
	}
    
    foreach( $business_one_page_pro_sidebar_layout as $field ){  
        //Execute this saving function
        $old = get_post_meta( $post_id, '_business_one_page_pro_sidebar_layout', true ); 
        $new = sanitize_text_field( $_POST['business_one_page_pro_sidebar_layout'] );
        if ( $new && $new != $old ){  
            update_post_meta( $post_id, '_business_one_page_pro_sidebar_layout', $new );  
        } elseif( '' == $new && $old ){  
            delete_post_meta( $post_id, '_business_one_page_pro_sidebar_layout', $old );  
        } 
    } // end foreach
    
    // Sanitize user input.
	$sidebar = sanitize_text_field( $_POST['business_one_page_pro_sidebar'] );

	// Update the meta field in the database.
	update_post_meta( $post_id, '_business_one_page_pro_sidebar', $sidebar );   
     
}
add_action( 'save_post', 'business_one_page_pro_save_sidebar_layout' ); 

/**
 * Callback for Logo Link
*/
function business_one_page_pro_logo_link_callback(){
    global $post;
    wp_nonce_field( basename( __FILE__ ), 'business_one_page_pro_logo_link_nonce' );
    
    $link = get_post_meta( $post->ID, '_business_one_page_pro_logo_link', true );
    ?>
    <div>
        <div class="clearfix">
            <label class="bold-label float-left input_label" for="business_one_page_pro_logo_link"><?php _e( 'Link', 'business-one-page-pro' ); ?></label>
            <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_logo_link" name="business_one_page_pro_logo_link" value="<?php echo esc_url( $link ); ?>" /></div>
        </div>
    </div>
    <?php    
}

function business_one_page_pro_save_logo_link( $post_id ){
    // Check if our nonce is set.
	if ( ! isset( $_POST['business_one_page_pro_logo_link_nonce'] ) || ! wp_verify_nonce( $_POST['business_one_page_pro_logo_link_nonce'], basename( __FILE__ ) ) ) {
		return;
	}

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) return;		
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) return;
	}
    
    if ( ! isset( $_POST['business_one_page_pro_logo_link'] ) ) {
		return;
	}
    
    // Sanitize user input.
	$link = esc_url_raw( $_POST['business_one_page_pro_logo_link'] );

	// Update the meta field in the database.
	update_post_meta( $post_id, '_business_one_page_pro_logo_link', $link );

}
add_action( 'save_post', 'business_one_page_pro_save_logo_link' );

/**
 * Callback for Testimonail Designation
*/
function business_one_page_pro_testimonial_designation_callback(){
    global $post;
    wp_nonce_field( basename( __FILE__ ), 'business_one_page_pro_testimonial_designation_nonce' );
    
    $designation = get_post_meta( $post->ID, '_business_one_page_pro_testimonial_designation', true );
    ?>
    <div>
        <div class="clearfix">
            <label class="bold-label float-left input_label" for="business_one_page_pro_testimonial_designation"><?php _e( 'Designation', 'business-one-page-pro' ); ?></label>
            <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_testimonial_designation" name="business_one_page_pro_testimonial_designation" value="<?php echo esc_attr( $designation ); ?>" /></div>
        </div>
    </div>
    <?php
}

function business_one_page_pro_save_testimonial_designation( $post_id ){
    // Check if our nonce is set.
	if ( ! isset( $_POST['business_one_page_pro_testimonial_designation_nonce'] ) || ! wp_verify_nonce( $_POST['business_one_page_pro_testimonial_designation_nonce'], basename( __FILE__ ) ) ) {
		return;
	}

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) return;		
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) return;
	}
    
    if ( ! isset( $_POST['business_one_page_pro_testimonial_designation'] ) ) {
		return;
	}
    
    // Sanitize user input.
	$designation = sanitize_text_field( $_POST['business_one_page_pro_testimonial_designation'] );

	// Update the meta field in the database.
	update_post_meta( $post_id, '_business_one_page_pro_testimonial_designation', $designation );

}
add_action( 'save_post', 'business_one_page_pro_save_testimonial_designation' );

/**
 * Callback for Additional Info for Team
*/
function business_one_page_pro_team_details_callback(){
    global $post;
    wp_nonce_field( basename( __FILE__ ), 'business_one_page_pro_team_details_nonce' );
    
    $designation = get_post_meta( $post->ID, '_business_one_page_pro_team_designation', true );
    $facebook    = get_post_meta( $post->ID, '_business_one_page_pro_team_facebook', true );
    $twitter     = get_post_meta( $post->ID, '_business_one_page_pro_team_twitter', true );
    $dribble     = get_post_meta( $post->ID, '_business_one_page_pro_team_dribble', true );
    $linkedin    = get_post_meta( $post->ID, '_business_one_page_pro_team_linkedin', true );
    $pinterest   = get_post_meta( $post->ID, '_business_one_page_pro_team_pinterest', true );
    ?>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="business_one_page_pro_team_designation"><?php _e( 'Designation', 'business-one-page-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_team_designation" name="business_one_page_pro_team_designation" value="<?php echo esc_attr( $designation ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="business_one_page_pro_team_facebook"><?php _e( 'Facebook', 'business-one-page-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_team_facebook" name="business_one_page_pro_team_facebook" value="<?php echo esc_url( $facebook ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="business_one_page_pro_team_twitter"><?php _e( 'Twitter', 'business-one-page-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_team_twitter" name="business_one_page_pro_team_twitter" value="<?php echo esc_url( $twitter ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="business_one_page_pro_team_dribble"><?php _e( 'Dribble', 'business-one-page-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_team_dribble" name="business_one_page_pro_team_dribble" value="<?php echo esc_url( $dribble ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="business_one_page_pro_team_linkedin"><?php _e( 'Linkedin', 'business-one-page-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_team_linkedin" name="business_one_page_pro_team_linkedin" value="<?php echo esc_url( $linkedin ); ?>" /></div>
    </div>
    
    <div class="clearfix">
        <label class="bold-label float-left input_label" for="business_one_page_pro_team_pinterest"><?php _e( 'Pinterest', 'business-one-page-pro' ); ?></label>
        <div class="below_row_input float-left"><input type="text" id="business_one_page_pro_team_pinterest" name="business_one_page_pro_team_pinterest" value="<?php echo esc_url( $pinterest ); ?>" /></div>
    </div>
    <?php
}

function business_one_page_pro_save_team_details( $post_id ){
    // Check if our nonce is set.
	if ( ! isset( $_POST['business_one_page_pro_team_details_nonce'] ) || ! wp_verify_nonce( $_POST['business_one_page_pro_team_details_nonce'], basename( __FILE__ ) ) ) {
		return;
	}

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) return;		
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) return;
	}
    
    if ( ! isset( $_POST['business_one_page_pro_team_designation'] ) && ! isset( $_POST['business_one_page_pro_team_facebook'] ) && ! isset( $_POST['business_one_page_pro_team_twitter'] ) && ! isset( $_POST['business_one_page_pro_team_dribble'] ) && ! isset( $_POST['business_one_page_pro_team_linkedin'] ) && ! isset( $_POST['business_one_page_pro_team_pinterest'] ) ) {
		return;
	}
    
    // Sanitize user input.
	$designation = sanitize_text_field( $_POST['business_one_page_pro_team_designation'] );    
    $facebook    = esc_url_raw( $_POST['business_one_page_pro_team_facebook'] );
    $twitter     = esc_url_raw( $_POST['business_one_page_pro_team_twitter'] );
    $dribble     = esc_url_raw( $_POST['business_one_page_pro_team_dribble'] );
    $linkedin    = esc_url_raw( $_POST['business_one_page_pro_team_linkedin'] );
    $pinterest   = esc_url_raw( $_POST['business_one_page_pro_team_pinterest'] );

	// Update the meta field in the database.
	update_post_meta( $post_id, '_business_one_page_pro_team_designation', $designation );
    update_post_meta( $post_id, '_business_one_page_pro_team_facebook', $facebook );
    update_post_meta( $post_id, '_business_one_page_pro_team_twitter', $twitter );
    update_post_meta( $post_id, '_business_one_page_pro_team_dribble', $dribble );
    update_post_meta( $post_id, '_business_one_page_pro_team_linkedin', $linkedin );
    update_post_meta( $post_id, '_business_one_page_pro_team_pinterest', $pinterest );
    

}
add_action( 'save_post', 'business_one_page_pro_save_team_details' );