<?php
/**
 * Rara Theme custom post and taxonomy definitions.
 *
 * @link https://codex.wordpress.org/Function_Reference/register_post_type
 * @link https://codex.wordpress.org/Function_Reference/register_taxonomy
 *
 * @package Rara_Theme
 */
 
if ( ! function_exists('business_one_page_pro_logo_post_type') ) :
/**
 *  Client Logo Post Type
*/
function business_one_page_pro_logo_post_type() {

	$labels = array(
		'name'                  => _x( 'Logos', 'Post Type General Name', 'business-one-page-pro' ),
		'singular_name'         => _x( 'Logo', 'Post Type Singular Name', 'business-one-page-pro' ),
		'menu_name'             => __( 'Logos', 'business-one-page-pro' ),
		'name_admin_bar'        => __( 'Logo', 'business-one-page-pro' ),
		'archives'              => __( 'Logo Archives', 'business-one-page-pro' ),
		'attributes'            => __( 'Logo Attributes', 'business-one-page-pro' ),
		'parent_item_colon'     => __( 'Parent Logo:', 'business-one-page-pro' ),
		'all_items'             => __( 'All Logos', 'business-one-page-pro' ),
		'add_new_item'          => __( 'Add New Logo', 'business-one-page-pro' ),
		'add_new'               => __( 'Add New', 'business-one-page-pro' ),
		'new_item'              => __( 'New Logo', 'business-one-page-pro' ),
		'edit_item'             => __( 'Edit Logo', 'business-one-page-pro' ),
		'update_item'           => __( 'Update Logo', 'business-one-page-pro' ),
		'view_item'             => __( 'View Logo', 'business-one-page-pro' ),
		'view_items'            => __( 'View Logos', 'business-one-page-pro' ),
		'search_items'          => __( 'Search Logo', 'business-one-page-pro' ),
		'not_found'             => __( 'Not found', 'business-one-page-pro' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'business-one-page-pro' ),
		'featured_image'        => __( 'Featured Image', 'business-one-page-pro' ),
		'set_featured_image'    => __( 'Set featured image', 'business-one-page-pro' ),
		'remove_featured_image' => __( 'Remove featured image', 'business-one-page-pro' ),
		'use_featured_image'    => __( 'Use as featured image', 'business-one-page-pro' ),
		'insert_into_item'      => __( 'Insert into logo', 'business-one-page-pro' ),
		'uploaded_to_this_item' => __( 'Uploaded to this logo', 'business-one-page-pro' ),
		'items_list'            => __( 'Logos list', 'business-one-page-pro' ),
		'items_list_navigation' => __( 'Logos list navigation', 'business-one-page-pro' ),
		'filter_items_list'     => __( 'Filter logos list', 'business-one-page-pro' ),
	);
	$args = array(
		'label'                 => __( 'Logo', 'business-one-page-pro' ),
		'description'           => __( 'A Custom post type for client logos', 'business-one-page-pro' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'thumbnail', ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-images-alt2',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,		
		'exclude_from_search'   => true,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'logo', $args );

}
add_action( 'init', 'business_one_page_pro_logo_post_type', 0 );
endif;

if ( ! function_exists('business_one_page_pro_portfolio_post_type') ) :
/**
 * Portfolio Post Type
*/
function business_one_page_pro_portfolio_post_type() {

	$labels = array(
		'name'                  => _x( 'Portfolios', 'Post Type General Name', 'business-one-page-pro' ),
		'singular_name'         => _x( 'Portfolio', 'Post Type Singular Name', 'business-one-page-pro' ),
		'menu_name'             => __( 'Portfolios', 'business-one-page-pro' ),
		'name_admin_bar'        => __( 'Portfolio', 'business-one-page-pro' ),
		'archives'              => __( 'Portfolio Archives', 'business-one-page-pro' ),
		'attributes'            => __( 'Portfolio Attributes', 'business-one-page-pro' ),
		'parent_item_colon'     => __( 'Parent Portfolio:', 'business-one-page-pro' ),
		'all_items'             => __( 'All Portfolios', 'business-one-page-pro' ),
		'add_new_item'          => __( 'Add New Portfolio', 'business-one-page-pro' ),
		'add_new'               => __( 'Add New', 'business-one-page-pro' ),
		'new_item'              => __( 'New Portfolio', 'business-one-page-pro' ),
		'edit_item'             => __( 'Edit Portfolio', 'business-one-page-pro' ),
		'update_item'           => __( 'Update Portfolio', 'business-one-page-pro' ),
		'view_item'             => __( 'View Portfolio', 'business-one-page-pro' ),
		'view_items'            => __( 'View Portfolios', 'business-one-page-pro' ),
		'search_items'          => __( 'Search Portfolio', 'business-one-page-pro' ),
		'not_found'             => __( 'Not found', 'business-one-page-pro' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'business-one-page-pro' ),
		'featured_image'        => __( 'Featured Image', 'business-one-page-pro' ),
		'set_featured_image'    => __( 'Set featured image', 'business-one-page-pro' ),
		'remove_featured_image' => __( 'Remove featured image', 'business-one-page-pro' ),
		'use_featured_image'    => __( 'Use as featured image', 'business-one-page-pro' ),
		'insert_into_item'      => __( 'Insert into portfolio', 'business-one-page-pro' ),
		'uploaded_to_this_item' => __( 'Uploaded to this portfolio', 'business-one-page-pro' ),
		'items_list'            => __( 'Portfolios list', 'business-one-page-pro' ),
		'items_list_navigation' => __( 'Portfolios list navigation', 'business-one-page-pro' ),
		'filter_items_list'     => __( 'Filter portfolios list', 'business-one-page-pro' ),
	);
	$args = array(
		'label'                 => __( 'Portfolio', 'business-one-page-pro' ),
		'description'           => __( 'A Custom post type for Portfolios', 'business-one-page-pro' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'excerpt', 'thumbnail', ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-portfolio',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'portfolio', $args );

}
add_action( 'init', 'business_one_page_pro_portfolio_post_type', 0 );
endif;

if ( ! function_exists( 'business_one_page_pro_portfolio_taxonomy' ) ) :
/**
 * taxonomy, portfolio category for the post type "portfolio"
 */
function business_one_page_pro_portfolio_taxonomy() {

	$labels = array(
		'name'                       => _x( 'Portfolio Categories', 'Taxonomy General Name', 'business-one-page-pro' ),
		'singular_name'              => _x( 'Portfolio Category', 'Taxonomy Singular Name', 'business-one-page-pro' ),
		'menu_name'                  => __( 'Portfolio Category', 'business-one-page-pro' ),
		'all_items'                  => __( 'All Portfolio Categories', 'business-one-page-pro' ),
		'parent_item'                => __( 'Parent Portfolio Category', 'business-one-page-pro' ),
		'parent_item_colon'          => __( 'Parent Portfolio Category:', 'business-one-page-pro' ),
		'new_item_name'              => __( 'New Portfolio Category Name', 'business-one-page-pro' ),
		'add_new_item'               => __( 'Add New Portfolio Category', 'business-one-page-pro' ),
		'edit_item'                  => __( 'Edit Portfolio Category', 'business-one-page-pro' ),
		'update_item'                => __( 'Update Portfolio Category', 'business-one-page-pro' ),
		'view_item'                  => __( 'View Portfolio Category', 'business-one-page-pro' ),
		'separate_items_with_commas' => __( 'Separate portfolio categories with commas', 'business-one-page-pro' ),
		'add_or_remove_items'        => __( 'Add or remove portfolio categories', 'business-one-page-pro' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'business-one-page-pro' ),
		'popular_items'              => __( 'Popular Portfolio Categories', 'business-one-page-pro' ),
		'search_items'               => __( 'Search Portfolio Categories', 'business-one-page-pro' ),
		'not_found'                  => __( 'Not Found', 'business-one-page-pro' ),
		'no_terms'                   => __( 'No portfolio categories', 'business-one-page-pro' ),
		'items_list'                 => __( 'Portfolio Categories list', 'business-one-page-pro' ),
		'items_list_navigation'      => __( 'Portfolio Categories list navigation', 'business-one-page-pro' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
	);
	register_taxonomy( 'portfolio-category', array( 'portfolio' ), $args );

}
add_action( 'init', 'business_one_page_pro_portfolio_taxonomy', 0 );
endif;

if ( ! function_exists('business_one_page_pro_testimonial_post_type') ) :
/**
 * Testimonail Post Types
*/
function business_one_page_pro_testimonial_post_type() {

	$labels = array(
		'name'                  => _x( 'Testimonials', 'Post Type General Name', 'business-one-page-pro' ),
		'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'business-one-page-pro' ),
		'menu_name'             => __( 'Testimonials', 'business-one-page-pro' ),
		'name_admin_bar'        => __( 'Testimonial', 'business-one-page-pro' ),
		'archives'              => __( 'Testimonial Archives', 'business-one-page-pro' ),
		'attributes'            => __( 'Testimonial Attributes', 'business-one-page-pro' ),
		'parent_item_colon'     => __( 'Parent Testimonial:', 'business-one-page-pro' ),
		'all_items'             => __( 'All Testimonials', 'business-one-page-pro' ),
		'add_new_item'          => __( 'Add New Testimonial', 'business-one-page-pro' ),
		'add_new'               => __( 'Add New', 'business-one-page-pro' ),
		'new_item'              => __( 'New Testimonial', 'business-one-page-pro' ),
		'edit_item'             => __( 'Edit Testimonial', 'business-one-page-pro' ),
		'update_item'           => __( 'Update Testimonial', 'business-one-page-pro' ),
		'view_item'             => __( 'View Testimonial', 'business-one-page-pro' ),
		'view_items'            => __( 'View Testimonials', 'business-one-page-pro' ),
		'search_items'          => __( 'Search Testimonial', 'business-one-page-pro' ),
		'not_found'             => __( 'Not found', 'business-one-page-pro' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'business-one-page-pro' ),
		'featured_image'        => __( 'Featured Image', 'business-one-page-pro' ),
		'set_featured_image'    => __( 'Set featured image', 'business-one-page-pro' ),
		'remove_featured_image' => __( 'Remove featured image', 'business-one-page-pro' ),
		'use_featured_image'    => __( 'Use as featured image', 'business-one-page-pro' ),
		'insert_into_item'      => __( 'Insert into testimonial', 'business-one-page-pro' ),
		'uploaded_to_this_item' => __( 'Uploaded to this testimonial', 'business-one-page-pro' ),
		'items_list'            => __( 'Testimonials list', 'business-one-page-pro' ),
		'items_list_navigation' => __( 'Testimonials list navigation', 'business-one-page-pro' ),
		'filter_items_list'     => __( 'Filter testimonials list', 'business-one-page-pro' ),
	);
	$args = array(
		'label'                 => __( 'Testimonial', 'business-one-page-pro' ),
		'description'           => __( 'A Custom post type for Testimonial', 'business-one-page-pro' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 10,
		'menu_icon'             => 'dashicons-testimonial',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'testimonial', $args );

}
add_action( 'init', 'business_one_page_pro_testimonial_post_type', 0 );
endif;

if ( ! function_exists('business_one_page_pro_team_post_type') ) :
/**
 * Team Post Types 
*/
function business_one_page_pro_team_post_type() {

	$labels = array(
		'name'                  => _x( 'Teams', 'Post Type General Name', 'business-one-page-pro' ),
		'singular_name'         => _x( 'Team', 'Post Type Singular Name', 'business-one-page-pro' ),
		'menu_name'             => __( 'Teams', 'business-one-page-pro' ),
		'name_admin_bar'        => __( 'Team', 'business-one-page-pro' ),
		'archives'              => __( 'Team Archives', 'business-one-page-pro' ),
		'attributes'            => __( 'Team Attributes', 'business-one-page-pro' ),
		'parent_item_colon'     => __( 'Parent Team:', 'business-one-page-pro' ),
		'all_items'             => __( 'All Teams', 'business-one-page-pro' ),
		'add_new_item'          => __( 'Add New Team', 'business-one-page-pro' ),
		'add_new'               => __( 'Add New', 'business-one-page-pro' ),
		'new_item'              => __( 'New Team', 'business-one-page-pro' ),
		'edit_item'             => __( 'Edit Team', 'business-one-page-pro' ),
		'update_item'           => __( 'Update Team', 'business-one-page-pro' ),
		'view_item'             => __( 'View Team', 'business-one-page-pro' ),
		'view_items'            => __( 'View Teams', 'business-one-page-pro' ),
		'search_items'          => __( 'Search Team', 'business-one-page-pro' ),
		'not_found'             => __( 'Not found', 'business-one-page-pro' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'business-one-page-pro' ),
		'featured_image'        => __( 'Featured Image', 'business-one-page-pro' ),
		'set_featured_image'    => __( 'Set featured image', 'business-one-page-pro' ),
		'remove_featured_image' => __( 'Remove featured image', 'business-one-page-pro' ),
		'use_featured_image'    => __( 'Use as featured image', 'business-one-page-pro' ),
		'insert_into_item'      => __( 'Insert into team', 'business-one-page-pro' ),
		'uploaded_to_this_item' => __( 'Uploaded to this team', 'business-one-page-pro' ),
		'items_list'            => __( 'Teams list', 'business-one-page-pro' ),
		'items_list_navigation' => __( 'Teams list navigation', 'business-one-page-pro' ),
		'filter_items_list'     => __( 'Filter teams list', 'business-one-page-pro' ),
	);
	$args = array(
		'label'                 => __( 'Team', 'business-one-page-pro' ),
		'description'           => __( 'A Custom post type for Team', 'business-one-page-pro' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 10,
		'menu_icon'             => 'dashicons-groups',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
	);
	register_post_type( 'team', $args );

}
add_action( 'init', 'business_one_page_pro_team_post_type', 0 );
endif;

if( ! function_exists( 'business_one_page_pro_portfolio_category_filter' ) ) :
/**
 * Function to list portfolio category filter in admin
*/
function business_one_page_pro_portfolio_category_filter() {

    // only display these taxonomy filters on desired custom post_type listings
    global $typenow;
    
    if( $typenow == 'portfolio' ){

        // create an array of taxonomy slugs you want to filter by - if you want to retrieve all taxonomies, could use get_taxonomies() to build the list
        $filters = array( 'portfolio-category' );

        foreach( $filters as $tax_slug ) {
            // retrieve the taxonomy object
            $tax_obj = get_taxonomy( $tax_slug );
            $tax_name = $tax_obj->labels->name;
            
            // Get taxonomy terms and order by name.
            $args = array(
                'orderby' => 'name',
                'hide_empty' => false
            );
                    
            // retrieve array of term objects per taxonomy
            $terms = get_terms( $tax_slug, $args );

            // output html for taxonomy dropdown filter
            echo "<select name='$tax_slug' id='$tax_slug' class='postform'>";
            // Default show all.
            printf( '<option value="0">%s</option>', sprintf( __( 'Show All %s', 'business-one-page-pro' ), $tax_name ) );

            foreach( $terms as $term ){
                if ( isset( $_GET[ $tax_slug ] ) && $_GET[ $tax_slug ] === $term->slug ) {
                    echo '<option value='. $term->slug . ' selected="selected">' . $term->name .' (' . $term->count .')</option>';
                }else{
                    echo '<option value='. $term->slug . '>' . $term->name .' (' . $term->count .')</option>';
                }
            }
            echo "</select>";
        }
    }
}
add_action( 'restrict_manage_posts', 'business_one_page_pro_portfolio_category_filter' );
endif;