<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Business_One_Page_Pro
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head itemscope itemtype="http://schema.org/WebSite">
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> itemscope itemtype="http://schema.org/WebPage">

<?php
    wp_body_open();

    /**
     * @hooked business_one_page_pro_fb_page_box_cb
    */
    do_action( 'business_one_page_pro_fb_page_box' );
    ?>
    <div id="page" class="site">
        <div id="mobile-masthead" class="mobile-site-header">
                <div class="container">
                    <div class="mobile-site-branding" itemscope itemtype="http://schema.org/Organization">                         
                        <?php 
                            if( function_exists( 'has_custom_logo' ) && has_custom_logo() ){
                                the_custom_logo();
                            } 
                        ?>
                        <div class="text-logo">
                            <p class="site-title" itemprop="name"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" itemprop="url"><?php bloginfo( 'name' ); ?></a></p>
                            <?php                        
                                $description = get_bloginfo( 'description', 'display' );
                                if ( $description || is_customize_preview() ) : ?>
                                    <p class="site-description" itemprop="description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
                            <?php endif; ?>
                        </div>
                    </div><!-- .mobile-site-branding -->

                    <div class="right">
                        <?php business_one_page_pro_polylang_language_switcher(); ?>
                        <div class="btn-menu-opener">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </div>
                <div class="mobile-menu">
                <?php 
                    $enabled_sections = business_one_page_pro_get_sections();
                    $ed_section_menu  = get_theme_mod( 'business_one_page_pro_ed_section_menu' );
                    $home_link        = get_theme_mod( 'business_one_page_pro_ed_home_link' );
                    $home_link_label  = get_theme_mod( 'business_one_page_pro_home_link_label', __( 'Home', 'business-one-page-pro' ) );
                        
                    if( $enabled_sections && ( 'page' == get_option( 'show_on_front' ) ) && ( $ed_section_menu != 1 ) ){ ?>
                        <nav id="mobile-site-navigation" class="mobile-main-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
                            <ul>
                                <?php if( ! $home_link ){ ?>
                                    <li class="<?php if( is_front_page() ) echo esc_attr( 'current-menu-item' ); ?>"><a href="<?php echo esc_url( home_url( '#home' ) ); ?>"><?php echo esc_html( $home_link_label ); ?></a></li>
                                <?php }
                                foreach( $enabled_sections as $section ){ 
                                    if( $section['menu_text'] ){ ?>
                                        <li><a href="<?php echo esc_url( home_url( '#' . esc_attr( $section['id'] ) ) ); ?>"><?php echo esc_html( $section['menu_text'] );?></a></li>                        
                                    <?php 
                                    } 
                                }?>
                            </ul>
                        </nav>
                        <?php 
                    }else{ ?>
                        <nav id="mobile-site-navigation" class="mobile-main-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
                            <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
                        </nav><!-- #mobile-site-navigation -->
                        <?php 
                    } 
                    
                    if( has_nav_menu( 'top' ) ){ ?>
                        <nav class="secondary-mobile-menu" id="secondary-mobile-navigation">
                            <?php wp_nav_menu( array( 'theme_location' => 'top', 'menu_id' => 'top-menu', 'fallback_cb' => false ) ); ?>
                        </nav>
                        <?php 
                    }
                    
                    if( get_theme_mod( 'business_one_page_pro_ed_social_header' ) ) do_action( 'business_one_page_pro_social' ); ?>
                </div>
            </div> <!-- .mobile-site-header -->
	
        <?php if( is_front_page() ) echo '<div id="home">'; ?>
                    
            <header id="masthead" class="site-header" role="banner" itemscope itemtype="http://schema.org/WPHeader">
        	
                <?php
                /**
                 * Functions hooked into business_one_page_pro_header action
                 * 
                 * @hooked business_one_page_pro_top_header     - 10
                 * @hooked business_one_page_pro_bottom_header  - 20
                */
                
                do_action( 'business_one_page_pro_header' );
                ?>
            </header><!-- #masthead -->
        
            <?php 
                /**
                 * Function hooked into business_one_page_pro_slider action
                 * 
                 * @hooked business_one_page_pro_slider_cb
                */
                if( is_front_page() ){                 
                    if( get_theme_mod( 'business_one_page_pro_ed_slider' ) ){ 
                        do_action( 'business_one_page_pro_slider' );
                    }else{
                        echo '<div class="banner"></div>';
                    }
                } 
            ?>        
        <?php if( is_front_page() ) echo '</div>'; ?><!-- #home -->
    
        <?php
        /**
         * Function hooked into business_one_page_pro_wrapper_start action
         * 
         * @hooked business_one_page_pro_outer_wrapper_start    - 10
         * @hooked business_one_page_pro_top_section            - 20
         * @hooked business_one_page_pro_wrapper_start_cb       - 30
        */
        do_action( 'business_one_page_pro_wrapper_start' );