<?php
/**
 * Business One Page Pro functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Business_One_Page_Pro
 */

$theme_data = wp_get_theme();
if( ! defined( 'BUSINESS_ONE_PAGE_PRO_THEME_VERSION' ) ) define ( 'BUSINESS_ONE_PAGE_PRO_THEME_VERSION', $theme_data->get( 'Version' ) );
if( ! defined( 'BUSINESS_ONE_PAGE_PRO_THEME_NAME' ) ) define( 'BUSINESS_ONE_PAGE_PRO_THEME_NAME', $theme_data->get( 'Name' ) );

/**
 * Custom template functions for this theme.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Custom functions for this theme.
 */
require get_template_directory() . '/inc/custom-functions.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
* If Kirki is not already installed, use the included version
*/
if ( ! class_exists( 'Kirki' ) ) {    
    require get_template_directory() . '/inc/kirki/kirki.php';
}

/**
 * Custom Control
 */
require get_template_directory() . '/inc/custom-controls/custom-control.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Custom Post 
 */
require get_template_directory() . '/inc/cpt/custom-post.php';

/**
 * Post Meta Box
 */
require get_template_directory() . '/inc/cpt/metabox.php';

/**
 * Widgets
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
 * Shortcodes
*/
require get_template_directory() . '/inc/shortcodes.php';

/**
 * Performance Feature
*/
require get_template_directory() . '/inc/performance.php';

if( is_woocommerce_activated() ){
	/**
	 * WooCommerce
	*/
	require get_template_directory() . '/inc/woocommerce-functions.php';
}

/**
 * Typography Functions
*/
require get_template_directory() . '/inc/typography-functions.php';

/**
 * Dynamic Styles
*/
require get_template_directory() . '/css/style.php';

/**
 * Demo Import
*/
require get_template_directory() . '/inc/import-hooks.php';

/**
 * Plugin Recommendation
*/
require get_template_directory() . '/inc/tgmpa/recommended-plugins.php';

/**
 * Getting Started
*/
require get_template_directory() . '/inc/getting-started/getting-started.php';