<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Business_One_Page_Pro
 */

$char_length = get_theme_mod( 'business_one_page_pro_post_no_of_char', 200 );
$read_more   = get_theme_mod( 'business_one_page_pro_post_read_more', __( 'Read More', 'business-one-page-pro' ) );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
    <?php if( has_post_thumbnail() ){ ?>
    <a href="<?php the_permalink(); ?>" class="post-thumbnail">
        <?php the_post_thumbnail( 'business-one-page-pro-blog-small' ); ?>
    </a>
    <?php } ?>
    <div class="text-holder">
        <header class="entry-header">
    		    
    		<?php if ( 'post' === get_post_type() ) : ?>
    		<div class="entry-meta">
    			<?php business_one_page_pro_posted_on(); ?>
    		</div><!-- .entry-meta -->
    		<?php endif; ?>
            
            <?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
            
    	</header><!-- .entry-header -->
    
    	<div class="entry-content">
    		<?php 
                if( has_excerpt() ){
                    the_excerpt();
                }else{
                    echo wpautop( wp_kses_post( business_one_page_pro_excerpt( get_the_content(), $char_length, '...' ) ) );
                } 
            ?>
            <a href="<?php the_permalink(); ?>" class="btn-readmore"><?php echo esc_html( $read_more ); ?></a>
    	</div><!-- .entry-summary -->
        
    </div>
</article><!-- #post-## -->
