<?php
/**
 * Template part for displaying Portfolio Section
 *
 * @package Business_One_Page_Pro
 */

$portfolio_page       = get_theme_mod( 'business_one_page_pro_portfolio_section_page' );
$portfolio_post_one   = get_theme_mod( 'business_one_page_pro_portfolio_section_post_one' );
$portfolio_post_two   = get_theme_mod( 'business_one_page_pro_portfolio_section_post_two' );
$portfolio_post_three = get_theme_mod( 'business_one_page_pro_portfolio_section_post_three' );
$portfolio_post_four  = get_theme_mod( 'business_one_page_pro_portfolio_section_post_four' );
$portfolio_post_five  = get_theme_mod( 'business_one_page_pro_portfolio_section_post_five' );
$portfolio_read_more  = get_theme_mod( 'business_one_page_pro_portfolio_read_more', __( 'Learn More', 'business-one-page-pro' ) );
$portfolio_char       = get_theme_mod( 'business_one_page_pro_portfolio_no_of_char', 60 );  
$portfolio_view_all   = get_theme_mod( 'business_one_page_pro_portfolio_view_all', __( 'View More Portfolio', 'business-one-page-pro' ) );

$portfolio_posts = array( $portfolio_post_one, $portfolio_post_two, $portfolio_post_three, $portfolio_post_four, $portfolio_post_five );
$portfolio_posts = array_diff( array_unique( $portfolio_posts ), array('') );

if( $portfolio_page || $portfolio_posts ){ ?>
<section id="portfolio">
    <div class="container">
    <?php    
        if( $portfolio_page ){
            $portfolio_qry = new WP_Query( array( 'page_id' => $portfolio_page ) );
        
            if( $portfolio_qry->have_posts() ){
                while( $portfolio_qry->have_posts() ){
                    $portfolio_qry->the_post();
                ?>
                    <header class="heading">
                    	<?php 
                            the_title( '<h1>', '</h1>' ); 
                            if( has_excerpt() ){ 
                                the_excerpt();
                            }else{
                                echo wpautop( business_one_page_pro_excerpt( get_the_content(), 100, '...' ) );
                            } 
                        ?>
                    </header>
                <?php            
                }
            }
            wp_reset_postdata();
        }

        if( $portfolio_posts ){
            $i = 1;
            ?>
            <div class="portfolio-holder">
                <div class="row js-masonry">
                <?php
                $portfolio_query = new WP_Query( array( 'post_type' => 'portfolio', 'post__in' => $portfolio_posts, 'orderby' => 'post__in', 'posts_per_page' => -1 ) );
                if( $portfolio_query->have_posts() ){                
                    while( $portfolio_query->have_posts() ){
                        $portfolio_query->the_post();
                        if( has_post_thumbnail() ){                        
                            $img_size = 'business-one-page-pro-360x380';
                            if( $i == 1 ) $img_size = 'business-one-page-pro-360x340';
                            if( $i == 2 ) $img_size = 'business-one-page-pro-with-sidebar';
                            if( $i == 3 ) $img_size = 'business-one-page-pro-360x500';
                    ?>
                        <div class="portfolio-col">
        					<div class="img-holder">
        						<?php the_post_thumbnail( $img_size );?>
        						<div class="text">
        							<div class="box">
        								<div class="holder">
        									<div class="frame">
        										<?php 
                                                    the_title( '<strong class="title">', '</strong>' ); 
                                                    business_one_page_pro_portfolio_categories(); 
                                                    if( has_excerpt() ){
                                                        the_excerpt();     
                                                    }else{
                                                        echo wpautop( wp_filter_post_kses( business_one_page_pro_excerpt( get_the_content(), $portfolio_char, '...' ) ) );
                                                    } 
                                                    ?>
        										<a href="<?php the_permalink(); ?>" class="btn-more"><?php echo esc_html( $portfolio_read_more ); ?></a>
        									</div>
        								</div>
        							</div>
        						</div>
        					</div>
        				</div>
                    <?php }
                    $i++; 
                    }
                    wp_reset_postdata();
                }
                ?>
                </div>
            </div>
            <?php
        }
        
        if( $portfolio_page ) echo '<div class="btn-holder"><a href="' . esc_url( get_permalink( $portfolio_page ) ) . '">' . esc_html( $portfolio_view_all ) . '</a></div>';
        
        ?>
        
        
    </div>
</section>
<?php
}    			